/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.geospatial.aggregation;

import com.esri.core.geometry.ogc.OGCGeometry;
import io.trino.operator.aggregation.state.StateCompiler;
import io.trino.plugin.geospatial.GeometryType;
import io.trino.plugin.geospatial.aggregation.GeometryState;
import io.trino.plugin.geospatial.aggregation.GeometryStateFactory;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AccumulatorState;
import io.trino.spi.function.AccumulatorStateFactory;
import io.trino.spi.function.AccumulatorStateSerializer;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestGeometryStateSerializer {
    @Test
    public void testSerializeDeserialize() {
        AccumulatorStateFactory factory = StateCompiler.generateStateFactory(GeometryState.class);
        AccumulatorStateSerializer serializer = StateCompiler.generateStateSerializer(GeometryState.class);
        GeometryState state = (GeometryState)factory.createSingleState();
        state.setGeometry(OGCGeometry.fromText((String)"POINT (1 2)"));
        BlockBuilder builder = GeometryType.GEOMETRY.createBlockBuilder(null, 1);
        serializer.serialize((AccumulatorState)state, builder);
        Block block = builder.build();
        Assert.assertEquals((Object)GeometryType.GEOMETRY.getObjectValue(null, block, 0), (Object)"POINT (1 2)");
        state.setGeometry(null);
        serializer.deserialize(block, 0, (AccumulatorState)state);
        Assert.assertEquals((String)state.getGeometry().asText(), (String)"POINT (1 2)");
    }

    @Test
    public void testSerializeDeserializeGrouped() {
        AccumulatorStateFactory factory = StateCompiler.generateStateFactory(GeometryState.class);
        AccumulatorStateSerializer serializer = StateCompiler.generateStateSerializer(GeometryState.class);
        GeometryStateFactory.GroupedGeometryState state = (GeometryStateFactory.GroupedGeometryState)factory.createGroupedState();
        state.setGroupId(1L);
        state.setGeometry(OGCGeometry.fromText((String)"POINT (1 2)"));
        state.setGroupId(2L);
        state.setGeometry(OGCGeometry.fromText((String)"POINT (2 3)"));
        state.setGroupId(1L);
        BlockBuilder builder = GeometryType.GEOMETRY.createBlockBuilder(null, 1);
        serializer.serialize((AccumulatorState)state, builder);
        Block block = builder.build();
        Assert.assertEquals((Object)GeometryType.GEOMETRY.getObjectValue(null, block, 0), (Object)"POINT (1 2)");
        state.setGeometry(null);
        serializer.deserialize(block, 0, (AccumulatorState)state);
        Assert.assertEquals((String)state.getGeometry().asText(), (String)"POINT (1 2)");
        state.setGroupId(2L);
        Assert.assertEquals((String)state.getGeometry().asText(), (String)"POINT (2 3)");
        state.setGroupId(3L);
        Assert.assertNull((Object)state.getGeometry());
    }
}

