/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.jaxrs.tracing;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Scope;
import io.opentelemetry.semconv.ExceptionAttributes;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;

public final class TracingServletFilter
implements Filter {
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        request.setAttribute("airlift.remote-address", (Object)request.getRemoteAddr());
        try {
            chain.doFilter(request, response);
        }
        catch (Throwable t) {
            Object object = request.getAttribute("airlift.trace-span");
            if (object instanceof Span) {
                Span span = (Span)object;
                span.setStatus(StatusCode.ERROR, t.getMessage());
                span.recordException(t, Attributes.of((AttributeKey)ExceptionAttributes.EXCEPTION_ESCAPED, (Object)true));
            }
            throw t;
        }
        finally {
            Object object = request.getAttribute("airlift.trace-scope");
            if (object instanceof Scope) {
                Scope scope = (Scope)object;
                scope.close();
            }
            if ((object = request.getAttribute("airlift.trace-span")) instanceof Span) {
                Span span = (Span)object;
                span.end();
            }
        }
    }
}

