/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cache;

import com.google.common.cache.ForwardingLoadingCache;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ForwardingConcurrentMap;
import io.trino.cache.NonKeyEvictableLoadingCache;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;

class NonKeyEvictableLoadingCacheImpl<K, V>
extends ForwardingLoadingCache<K, V>
implements NonKeyEvictableLoadingCache<K, V> {
    private final LoadingCache<K, V> delegate;

    NonKeyEvictableLoadingCacheImpl(LoadingCache<K, V> delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
    }

    protected LoadingCache<K, V> delegate() {
        return this.delegate;
    }

    @Override
    public void invalidate(Object key) {
        throw new UnsupportedOperationException("invalidate(key) does not invalidate ongoing loads, so a stale value may remain in the cache for ever. Use EvictableCache if you need invalidation");
    }

    @Override
    public void unsafeInvalidate(Object key) {
        super.invalidate(key);
    }

    @Override
    public void invalidateAll(Iterable<?> keys) {
        throw new UnsupportedOperationException("invalidateAll(keys) does not invalidate ongoing loads, so a stale value may remain in the cache for ever. Use EvictableCache if you need invalidation");
    }

    public ConcurrentMap<K, V> asMap() {
        final ConcurrentMap map = this.delegate.asMap();
        return new ForwardingConcurrentMap<K, V>(this){

            protected ConcurrentMap<K, V> delegate() {
                return map;
            }

            public V remove(Object key) {
                throw new UnsupportedOperationException("remove(key) does not invalidate ongoing loads, so a stale value may remain in the cache for ever. Use EvictableCacheBuilder if you need invalidation");
            }

            public boolean remove(Object key, Object value) {
                throw new UnsupportedOperationException("remove(key, value) does not invalidate ongoing loads, so a stale value may remain in the cache for ever. Use EvictableCacheBuilder if you need invalidation");
            }

            public boolean replace(K key, V oldValue, V newValue) {
                throw new UnsupportedOperationException("replace(key, oldValue, newValue) does not invalidate ongoing loads, so a stale value may remain in the cache for ever. Use EvictableCacheBuilder if you need invalidation");
            }

            public V replace(K key, V value) {
                throw new UnsupportedOperationException("replace(key, value) does not invalidate ongoing loads, so a stale value may remain in the cache for ever. Use EvictableCacheBuilder if you need invalidation");
            }
        };
    }
}

