/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.server;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.Provider;
import io.airlift.event.client.EventClient;
import io.airlift.http.server.EnableCaseSensitiveHeaderCache;
import io.airlift.http.server.EnableLegacyUriCompliance;
import io.airlift.http.server.EnableVirtualThreads;
import io.airlift.http.server.HttpServer;
import io.airlift.http.server.HttpServerBinder;
import io.airlift.http.server.HttpServerConfig;
import io.airlift.http.server.HttpServerInfo;
import io.airlift.http.server.HttpsConfig;
import io.airlift.http.server.RequestStats;
import io.airlift.node.NodeInfo;
import jakarta.servlet.Filter;
import jakarta.servlet.Servlet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.management.MBeanServer;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class HttpServerProvider
implements Provider<HttpServer> {
    private final HttpServerInfo httpServerInfo;
    private final NodeInfo nodeInfo;
    private final HttpServerConfig config;
    private final Optional<HttpsConfig> httpsConfig;
    private final Servlet servlet;
    private final Set<HttpServerBinder.HttpResourceBinding> resources;
    private final HttpServer.ClientCertificate clientCertificate;
    private final boolean enableVirtualThreads;
    private final boolean enableLegacyUriCompliance;
    private final boolean enableCaseSensitiveHeaderCache;
    private MBeanServer mbeanServer;
    private final RequestStats stats;
    private final Set<Filter> filters;
    private final EventClient eventClient;
    private final Optional<SslContextFactory.Server> sslContextFactory;

    @Inject
    public HttpServerProvider(HttpServerInfo httpServerInfo, NodeInfo nodeInfo, HttpServerConfig config, Optional<HttpsConfig> httpsConfig, Servlet servlet, Set<Filter> filters, Set<HttpServerBinder.HttpResourceBinding> resources, @EnableVirtualThreads boolean enableVirtualThreads, @EnableLegacyUriCompliance boolean enableLegacyUriCompliance, @EnableCaseSensitiveHeaderCache boolean enableCaseSensitiveHeaderCache, HttpServer.ClientCertificate clientCertificate, RequestStats stats, EventClient eventClient, Optional<SslContextFactory.Server> sslContextFactory) {
        Objects.requireNonNull(httpServerInfo, "httpServerInfo is null");
        Objects.requireNonNull(nodeInfo, "nodeInfo is null");
        Objects.requireNonNull(config, "config is null");
        Objects.requireNonNull(httpsConfig, "httpsConfig is null");
        Objects.requireNonNull(servlet, "servlet is null");
        Objects.requireNonNull(filters, "filters is null");
        Objects.requireNonNull(resources, "resources is null");
        Objects.requireNonNull(clientCertificate, "clientCertificate is null");
        Objects.requireNonNull(stats, "stats is null");
        Objects.requireNonNull(eventClient, "eventClient is null");
        Objects.requireNonNull(sslContextFactory, "sslContextFactory is null");
        this.httpServerInfo = httpServerInfo;
        this.nodeInfo = nodeInfo;
        this.config = config;
        this.httpsConfig = httpsConfig;
        this.servlet = servlet;
        this.filters = ImmutableSet.copyOf(filters);
        this.resources = ImmutableSet.copyOf(resources);
        this.enableVirtualThreads = enableVirtualThreads;
        this.enableLegacyUriCompliance = enableLegacyUriCompliance;
        this.enableCaseSensitiveHeaderCache = enableCaseSensitiveHeaderCache;
        this.clientCertificate = clientCertificate;
        this.stats = stats;
        this.eventClient = eventClient;
        this.sslContextFactory = sslContextFactory;
    }

    @Inject(optional=true)
    public void setMBeanServer(MBeanServer server) {
        this.mbeanServer = server;
    }

    public HttpServer get() {
        try {
            HttpServer httpServer = new HttpServer(this.httpServerInfo, this.nodeInfo, this.config, this.httpsConfig, this.servlet, this.filters, this.resources, this.enableVirtualThreads, this.enableLegacyUriCompliance, this.enableCaseSensitiveHeaderCache, this.clientCertificate, this.mbeanServer, this.stats, this.eventClient, this.sslContextFactory);
            httpServer.start();
            return httpServer;
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

