/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.log;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Throwables;
import io.airlift.log.Level;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.TraceFlags;
import io.opentelemetry.context.Context;
import jakarta.annotation.Nullable;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

public class JsonRecord {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private final Instant timestamp;
    private final Level level;
    private final String thread;
    private final String loggerName;
    private final String message;
    private final List<String> parameters;
    private final Throwable throwable;
    private final Optional<SpanContext> spanContext;
    private final Map<String, String> logAnnotations;

    public JsonRecord(Instant timestamp, Level level, String thread, String loggerName, String message, Object[] parameters, Throwable throwable, Context context, Map<String, String> logAnnotations) {
        this(timestamp, level, thread, loggerName, message, Stream.of((Object[])MoreObjects.firstNonNull((Object)parameters, (Object)EMPTY_ARRAY)).map(Object::toString).toList(), throwable, context, logAnnotations);
    }

    @JsonCreator
    public JsonRecord(@JsonProperty(value="timestamp") Instant timestamp, @JsonProperty(value="level") Level level, @JsonProperty(value="thread") String thread, @JsonProperty(value="logger") String loggerName, @JsonProperty(value="message") String message, @JsonProperty(value="parameters") List<String> parameters, Throwable throwable, Context context, Map<String, String> logAnnotations) {
        this.timestamp = Objects.requireNonNull(timestamp);
        this.level = Objects.requireNonNull(level);
        this.thread = thread;
        this.loggerName = loggerName;
        this.message = message;
        if (parameters != null && parameters.isEmpty()) {
            parameters = null;
        }
        this.parameters = parameters;
        this.throwable = throwable;
        this.spanContext = Optional.ofNullable(context).map(Span::fromContext).map(Span::getSpanContext).filter(SpanContext::isValid);
        this.logAnnotations = logAnnotations == null || logAnnotations.isEmpty() ? null : logAnnotations;
    }

    @JsonProperty
    public Instant getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty
    public Level getLevel() {
        return this.level;
    }

    @JsonProperty
    public String getThread() {
        return this.thread;
    }

    @JsonProperty(value="logger")
    public String getLoggerName() {
        return this.loggerName;
    }

    @JsonProperty
    public String getMessage() {
        return this.message;
    }

    @Nullable
    @JsonProperty
    public List<String> getParameters() {
        return this.parameters;
    }

    @JsonProperty
    public String getThrowableClass() {
        if (this.throwable == null) {
            return null;
        }
        return this.throwable.getClass().getName();
    }

    @JsonProperty
    public String getThrowableMessage() {
        if (this.throwable == null) {
            return null;
        }
        return this.throwable.getMessage();
    }

    @JsonProperty
    public String getStackTrace() {
        if (this.throwable == null) {
            return null;
        }
        return Throwables.getStackTraceAsString((Throwable)this.throwable);
    }

    @JsonProperty
    public Optional<String> getTraceId() {
        return this.spanContext.map(SpanContext::getTraceId);
    }

    @JsonProperty
    public Optional<String> getSpanId() {
        return this.spanContext.map(SpanContext::getSpanId);
    }

    @JsonProperty
    public Optional<String> getTraceFlags() {
        return this.spanContext.map(SpanContext::getTraceFlags).map(TraceFlags::asHex);
    }

    @JsonProperty(value="annotations")
    public Map<String, String> getLogAnnotations() {
        return this.logAnnotations;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("timestamp", (Object)this.timestamp).add("level", (Object)this.level).add("thread", (Object)this.thread).add("loggerName", (Object)this.loggerName).add("message", (Object)this.message).add("throwable", (Object)this.throwable).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonRecord that = (JsonRecord)o;
        return Objects.equals(this.timestamp, that.timestamp) && this.level == that.level && Objects.equals(this.thread, that.thread) && Objects.equals(this.loggerName, that.loggerName) && Objects.equals(this.message, that.message) && Objects.equals(this.throwable, that.throwable);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.timestamp, this.level, this.thread, this.loggerName, this.message, this.throwable});
    }
}

