/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.jaxrs;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.jakarta.rs.cfg.JakartaRSFeature;
import com.fasterxml.jackson.jakarta.rs.json.JacksonJsonProvider;
import com.google.inject.Inject;
import io.airlift.jaxrs.JsonParsingException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.Provider;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

@Provider
@Consumes(value={"application/json", "text/json"})
@Produces(value={"application/json", "text/json"})
public class JsonMapper
extends JacksonJsonProvider {
    @Inject
    public JsonMapper(ObjectMapper objectMapper) {
        super(objectMapper);
        this.enable(JakartaRSFeature.ADD_NO_SNIFF_HEADER);
        this.enable(JsonParser.Feature.INCLUDE_SOURCE_IN_LOCATION);
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        try {
            return super.readFrom(type, genericType, annotations, mediaType, httpHeaders, entityStream);
        }
        catch (IOException e) {
            if (!(e instanceof JsonProcessingException) && !(e instanceof EOFException)) {
                throw e;
            }
            throw new JsonParsingException(e);
        }
    }
}

