/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.resource;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import org.eclipse.jetty.util.resource.PathResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class GraalIssue5720PathResource
extends PathResource {
    private static final Logger LOG = LoggerFactory.getLogger(GraalIssue5720PathResource.class);
    private static final String URI_BAD_RESOURCE_PREFIX = "file:///resources!";

    GraalIssue5720PathResource(Path path, URI uri, boolean bypassAllowedSchemeCheck) {
        super(path, GraalIssue5720PathResource.correctResourceURI(uri), bypassAllowedSchemeCheck || GraalIssue5720PathResource.isResourceScheme(uri));
    }

    private static final boolean isResourceScheme(URI uri) {
        return "resource".equals(uri.getScheme());
    }

    static boolean isAffectedURL(URL url) {
        URI uri;
        if (url == null || !"resource".equals(url.getProtocol())) {
            return false;
        }
        try {
            uri = url.toURI();
        }
        catch (URISyntaxException e) {
            return false;
        }
        try {
            try {
                uri = Path.of(uri).toUri();
            }
            catch (FileSystemNotFoundException e) {
                try {
                    FileSystems.newFileSystem(uri, Collections.emptyMap());
                }
                catch (FileSystemAlreadyExistsException e2) {
                    LOG.debug("Race condition upon calling FileSystems.newFileSystem for: {}", (Object)uri, (Object)e);
                }
                uri = Path.of(uri).toUri();
            }
        }
        catch (IOException | RuntimeException e) {
            LOG.warn("Could not check URL: {}", (Object)url, (Object)e);
        }
        return uri.getSchemeSpecificPart().startsWith(URI_BAD_RESOURCE_PREFIX);
    }

    static URI correctResourceURI(URI uri) {
        if (uri == null || !GraalIssue5720PathResource.isResourceScheme(uri)) {
            return uri;
        }
        String ssp = uri.getSchemeSpecificPart();
        if (ssp.startsWith(URI_BAD_RESOURCE_PREFIX)) {
            return URI.create("resource:" + ssp.substring(URI_BAD_RESOURCE_PREFIX.length()));
        }
        return uri;
    }

    @Override
    public URI getRealURI() {
        Path realPath = this.getRealPath();
        return realPath == null ? null : GraalIssue5720PathResource.correctResourceURI(realPath.toUri());
    }

    @Override
    protected URI toUri(Path path) {
        URI pathUri = GraalIssue5720PathResource.correctResourceURI(path.toUri());
        String rawUri = pathUri.toASCIIString();
        if (Files.isDirectory(path, new LinkOption[0]) && !rawUri.endsWith("/")) {
            return URI.create(rawUri + "/");
        }
        return pathUri;
    }
}

