/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.localfile;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.localfile.LocalFileColumnHandle;
import io.trino.plugin.localfile.LocalFileRecordSet;
import io.trino.plugin.localfile.LocalFileSplit;
import io.trino.plugin.localfile.LocalFileTableHandle;
import io.trino.plugin.localfile.LocalFileTables;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorRecordSetProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.RecordSet;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;

public class LocalFileRecordSetProvider
implements ConnectorRecordSetProvider {
    private final LocalFileTables localFileTables;

    @Inject
    public LocalFileRecordSetProvider(LocalFileTables localFileTables) {
        this.localFileTables = Objects.requireNonNull(localFileTables, "localFileTables is null");
    }

    public RecordSet getRecordSet(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit split, ConnectorTableHandle table, List<? extends ColumnHandle> columns) {
        LocalFileSplit localFileSplit = (LocalFileSplit)split;
        LocalFileTableHandle localFileTable = (LocalFileTableHandle)table;
        ImmutableList.Builder handles = ImmutableList.builder();
        for (ColumnHandle columnHandle : columns) {
            handles.add((Object)((LocalFileColumnHandle)columnHandle));
        }
        return new LocalFileRecordSet(this.localFileTables, localFileSplit, localFileTable, (List<LocalFileColumnHandle>)handles.build());
    }
}

