/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.eventlistener.mysql;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import io.airlift.json.JsonCodecFactory;
import io.trino.plugin.eventlistener.mysql.MysqlEventListenerFactory;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoWarning;
import io.trino.spi.WarningCodeSupplier;
import io.trino.spi.connector.StandardWarningCode;
import io.trino.spi.eventlistener.ColumnDetail;
import io.trino.spi.eventlistener.EventListener;
import io.trino.spi.eventlistener.OutputColumnMetadata;
import io.trino.spi.eventlistener.QueryCompletedEvent;
import io.trino.spi.eventlistener.QueryContext;
import io.trino.spi.eventlistener.QueryFailureInfo;
import io.trino.spi.eventlistener.QueryIOMetadata;
import io.trino.spi.eventlistener.QueryInputMetadata;
import io.trino.spi.eventlistener.QueryMetadata;
import io.trino.spi.eventlistener.QueryOutputMetadata;
import io.trino.spi.eventlistener.QueryStatistics;
import io.trino.spi.metrics.Metrics;
import io.trino.spi.resourcegroups.QueryType;
import io.trino.spi.resourcegroups.ResourceGroupId;
import io.trino.spi.session.ResourceEstimates;
import java.net.URI;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import org.testcontainers.containers.MySQLContainer;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestMysqlEventListener {
    private static final QueryMetadata FULL_QUERY_METADATA = new QueryMetadata("full_query", Optional.of("transactionId"), "query", Optional.of("updateType"), Optional.of("preparedQuery"), "queryState", List.of(), List.of(), URI.create("http://localhost"), Optional.of("plan"), Optional.of("jsonplan"), Optional.of("stageInfo"));
    private static final QueryStatistics FULL_QUERY_STATISTICS = new QueryStatistics(Duration.ofMillis(101L), Duration.ofMillis(102L), Duration.ofMillis(103L), Duration.ofMillis(104L), Optional.of(Duration.ofMillis(105L)), Optional.of(Duration.ofMillis(106L)), Optional.of(Duration.ofMillis(107L)), Optional.of(Duration.ofMillis(108L)), Optional.of(Duration.ofMillis(109L)), Optional.of(Duration.ofMillis(110L)), Optional.of(Duration.ofMillis(111L)), Optional.of(Duration.ofMillis(112L)), Optional.of(Duration.ofMillis(113L)), Optional.of(Duration.ofMillis(114L)), 115L, 116L, 117L, 118L, 119L, 1191L, 1192L, 120L, 121L, 122L, 123L, 124L, 125L, 126L, 127L, 128.0, 129.0, Collections.emptyList(), 130, true, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Optional.empty());
    private static final QueryContext FULL_QUERY_CONTEXT = new QueryContext("user", Optional.of("principal"), Set.of("group1", "group2"), Optional.of("traceToken"), Optional.of("remoteAddress"), Optional.of("userAgent"), Optional.of("clientInfo"), Set.of("tag1", "tag2", "tag3"), Set.of(), Optional.of("source"), Optional.of("catalog"), Optional.of("schema"), Optional.of(new ResourceGroupId("resourceGroup")), Map.of("property1", "value1", "property2", "value2"), new ResourceEstimates(Optional.empty(), Optional.empty(), Optional.empty()), "serverAddress", "serverVersion", "environment", Optional.of(QueryType.SELECT), "TASK");
    private static final QueryIOMetadata FULL_QUERY_IO_METADATA = new QueryIOMetadata(List.of(new QueryInputMetadata("catalog1", "schema1", "table1", List.of("column1", "column2"), Optional.of("connectorInfo1"), new Metrics((Map)ImmutableMap.of()), OptionalLong.of(201L), OptionalLong.of(202L)), new QueryInputMetadata("catalog2", "schema2", "table2", List.of("column3", "column4"), Optional.of("connectorInfo2"), new Metrics((Map)ImmutableMap.of()), OptionalLong.of(203L), OptionalLong.of(204L))), Optional.of(new QueryOutputMetadata("catalog3", "schema3", "table3", Optional.of(List.of(new OutputColumnMetadata("column5", "BIGINT", Set.of(new ColumnDetail("catalog4", "schema4", "table4", "column6"))), new OutputColumnMetadata("column6", "VARCHAR", Set.of()))), Optional.of("outputMetadata"), Optional.of(Boolean.TRUE))));
    private static final QueryFailureInfo FULL_FAILURE_INFO = new QueryFailureInfo(StandardErrorCode.GENERIC_INTERNAL_ERROR.toErrorCode(), Optional.of("failureType"), Optional.of("failureMessage"), Optional.of("failureTask"), Optional.of("failureHost"), "failureJson");
    private static final QueryCompletedEvent FULL_QUERY_COMPLETED_EVENT = new QueryCompletedEvent(FULL_QUERY_METADATA, FULL_QUERY_STATISTICS, FULL_QUERY_CONTEXT, FULL_QUERY_IO_METADATA, Optional.of(FULL_FAILURE_INFO), List.of(new TrinoWarning((WarningCodeSupplier)StandardWarningCode.TOO_MANY_STAGES, "too many stages")), Instant.now(), Instant.now(), Instant.now());
    private static final QueryMetadata MINIMAL_QUERY_METADATA = new QueryMetadata("minimal_query", Optional.empty(), "query", Optional.empty(), Optional.empty(), "queryState", List.of(), List.of(), URI.create("http://localhost"), Optional.empty(), Optional.empty(), Optional.empty());
    private static final QueryStatistics MINIMAL_QUERY_STATISTICS = new QueryStatistics(Duration.ofMillis(101L), Duration.ofMillis(102L), Duration.ofMillis(103L), Duration.ofMillis(104L), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), 115L, 116L, 117L, 118L, 119L, 1191L, 1192L, 120L, 121L, 122L, 123L, 124L, 125L, 126L, 127L, 128.0, 129.0, Collections.emptyList(), 130, false, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Optional.empty());
    private static final QueryContext MINIMAL_QUERY_CONTEXT = new QueryContext("user", Optional.empty(), Set.of(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Set.of(), Set.of(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Map.of(), new ResourceEstimates(Optional.empty(), Optional.empty(), Optional.empty()), "serverAddress", "serverVersion", "environment", Optional.empty(), "NONE");
    private static final QueryIOMetadata MINIMAL_QUERY_IO_METADATA = new QueryIOMetadata(List.of(), Optional.empty());
    private static final QueryCompletedEvent MINIMAL_QUERY_COMPLETED_EVENT = new QueryCompletedEvent(MINIMAL_QUERY_METADATA, MINIMAL_QUERY_STATISTICS, MINIMAL_QUERY_CONTEXT, MINIMAL_QUERY_IO_METADATA, Optional.empty(), List.of(), Instant.now(), Instant.now(), Instant.now());
    private MySQLContainer<?> mysqlContainer;
    private String mysqlContainerUrl;
    private EventListener eventListener;
    private JsonCodecFactory jsonCodecFactory;

    @BeforeClass
    public void setup() {
        this.mysqlContainer = new MySQLContainer("mysql:8.0.12");
        this.mysqlContainer.start();
        this.mysqlContainerUrl = TestMysqlEventListener.getJdbcUrl(this.mysqlContainer);
        this.eventListener = new MysqlEventListenerFactory().create(Map.of("mysql-event-listener.db.url", this.mysqlContainerUrl));
        this.jsonCodecFactory = new JsonCodecFactory();
    }

    @AfterClass(alwaysRun=true)
    public void teardown() {
        if (this.mysqlContainer != null) {
            this.mysqlContainer.close();
            this.mysqlContainer = null;
            this.mysqlContainerUrl = null;
        }
        this.eventListener = null;
        this.jsonCodecFactory = null;
    }

    private static String getJdbcUrl(MySQLContainer<?> container) {
        return String.format("%s?user=%s&password=%s&useSSL=false&allowPublicKeyRetrieval=true", container.getJdbcUrl(), container.getUsername(), container.getPassword());
    }

    @Test
    public void testFull() throws SQLException {
        this.eventListener.queryCompleted(FULL_QUERY_COMPLETED_EVENT);
        try (Connection connection = DriverManager.getConnection(this.mysqlContainerUrl);
             Statement statement = connection.createStatement();){
            statement.execute("SELECT * FROM trino_queries WHERE query_id = 'full_query'");
            try (ResultSet resultSet = statement.getResultSet();){
                Assert.assertTrue((boolean)resultSet.next());
                Assert.assertEquals((String)resultSet.getString("query_id"), (String)"full_query");
                Assert.assertEquals((String)resultSet.getString("transaction_id"), (String)"transactionId");
                Assert.assertEquals((String)resultSet.getString("query"), (String)"query");
                Assert.assertEquals((String)resultSet.getString("update_type"), (String)"updateType");
                Assert.assertEquals((String)resultSet.getString("prepared_query"), (String)"preparedQuery");
                Assert.assertEquals((String)resultSet.getString("query_state"), (String)"queryState");
                Assert.assertEquals((String)resultSet.getString("plan"), (String)"plan");
                Assert.assertEquals((String)resultSet.getString("stage_info_json"), (String)"stageInfo");
                Assert.assertEquals((String)resultSet.getString("user"), (String)"user");
                Assert.assertEquals((String)resultSet.getString("principal"), (String)"principal");
                Assert.assertEquals((String)resultSet.getString("trace_token"), (String)"traceToken");
                Assert.assertEquals((String)resultSet.getString("remote_client_address"), (String)"remoteAddress");
                Assert.assertEquals((String)resultSet.getString("user_agent"), (String)"userAgent");
                Assert.assertEquals((String)resultSet.getString("client_info"), (String)"clientInfo");
                Assert.assertEquals((String)resultSet.getString("client_tags_json"), (String)this.jsonCodecFactory.jsonCodec((TypeToken)new TypeToken<Set<String>>(){}).toJson((Object)FULL_QUERY_CONTEXT.getClientTags()));
                Assert.assertEquals((String)resultSet.getString("source"), (String)"source");
                Assert.assertEquals((String)resultSet.getString("catalog"), (String)"catalog");
                Assert.assertEquals((String)resultSet.getString("schema"), (String)"schema");
                Assert.assertEquals((String)resultSet.getString("resource_group_id"), (String)"resourceGroup");
                Assert.assertEquals((String)resultSet.getString("session_properties_json"), (String)this.jsonCodecFactory.mapJsonCodec(String.class, String.class).toJson((Object)FULL_QUERY_CONTEXT.getSessionProperties()));
                Assert.assertEquals((String)resultSet.getString("server_address"), (String)"serverAddress");
                Assert.assertEquals((String)resultSet.getString("server_version"), (String)"serverVersion");
                Assert.assertEquals((String)resultSet.getString("environment"), (String)"environment");
                Assert.assertEquals((String)resultSet.getString("query_type"), (String)"SELECT");
                Assert.assertEquals((String)resultSet.getString("inputs_json"), (String)this.jsonCodecFactory.listJsonCodec(QueryInputMetadata.class).toJson((Object)FULL_QUERY_IO_METADATA.getInputs()));
                Assert.assertEquals((String)resultSet.getString("output_json"), (String)this.jsonCodecFactory.jsonCodec(QueryOutputMetadata.class).toJson((Object)((QueryOutputMetadata)FULL_QUERY_IO_METADATA.getOutput().orElseThrow())));
                Assert.assertEquals((String)resultSet.getString("error_code"), (String)StandardErrorCode.GENERIC_INTERNAL_ERROR.name());
                Assert.assertEquals((String)resultSet.getString("error_type"), (String)StandardErrorCode.GENERIC_INTERNAL_ERROR.toErrorCode().getType().name());
                Assert.assertEquals((String)resultSet.getString("failure_type"), (String)"failureType");
                Assert.assertEquals((String)resultSet.getString("failure_message"), (String)"failureMessage");
                Assert.assertEquals((String)resultSet.getString("failure_task"), (String)"failureTask");
                Assert.assertEquals((String)resultSet.getString("failure_host"), (String)"failureHost");
                Assert.assertEquals((String)resultSet.getString("failures_json"), (String)"failureJson");
                Assert.assertEquals((String)resultSet.getString("warnings_json"), (String)this.jsonCodecFactory.listJsonCodec(TrinoWarning.class).toJson((Object)FULL_QUERY_COMPLETED_EVENT.getWarnings()));
                Assert.assertEquals((long)resultSet.getLong("cpu_time_millis"), (long)101L);
                Assert.assertEquals((long)resultSet.getLong("failed_cpu_time_millis"), (long)102L);
                Assert.assertEquals((long)resultSet.getLong("wall_time_millis"), (long)103L);
                Assert.assertEquals((long)resultSet.getLong("queued_time_millis"), (long)104L);
                Assert.assertEquals((long)resultSet.getLong("scheduled_time_millis"), (long)105L);
                Assert.assertEquals((long)resultSet.getLong("failed_scheduled_time_millis"), (long)106L);
                Assert.assertEquals((long)resultSet.getLong("waiting_time_millis"), (long)107L);
                Assert.assertEquals((long)resultSet.getLong("analysis_time_millis"), (long)108L);
                Assert.assertEquals((long)resultSet.getLong("planning_time_millis"), (long)109L);
                Assert.assertEquals((long)resultSet.getLong("execution_time_millis"), (long)110L);
                Assert.assertEquals((long)resultSet.getLong("input_blocked_time_millis"), (long)111L);
                Assert.assertEquals((long)resultSet.getLong("failed_input_blocked_time_millis"), (long)112L);
                Assert.assertEquals((long)resultSet.getLong("output_blocked_time_millis"), (long)113L);
                Assert.assertEquals((long)resultSet.getLong("failed_output_blocked_time_millis"), (long)114L);
                Assert.assertEquals((long)resultSet.getLong("peak_memory_bytes"), (long)115L);
                Assert.assertEquals((long)resultSet.getLong("peak_task_memory_bytes"), (long)117L);
                Assert.assertEquals((long)resultSet.getLong("physical_input_bytes"), (long)118L);
                Assert.assertEquals((long)resultSet.getLong("physical_input_rows"), (long)119L);
                Assert.assertEquals((long)resultSet.getLong("internal_network_bytes"), (long)120L);
                Assert.assertEquals((long)resultSet.getLong("internal_network_rows"), (long)121L);
                Assert.assertEquals((long)resultSet.getLong("total_bytes"), (long)122L);
                Assert.assertEquals((long)resultSet.getLong("total_rows"), (long)123L);
                Assert.assertEquals((long)resultSet.getLong("output_bytes"), (long)124L);
                Assert.assertEquals((long)resultSet.getLong("output_rows"), (long)125L);
                Assert.assertEquals((long)resultSet.getLong("written_bytes"), (long)126L);
                Assert.assertEquals((long)resultSet.getLong("written_rows"), (long)127L);
                Assert.assertEquals((Object)resultSet.getDouble("cumulative_memory"), (Object)128.0);
                Assert.assertEquals((Object)resultSet.getDouble("failed_cumulative_memory"), (Object)129.0);
                Assert.assertEquals((long)resultSet.getLong("completed_splits"), (long)130L);
                Assert.assertEquals((String)resultSet.getString("retry_policy"), (String)"TASK");
                Assert.assertFalse((boolean)resultSet.next());
            }
        }
    }

    @Test
    public void testMinimal() throws SQLException {
        this.eventListener.queryCompleted(MINIMAL_QUERY_COMPLETED_EVENT);
        try (Connection connection = DriverManager.getConnection(this.mysqlContainerUrl);
             Statement statement = connection.createStatement();){
            statement.execute("SELECT * FROM trino_queries WHERE query_id = 'minimal_query'");
            try (ResultSet resultSet = statement.getResultSet();){
                Assert.assertTrue((boolean)resultSet.next());
                Assert.assertEquals((String)resultSet.getString("query_id"), (String)"minimal_query");
                Assert.assertNull((Object)resultSet.getString("transaction_id"));
                Assert.assertEquals((String)resultSet.getString("query"), (String)"query");
                Assert.assertNull((Object)resultSet.getString("update_type"));
                Assert.assertNull((Object)resultSet.getString("prepared_query"));
                Assert.assertEquals((String)resultSet.getString("query_state"), (String)"queryState");
                Assert.assertNull((Object)resultSet.getString("plan"));
                Assert.assertNull((Object)resultSet.getString("stage_info_json"));
                Assert.assertEquals((String)resultSet.getString("user"), (String)"user");
                Assert.assertNull((Object)resultSet.getString("principal"));
                Assert.assertNull((Object)resultSet.getString("trace_token"));
                Assert.assertNull((Object)resultSet.getString("remote_client_address"));
                Assert.assertNull((Object)resultSet.getString("user_agent"));
                Assert.assertNull((Object)resultSet.getString("client_info"));
                Assert.assertEquals((String)resultSet.getString("client_tags_json"), (String)this.jsonCodecFactory.jsonCodec((TypeToken)new TypeToken<Set<String>>(){}).toJson(Set.of()));
                Assert.assertNull((Object)resultSet.getString("source"));
                Assert.assertNull((Object)resultSet.getString("catalog"));
                Assert.assertNull((Object)resultSet.getString("schema"));
                Assert.assertNull((Object)resultSet.getString("resource_group_id"));
                Assert.assertEquals((String)resultSet.getString("session_properties_json"), (String)this.jsonCodecFactory.mapJsonCodec(String.class, String.class).toJson(Map.of()));
                Assert.assertEquals((String)resultSet.getString("server_address"), (String)"serverAddress");
                Assert.assertEquals((String)resultSet.getString("server_version"), (String)"serverVersion");
                Assert.assertEquals((String)resultSet.getString("environment"), (String)"environment");
                Assert.assertNull((Object)resultSet.getString("query_type"));
                Assert.assertEquals((String)resultSet.getString("inputs_json"), (String)this.jsonCodecFactory.listJsonCodec(QueryInputMetadata.class).toJson(List.of()));
                Assert.assertNull((Object)resultSet.getString("output_json"));
                Assert.assertNull((Object)resultSet.getString("error_code"));
                Assert.assertNull((Object)resultSet.getString("error_type"));
                Assert.assertNull((Object)resultSet.getString("failure_type"));
                Assert.assertNull((Object)resultSet.getString("failure_message"));
                Assert.assertNull((Object)resultSet.getString("failure_task"));
                Assert.assertNull((Object)resultSet.getString("failure_host"));
                Assert.assertNull((Object)resultSet.getString("failures_json"));
                Assert.assertEquals((String)resultSet.getString("warnings_json"), (String)this.jsonCodecFactory.listJsonCodec(TrinoWarning.class).toJson(List.of()));
                Assert.assertEquals((long)resultSet.getLong("cpu_time_millis"), (long)101L);
                Assert.assertEquals((long)resultSet.getLong("failed_cpu_time_millis"), (long)102L);
                Assert.assertEquals((long)resultSet.getLong("wall_time_millis"), (long)103L);
                Assert.assertEquals((long)resultSet.getLong("queued_time_millis"), (long)104L);
                Assert.assertEquals((long)resultSet.getLong("scheduled_time_millis"), (long)0L);
                Assert.assertEquals((long)resultSet.getLong("failed_scheduled_time_millis"), (long)0L);
                Assert.assertEquals((long)resultSet.getLong("waiting_time_millis"), (long)0L);
                Assert.assertEquals((long)resultSet.getLong("analysis_time_millis"), (long)0L);
                Assert.assertEquals((long)resultSet.getLong("planning_time_millis"), (long)0L);
                Assert.assertEquals((long)resultSet.getLong("execution_time_millis"), (long)0L);
                Assert.assertEquals((long)resultSet.getLong("input_blocked_time_millis"), (long)0L);
                Assert.assertEquals((long)resultSet.getLong("failed_input_blocked_time_millis"), (long)0L);
                Assert.assertEquals((long)resultSet.getLong("output_blocked_time_millis"), (long)0L);
                Assert.assertEquals((long)resultSet.getLong("failed_output_blocked_time_millis"), (long)0L);
                Assert.assertEquals((long)resultSet.getLong("peak_memory_bytes"), (long)115L);
                Assert.assertEquals((long)resultSet.getLong("peak_task_memory_bytes"), (long)117L);
                Assert.assertEquals((long)resultSet.getLong("physical_input_bytes"), (long)118L);
                Assert.assertEquals((long)resultSet.getLong("physical_input_rows"), (long)119L);
                Assert.assertEquals((long)resultSet.getLong("internal_network_bytes"), (long)120L);
                Assert.assertEquals((long)resultSet.getLong("internal_network_rows"), (long)121L);
                Assert.assertEquals((long)resultSet.getLong("total_bytes"), (long)122L);
                Assert.assertEquals((long)resultSet.getLong("total_rows"), (long)123L);
                Assert.assertEquals((long)resultSet.getLong("output_bytes"), (long)124L);
                Assert.assertEquals((long)resultSet.getLong("output_rows"), (long)125L);
                Assert.assertEquals((long)resultSet.getLong("written_bytes"), (long)126L);
                Assert.assertEquals((long)resultSet.getLong("written_rows"), (long)127L);
                Assert.assertEquals((Object)resultSet.getDouble("cumulative_memory"), (Object)128.0);
                Assert.assertEquals((Object)resultSet.getDouble("failed_cumulative_memory"), (Object)129.0);
                Assert.assertEquals((long)resultSet.getLong("completed_splits"), (long)130L);
                Assert.assertEquals((String)resultSet.getString("retry_policy"), (String)"NONE");
                Assert.assertFalse((boolean)resultSet.next());
            }
        }
    }
}

