/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.eventlistener.mysql;

import com.google.common.base.Joiner;
import com.google.inject.Inject;
import io.airlift.json.JsonCodec;
import io.airlift.log.Logger;
import io.trino.plugin.eventlistener.mysql.QueryDao;
import io.trino.plugin.eventlistener.mysql.QueryEntity;
import io.trino.spi.ErrorCode;
import io.trino.spi.TrinoWarning;
import io.trino.spi.eventlistener.EventListener;
import io.trino.spi.eventlistener.QueryCompletedEvent;
import io.trino.spi.eventlistener.QueryContext;
import io.trino.spi.eventlistener.QueryCreatedEvent;
import io.trino.spi.eventlistener.QueryFailureInfo;
import io.trino.spi.eventlistener.QueryInputMetadata;
import io.trino.spi.eventlistener.QueryMetadata;
import io.trino.spi.eventlistener.QueryOutputMetadata;
import io.trino.spi.eventlistener.QueryStatistics;
import io.trino.spi.eventlistener.SplitCompletedEvent;
import io.trino.spi.resourcegroups.ResourceGroupId;
import jakarta.annotation.PostConstruct;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class MysqlEventListener
implements EventListener {
    private static final Logger log = Logger.get(MysqlEventListener.class);
    private static final long MAX_OPERATOR_SUMMARIES_JSON_LENGTH = 0x1000000L;
    private final QueryDao dao;
    private final JsonCodec<Set<String>> clientTagsJsonCodec;
    private final JsonCodec<Map<String, String>> sessionPropertiesJsonCodec;
    private final JsonCodec<List<QueryInputMetadata>> inputsJsonCodec;
    private final JsonCodec<QueryOutputMetadata> outputJsonCodec;
    private final JsonCodec<List<TrinoWarning>> warningsJsonCodec;

    @Inject
    public MysqlEventListener(QueryDao dao, JsonCodec<Set<String>> clientTagsJsonCodec, JsonCodec<Map<String, String>> sessionPropertiesJsonCodec, JsonCodec<List<QueryInputMetadata>> inputsJsonCodec, JsonCodec<QueryOutputMetadata> outputJsonCodec, JsonCodec<List<TrinoWarning>> warningsJsonCodec) {
        this.dao = Objects.requireNonNull(dao, "dao is null");
        this.clientTagsJsonCodec = Objects.requireNonNull(clientTagsJsonCodec, "clientTagsJsonCodec is null");
        this.sessionPropertiesJsonCodec = Objects.requireNonNull(sessionPropertiesJsonCodec, "sessionPropertiesJsonCodec is null");
        this.inputsJsonCodec = Objects.requireNonNull(inputsJsonCodec, "inputsJsonCodec is null");
        this.outputJsonCodec = Objects.requireNonNull(outputJsonCodec, "outputJsonCodec is null");
        this.warningsJsonCodec = Objects.requireNonNull(warningsJsonCodec, "warningsJsonCodec is null");
    }

    @PostConstruct
    public void createTable() {
        this.dao.createTable();
    }

    public void queryCreated(QueryCreatedEvent event) {
    }

    public void queryCompleted(QueryCompletedEvent event) {
        QueryMetadata metadata = event.getMetadata();
        QueryContext context = event.getContext();
        Optional failureInfo = event.getFailureInfo();
        QueryStatistics stats = event.getStatistics();
        QueryEntity entity = new QueryEntity(metadata.getQueryId(), metadata.getTransactionId(), metadata.getQuery(), metadata.getUpdateType(), metadata.getPreparedQuery(), metadata.getQueryState(), metadata.getPlan(), metadata.getPayload(), context.getUser(), context.getPrincipal(), context.getTraceToken(), context.getRemoteClientAddress(), context.getUserAgent(), context.getClientInfo(), this.clientTagsJsonCodec.toJson((Object)context.getClientTags()), context.getSource(), context.getCatalog(), context.getSchema(), context.getResourceGroupId().map(ResourceGroupId::toString), this.sessionPropertiesJsonCodec.toJson((Object)context.getSessionProperties()), context.getServerAddress(), context.getServerVersion(), context.getEnvironment(), context.getQueryType().map(Enum::name), this.inputsJsonCodec.toJson((Object)event.getIoMetadata().getInputs()), event.getIoMetadata().getOutput().map(arg_0 -> this.outputJsonCodec.toJson(arg_0)), failureInfo.map(QueryFailureInfo::getErrorCode).map(ErrorCode::getName), failureInfo.map(QueryFailureInfo::getErrorCode).map(ErrorCode::getType).map(Enum::name), failureInfo.flatMap(QueryFailureInfo::getFailureType), failureInfo.flatMap(QueryFailureInfo::getFailureMessage), failureInfo.flatMap(QueryFailureInfo::getFailureTask), failureInfo.flatMap(QueryFailureInfo::getFailureHost), failureInfo.map(QueryFailureInfo::getFailuresJson), this.warningsJsonCodec.toJson((Object)event.getWarnings()), stats.getCpuTime().toMillis(), stats.getFailedCpuTime().toMillis(), stats.getWallTime().toMillis(), stats.getQueuedTime().toMillis(), stats.getScheduledTime().map(Duration::toMillis).orElse(0L), stats.getFailedScheduledTime().map(Duration::toMillis).orElse(0L), stats.getResourceWaitingTime().map(Duration::toMillis).orElse(0L), stats.getAnalysisTime().map(Duration::toMillis).orElse(0L), stats.getPlanningTime().map(Duration::toMillis).orElse(0L), stats.getPlanningCpuTime().map(Duration::toMillis).orElse(0L), stats.getExecutionTime().map(Duration::toMillis).orElse(0L), stats.getInputBlockedTime().map(Duration::toMillis).orElse(0L), stats.getFailedInputBlockedTime().map(Duration::toMillis).orElse(0L), stats.getOutputBlockedTime().map(Duration::toMillis).orElse(0L), stats.getFailedOutputBlockedTime().map(Duration::toMillis).orElse(0L), stats.getPhysicalInputReadTime().map(Duration::toMillis).orElse(0L), stats.getPeakUserMemoryBytes(), stats.getPeakTaskTotalMemory(), stats.getPhysicalInputBytes(), stats.getPhysicalInputRows(), stats.getInternalNetworkBytes(), stats.getInternalNetworkRows(), stats.getTotalBytes(), stats.getTotalRows(), stats.getOutputBytes(), stats.getOutputRows(), stats.getWrittenBytes(), stats.getWrittenRows(), stats.getCumulativeMemory(), stats.getFailedCumulativeMemory(), stats.getCompletedSplits(), context.getRetryPolicy(), this.createOperatorSummariesJson(metadata.getQueryId(), stats.getOperatorSummaries()));
        this.dao.store(entity);
    }

    private Optional<String> createOperatorSummariesJson(String queryId, List<String> summaries) {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        Joiner.on((String)",").appendTo(builder, summaries);
        builder.append("]");
        String result = builder.toString();
        if ((long)result.length() > 0x1000000L) {
            log.info("Exceeded maximum operator summaries length for query %s: %s", new Object[]{queryId, result});
            return Optional.empty();
        }
        return Optional.of(result);
    }

    public void splitCompleted(SplitCompletedEvent event) {
    }
}

