/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.opentelemetry;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.Tracer;
import java.sql.SQLException;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.statement.SqlStatements;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.core.statement.StatementContextListener;

public class JdbiOpenTelemetryPlugin
extends JdbiPlugin.Singleton {
    public static final AttributeKey<String> SQL = AttributeKey.stringKey((String)"sql");
    public static final AttributeKey<String> BINDING = AttributeKey.stringKey((String)"binding");
    public static final AttributeKey<Long> NUM_ROWS = AttributeKey.longKey((String)"rows");
    private final Tracer tracer;

    public JdbiOpenTelemetryPlugin() {
        this(GlobalOpenTelemetry.get());
    }

    public JdbiOpenTelemetryPlugin(OpenTelemetry telemetry) {
        this.tracer = telemetry.getTracer("jdbi");
    }

    public void customizeJdbi(Jdbi jdbi) throws SQLException {
        ((SqlStatements)jdbi.getConfig(SqlStatements.class)).addContextListener((StatementContextListener)new TracingListener());
    }

    class TracingListener
    implements StatementContextListener {
        TracingListener() {
        }

        public void contextCreated(StatementContext ctx) {
            Span span = JdbiOpenTelemetryPlugin.this.tracer.spanBuilder("jdbi." + ctx.describeJdbiStatementType()).startSpan();
            SpanContext spanContext = span.getSpanContext();
            if (spanContext.isValid()) {
                ctx.setTraceId(spanContext.getTraceId());
                ctx.addCleanable(() -> {
                    SqlStatements stmtConfig = (SqlStatements)ctx.getConfig(SqlStatements.class);
                    String renderedSql = ctx.getRenderedSql();
                    if (renderedSql != null) {
                        span.setAttribute(SQL, (Object)renderedSql.substring(0, Math.min(renderedSql.length(), stmtConfig.getJfrSqlMaxLength())));
                    }
                    span.setAttribute(BINDING, (Object)ctx.getBinding().describe(stmtConfig.getJfrParamMaxLength()));
                    span.setAttribute(NUM_ROWS, (Object)ctx.getMappedRows());
                    span.end();
                });
            }
        }
    }
}

