/*
 * Decompiled with CFR 0.152.
 */
package org.weakref.jmx.$internal.guava.collect;

import java.util.Comparator;
import java.util.Spliterator;
import javax.annotation.CheckForNull;
import org.weakref.jmx.$internal.guava.annotations.GwtCompatible;
import org.weakref.jmx.$internal.guava.annotations.GwtIncompatible;
import org.weakref.jmx.$internal.guava.collect.CollectSpliterators;
import org.weakref.jmx.$internal.guava.collect.ElementTypesAreNonnullByDefault;
import org.weakref.jmx.$internal.guava.collect.ImmutableList;
import org.weakref.jmx.$internal.guava.collect.ImmutableSortedSet;
import org.weakref.jmx.$internal.guava.collect.RegularImmutableAsList;
import org.weakref.jmx.$internal.guava.collect.RegularImmutableSortedSet;
import org.weakref.jmx.$internal.guava.collect.SortedIterable;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
final class ImmutableSortedAsList<E>
extends RegularImmutableAsList<E>
implements SortedIterable<E> {
    ImmutableSortedAsList(ImmutableSortedSet<E> backingSet, ImmutableList<E> backingList) {
        super(backingSet, backingList);
    }

    @Override
    ImmutableSortedSet<E> delegateCollection() {
        return (ImmutableSortedSet)super.delegateCollection();
    }

    @Override
    public Comparator<? super E> comparator() {
        return ((ImmutableSortedSet)this.delegateCollection()).comparator();
    }

    @Override
    @GwtIncompatible
    public int indexOf(@CheckForNull Object target) {
        int index = ((ImmutableSortedSet)this.delegateCollection()).indexOf(target);
        return index >= 0 && this.get(index).equals(target) ? index : -1;
    }

    @Override
    @GwtIncompatible
    public int lastIndexOf(@CheckForNull Object target) {
        return this.indexOf(target);
    }

    @Override
    public boolean contains(@CheckForNull Object target) {
        return this.indexOf(target) >= 0;
    }

    @Override
    @GwtIncompatible
    ImmutableList<E> subListUnchecked(int fromIndex, int toIndex) {
        ImmutableList parentSubList = super.subListUnchecked(fromIndex, toIndex);
        return new RegularImmutableSortedSet(parentSubList, this.comparator()).asList();
    }

    @Override
    public Spliterator<E> spliterator() {
        return CollectSpliterators.indexed(this.size(), 1301, this.delegateList()::get, this.comparator());
    }
}

