/*
 * Decompiled with CFR 0.152.
 */
package org.weakref.jmx.$internal.parameternames;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.weakref.jmx.;
import org.weakref.jmx.$internal.parameternames.$internal.asm.ClassReader;
import org.weakref.jmx.$internal.parameternames.$internal.asm.ClassVisitor;
import org.weakref.jmx.$internal.parameternames.$internal.asm.MethodVisitor;
import org.weakref.jmx.$internal.parameternames.$internal.asm.Type;

public final class ParameterNames {
    private ParameterNames() {
    }

    public static Optional<List<String>> tryGetParameterNames(Executable executable) {
        Objects.requireNonNull(executable, "executable is null");
        if (executable.getParameterCount() == 0) {
            return Optional.of(Collections.emptyList());
        }
        List<Parameter> parameters = Arrays.asList(executable.getParameters());
        if (parameters.stream().allMatch(Parameter::isNamePresent)) {
            return Optional.of(ParameterNames.getParameterNames(parameters));
        }
        return ParameterNames.getParameterNamesFromBytecode(executable);
    }

    public static List<String> getParameterNames(Executable executable) {
        Optional<List<String>> parameterNames;
        Objects.requireNonNull(executable, "executable is null");
        if (executable.getParameterCount() == 0) {
            return Collections.emptyList();
        }
        List<Parameter> parameters = Arrays.asList(executable.getParameters());
        if (!parameters.stream().allMatch(Parameter::isNamePresent) && (parameterNames = ParameterNames.getParameterNamesFromBytecode(executable)).isPresent()) {
            return parameterNames.get();
        }
        return ParameterNames.getParameterNames(parameters);
    }

    private static List<String> getParameterNames(List<Parameter> parameters) {
        return Collections.unmodifiableList(parameters.stream().map(Parameter::getName).collect(Collectors.toList()));
    }

    public static Optional<List<String>> getParameterNamesFromBytecode(Executable executable) {
        Objects.requireNonNull(executable, "executable is null");
        if (executable.getParameterCount() == 0) {
            return Optional.of(Collections.emptyList());
        }
        byte[] byteCode = ParameterNames.loadBytecode(executable.getDeclaringClass());
        if (byteCode == null) {
            return Optional.empty();
        }
        try {
            ClassReader reader = new ClassReader(byteCode);
            ParameterNameClassVisitor visitor = new ParameterNameClassVisitor(executable);
            reader.accept(visitor, 4);
            return visitor.getParameterNames();
        }
        catch (RuntimeException e) {
            return Optional.empty();
        }
    }

    private static byte[] loadBytecode(Class<?> declaringClass) {
        block9: {
            try {
                ClassLoader classLoader = declaringClass.getClassLoader();
                if (classLoader == null && (classLoader = ClassLoader.getSystemClassLoader()) == null) {
                    return null;
                }
                URL classFile = classLoader.getResource(declaringClass.getName().replace('.', '/') + ".class");
                if (classFile == null) break block9;
                ByteArrayOutputStream out = new ByteArrayOutputStream(4086);
                try (BufferedInputStream inputStream = new BufferedInputStream(classFile.openStream());){
                    byte[] buffer = new byte[1024];
                    int length = ((InputStream)inputStream).read(buffer);
                    while (length >= 0) {
                        out.write(buffer, 0, length);
                        length = ((InputStream)inputStream).read(buffer);
                    }
                }
                return out.toByteArray();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private static class ParameterNameMethodVisitor
    extends MethodVisitor {
        private final boolean isStatic;
        private final List<Type> parameterTypes;
        private final String[] slotNames;

        ParameterNameMethodVisitor(boolean isStatic, List<Type> parameterTypes) {
            super(327680);
            this.isStatic = isStatic;
            this.parameterTypes = parameterTypes;
            int parameterSlots = 0;
            if (!isStatic) {
                ++parameterSlots;
            }
            for (Type parameterType : parameterTypes) {
                parameterSlots += parameterType.getSize();
            }
            this.slotNames = new String[parameterSlots];
        }

        @Override
        public void visitLocalVariable(String name, String desc, String signature, ..Label start, ..Label end, int index) {
            if (index < this.slotNames.length) {
                this.slotNames[index] = name;
            }
        }

        Optional<List<String>> getResult() {
            int slot = 0;
            if (!this.isStatic) {
                ++slot;
            }
            ArrayList<String> result = new ArrayList<String>();
            for (Type parameterType : this.parameterTypes) {
                String slotName = this.slotNames[slot];
                if (slotName == null) {
                    return Optional.empty();
                }
                result.add(slotName);
                slot += parameterType.getSize();
            }
            return Optional.of(Collections.unmodifiableList(result));
        }
    }

    private static class ParameterNameClassVisitor
    extends ClassVisitor {
        private final String methodName;
        private final List<Type> parameterTypes;
        private final ParameterNameMethodVisitor methodVisitor;
        private boolean methodFound;

        ParameterNameClassVisitor(Executable executable) {
            super(589824);
            this.methodName = executable instanceof Constructor ? "<init>" : executable.getName();
            this.parameterTypes = Arrays.stream(executable.getParameterTypes()).map(Type::getType).collect(Collectors.toList());
            this.methodVisitor = new ParameterNameMethodVisitor(Modifier.isStatic(executable.getModifiers()), this.parameterTypes);
        }

        Optional<List<String>> getParameterNames() {
            return this.methodVisitor.getResult();
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (this.methodFound) {
                return null;
            }
            if (!name.equals(this.methodName) || !this.parameterTypes.equals(Arrays.asList(Type.getArgumentTypes(desc)))) {
                return null;
            }
            this.methodFound = true;
            return this.methodVisitor;
        }
    }
}

