/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.log;

import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.net.HostAndPort;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import io.airlift.configuration.ConfigurationLoader;
import io.airlift.configuration.ConfigurationUtils;
import io.airlift.log.BufferedHandler;
import io.airlift.log.BufferedHandlerErrorManager;
import io.airlift.log.Level;
import io.airlift.log.Logger;
import io.airlift.log.LoggingConfiguration;
import io.airlift.log.LoggingOutputStream;
import io.airlift.log.OutputStreamHandler;
import io.airlift.log.RollingFileMessageOutput;
import io.airlift.log.SocketMessageOutput;
import io.airlift.log.StaticFormatter;
import io.airlift.units.DataSize;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import org.weakref.jmx.MBeanExport;
import org.weakref.jmx.MBeanExporter;

public class Logging {
    private static final Logger log = Logger.get(Logging.class);
    private static final String ROOT_LOGGER_NAME = "";
    private static final java.util.logging.Logger ROOT = java.util.logging.Logger.getLogger("");
    private static Logging instance;
    private static final PrintStream stdErr;
    @GuardedBy(value="this")
    private final Map<String, java.util.logging.Logger> loggers = new HashMap<String, java.util.logging.Logger>();
    @GuardedBy(value="this")
    private OutputStreamHandler consoleHandler;
    @GuardedBy(value="this")
    private boolean configured;
    private final SettableFuture<MBeanExporter> mBeanExporterAvailableFuture = SettableFuture.create();
    private final SettableFuture<List<MBeanExport>> mBeanExportsFuture = SettableFuture.create();

    public static synchronized Logging initialize() {
        if (instance == null) {
            instance = new Logging();
        }
        return instance;
    }

    private Logging() {
        ROOT.setLevel(Level.INFO.toJulLevel());
        for (Handler handler : ROOT.getHandlers()) {
            ROOT.removeHandler(handler);
        }
        this.enableConsole();
        log.info("Logging to stderr");
        Logging.redirectStdStreams();
    }

    public void exportMBeans(MBeanExporter exporter) {
        this.mBeanExporterAvailableFuture.set((Object)exporter);
    }

    public void unexportMBeans() {
        Futures.addCallback(this.mBeanExportsFuture, (FutureCallback)new FutureCallback<List<MBeanExport>>(this){

            public void onSuccess(List<MBeanExport> exports) {
                exports.forEach(MBeanExport::unexport);
            }

            public void onFailure(Throwable t) {
                throw new VerifyException("Unexpected code path! Should not fail here", t);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    private static void resetStdStreams() {
        System.setOut(new PrintStream(new FileOutputStream(FileDescriptor.out), true));
        System.setErr(new PrintStream(new FileOutputStream(FileDescriptor.err), true));
    }

    private static void redirectStdStreams() {
        System.setOut(new PrintStream(new LoggingOutputStream(Logger.get((String)"stdout")), true));
        System.setErr(new PrintStream(new LoggingOutputStream(Logger.get((String)"stderr")), true));
    }

    private synchronized void enableConsole() {
        this.enableConsole(new StaticFormatter());
    }

    private synchronized void enableConsole(Formatter formatter) {
        this.consoleHandler = new OutputStreamHandler(System.err, formatter);
        ROOT.addHandler(this.consoleHandler);
    }

    public synchronized void disableConsole() {
        log.info("Disabling stderr output");
        ROOT.removeHandler(this.consoleHandler);
        this.consoleHandler = null;
    }

    private void logToFile(String logPath, DataSize maxFileSize, DataSize maxTotalSize, RollingFileMessageOutput.CompressionType compressionType, Formatter formatter, List<LogMBeanExport> mBeanExportCollector) {
        log.info("Logging to %s", new Object[]{logPath});
        RollingFileMessageOutput output = new RollingFileMessageOutput(logPath, maxFileSize, maxTotalSize, compressionType);
        BufferedHandler handler = new BufferedHandler(output, formatter, new BufferedHandlerErrorManager(stdErr));
        handler.initialize();
        mBeanExportCollector.add(new LogMBeanExport(handler, BufferedHandler.class, "RollingFileMessageOutput"));
        ROOT.addHandler(handler);
    }

    private void logToSocket(String logPath, Formatter formatter, List<LogMBeanExport> mBeanExportCollector) {
        if (!logPath.startsWith("tcp://") || logPath.lastIndexOf("/") > 6) {
            throw new IllegalArgumentException("LogPath for sockets must begin with tcp:// and not contain any path component.");
        }
        HostAndPort hostAndPort = HostAndPort.fromString((String)logPath.replace("tcp://", ROOT_LOGGER_NAME));
        SocketMessageOutput output = new SocketMessageOutput(hostAndPort);
        BufferedHandler handler = new BufferedHandler(output, formatter, new BufferedHandlerErrorManager(stdErr));
        handler.initialize();
        mBeanExportCollector.add(new LogMBeanExport(handler, BufferedHandler.class, "SocketMessageOutput"));
        ROOT.addHandler(handler);
    }

    public Level getRootLevel() {
        return this.getLevel(ROOT_LOGGER_NAME);
    }

    public void setRootLevel(Level newLevel) {
        this.setLevel(ROOT_LOGGER_NAME, newLevel);
    }

    public void setLevels(String file) throws IOException {
        ConfigurationLoader.loadPropertiesFrom((String)file).forEach((loggerName, value) -> this.setLevel((String)loggerName, Level.valueOf(value.toUpperCase(Locale.US))));
    }

    public Level getLevel(String loggerName) {
        return Logging.getEffectiveLevel(java.util.logging.Logger.getLogger(loggerName));
    }

    private static Level getEffectiveLevel(java.util.logging.Logger logger) {
        java.util.logging.Logger parent;
        java.util.logging.Level level = logger.getLevel();
        if (level == null && (parent = logger.getParent()) != null) {
            return Logging.getEffectiveLevel(parent);
        }
        if (level == null) {
            return Level.OFF;
        }
        return Level.fromJulLevel(level);
    }

    public synchronized void clearLevel(String loggerName) {
        java.util.logging.Logger logger = this.loggers.remove(loggerName);
        if (logger != null) {
            logger.setLevel(null);
        }
    }

    public synchronized void setLevel(String loggerName, Level level) {
        this.loggers.computeIfAbsent(loggerName, java.util.logging.Logger::getLogger).setLevel(level.toJulLevel());
    }

    public Map<String, Level> getAllLevels() {
        ImmutableSortedMap.Builder levels = ImmutableSortedMap.naturalOrder();
        for (String loggerName : Collections.list(LogManager.getLogManager().getLoggerNames())) {
            java.util.logging.Level level = java.util.logging.Logger.getLogger(loggerName).getLevel();
            if (level == null) continue;
            levels.put((Object)loggerName, (Object)Level.fromJulLevel(level));
        }
        return levels.build();
    }

    public synchronized void configure(LoggingConfiguration config) {
        if (this.configured) {
            log.warn("Logging already configured; ignoring new configuration.");
            return;
        }
        this.configured = true;
        ArrayList<LogMBeanExport> mBeanExportCollector = new ArrayList<LogMBeanExport>();
        Object logAnnotations = ImmutableMap.of();
        if (config.getLogAnnotationFile() != null) {
            try {
                logAnnotations = ConfigurationUtils.replaceEnvironmentVariables((Map)ConfigurationLoader.loadPropertiesFrom((String)config.getLogAnnotationFile()));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        if (config.getLogPath() != null) {
            if (config.getLogPath().startsWith("tcp://")) {
                this.logToSocket(config.getLogPath(), config.getFormat().createFormatter((Map<String, String>)logAnnotations), mBeanExportCollector);
            } else {
                this.logToFile(config.getLogPath(), config.getMaxSize(), config.getMaxTotalSize(), config.getCompression(), config.getFormat().createFormatter((Map<String, String>)logAnnotations), mBeanExportCollector);
            }
        }
        if (!config.isConsoleEnabled()) {
            this.disableConsole();
        } else {
            Logging.resetStdStreams();
            this.disableConsole();
            this.enableConsole(config.getConsoleFormat().createFormatter((Map<String, String>)logAnnotations));
            Logging.redirectStdStreams();
        }
        if (config.getLevelsFile() != null) {
            try {
                this.setLevels(config.getLevelsFile());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        this.mBeanExportsFuture.setFuture(Futures.transform(this.mBeanExporterAvailableFuture, exporter -> (ImmutableList)mBeanExportCollector.stream().map(export -> exporter.exportWithGeneratedName(export.object(), export.type(), export.name())).collect(ImmutableList.toImmutableList()), (Executor)MoreExecutors.directExecutor()));
    }

    static {
        stdErr = System.err;
    }

    private record LogMBeanExport(Object object, Class<?> type, String name) {
        private LogMBeanExport {
            Objects.requireNonNull(object, "object is null");
            Objects.requireNonNull(type, "type is null");
            Objects.requireNonNull(name, "name is null");
        }
    }
}

