/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.configuration;

import com.google.inject.Binder;
import com.google.inject.Module;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigurationAwareModule;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ConditionalModule<T>
extends AbstractConfigurationAwareModule {
    private final Class<T> config;
    private final Optional<String> prefix;
    private final Predicate<T> predicate;
    private final Module module;

    @Deprecated
    public static <T> Module installModuleIf(Class<T> config, Predicate<T> predicate, Module module, Module otherwise) {
        return ConditionalModule.conditionalModule(config, predicate, module, otherwise);
    }

    @Deprecated
    public static <T> Module installModuleIf(Class<T> config, Predicate<T> predicate, Module module) {
        return ConditionalModule.conditionalModule(config, predicate, module);
    }

    public static <T> Module conditionalModule(Class<T> config, Predicate<T> predicate, Module module, Module otherwise) {
        return ConfigurationAwareModule.combine(ConditionalModule.conditionalModule(config, predicate, module), ConditionalModule.conditionalModule(config, predicate.negate(), otherwise));
    }

    public static <T> Module conditionalModule(Class<T> config, String prefix, Predicate<T> predicate, Module module, Module otherwise) {
        return ConfigurationAwareModule.combine(ConditionalModule.conditionalModule(config, prefix, predicate, module), ConditionalModule.conditionalModule(config, prefix, predicate.negate(), otherwise));
    }

    public static <T> Module conditionalModule(Class<T> config, Predicate<T> predicate, Module module) {
        return new ConditionalModule<T>(config, Optional.empty(), predicate, module);
    }

    public static <T> Module conditionalModule(Class<T> config, String prefix, Predicate<T> predicate, Module module) {
        return new ConditionalModule<T>(config, Optional.of(prefix), predicate, module);
    }

    private ConditionalModule(Class<T> config, Optional<String> prefix, Predicate<T> predicate, Module module) {
        this.config = Objects.requireNonNull(config, "config is null");
        this.prefix = Objects.requireNonNull(prefix, "prefix is null");
        this.predicate = Objects.requireNonNull(predicate, "predicate is null");
        this.module = Objects.requireNonNull(module, "module is null");
    }

    @Override
    protected void setup(Binder binder) {
        Object configuration = this.prefix.map(value -> this.buildConfigObject(this.config, (String)value)).orElseGet(() -> this.buildConfigObject(this.config));
        if (this.predicate.test(configuration)) {
            this.install(this.module);
        }
    }
}

