/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.oracle;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import io.trino.Session;
import io.trino.plugin.jdbc.UnsupportedTypeHandling;
import io.trino.plugin.oracle.OracleDataTypes;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.TestingSession;
import io.trino.testing.datatype.CreateAndInsertDataSetup;
import io.trino.testing.datatype.CreateAsSelectDataSetup;
import io.trino.testing.datatype.DataSetup;
import io.trino.testing.datatype.DataType;
import io.trino.testing.datatype.DataTypeTest;
import io.trino.testing.datatype.SqlDataTypeTest;
import io.trino.testing.sql.SqlExecutor;
import io.trino.testing.sql.TestTable;
import io.trino.testing.sql.TrinoSqlExecutor;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.List;
import java.util.Optional;
import java.util.function.IntFunction;
import java.util.function.ToIntFunction;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public abstract class AbstractTestOracleTypeMapping
extends AbstractTestQueryFramework {
    protected static final int MAX_CHAR_ON_READ = 2000;
    protected static final int MAX_CHAR_ON_WRITE = 500;
    protected static final int MAX_VARCHAR2_ON_READ = 4000;
    protected static final int MAX_VARCHAR2_ON_WRITE = 1000;
    protected static final int MAX_NCHAR = 1000;
    protected static final int MAX_NVARCHAR2 = 2000;
    private static final String NO_SUPPORTED_COLUMNS = "Table '.*' has no supported columns \\(all \\d+ columns are not supported\\)";
    private final ZoneId jvmZone = ZoneId.systemDefault();
    private final LocalDateTime timeGapInJvmZone1 = LocalDateTime.of(1970, 1, 1, 0, 13, 42);
    private final LocalDateTime timeGapInJvmZone2 = LocalDateTime.of(2018, 4, 1, 2, 13, 55, 123000000);
    private final LocalDateTime timeDoubledInJvmZone = LocalDateTime.of(2018, 10, 28, 1, 33, 17, 456000000);
    private final ZoneId vilnius = ZoneId.of("Europe/Vilnius");
    private final LocalDateTime timeGapInVilnius = LocalDateTime.of(2018, 3, 25, 3, 17, 17);
    private final LocalDateTime timeDoubledInVilnius = LocalDateTime.of(2018, 10, 28, 3, 33, 33, 333000000);
    private final ZoneId kathmandu = ZoneId.of("Asia/Kathmandu");
    private final LocalDateTime timeGapInKathmandu = LocalDateTime.of(1986, 1, 1, 0, 13, 7);

    @BeforeClass
    public void setUp() {
        AbstractTestOracleTypeMapping.checkIsGap(this.jvmZone, this.timeGapInJvmZone1);
        AbstractTestOracleTypeMapping.checkIsGap(this.jvmZone, this.timeGapInJvmZone2);
        AbstractTestOracleTypeMapping.checkIsDoubled(this.jvmZone, this.timeDoubledInJvmZone);
        AbstractTestOracleTypeMapping.checkIsGap(this.vilnius, this.timeGapInVilnius);
        AbstractTestOracleTypeMapping.checkIsDoubled(this.vilnius, this.timeDoubledInVilnius);
        AbstractTestOracleTypeMapping.checkIsGap(this.kathmandu, this.timeGapInKathmandu);
    }

    private DataSetup trinoCreateAsSelect(String tableNamePrefix) {
        return new CreateAsSelectDataSetup((SqlExecutor)new TrinoSqlExecutor(this.getQueryRunner()), tableNamePrefix);
    }

    private DataSetup trinoCreateAsSelect(Session session, String tableNamePrefix) {
        return new CreateAsSelectDataSetup((SqlExecutor)new TrinoSqlExecutor(this.getQueryRunner(), session), tableNamePrefix);
    }

    private DataSetup trinoCreateAndInsert(String tableNamePrefix) {
        return new CreateAndInsertDataSetup((SqlExecutor)new TrinoSqlExecutor(this.getQueryRunner()), tableNamePrefix);
    }

    @Test
    public void testFloatingPointMappings() {
        SqlDataTypeTest.create().addRoundTrip("real", "123.45", (Type)RealType.REAL, "REAL '123.45'").addRoundTrip("real", "nan()", (Type)RealType.REAL, "CAST(nan() AS real)").addRoundTrip("real", "+infinity()", (Type)RealType.REAL, "CAST(+infinity() AS real)").addRoundTrip("real", "-infinity()", (Type)RealType.REAL, "CAST(-infinity() AS real)").addRoundTrip("real", "NULL", (Type)RealType.REAL, "CAST(NULL AS real)").addRoundTrip("double", "1.0E100", (Type)DoubleType.DOUBLE, "double '1.0E100'").addRoundTrip("double", "123.456E10", (Type)DoubleType.DOUBLE, "123.456E10").addRoundTrip("double", "nan()", (Type)DoubleType.DOUBLE, "CAST(nan() AS double)").addRoundTrip("double", "+infinity()", (Type)DoubleType.DOUBLE, "CAST(+infinity() AS double)").addRoundTrip("double", "-infinity()", (Type)DoubleType.DOUBLE, "CAST(-infinity() AS double)").addRoundTrip("double", "NULL", (Type)DoubleType.DOUBLE, "CAST(NULL AS double)").execute(this.getQueryRunner(), this.trinoCreateAsSelect("floats")).execute(this.getQueryRunner(), this.trinoCreateAndInsert("floats"));
    }

    @Test
    public void testOracleFloatingPointMappings() {
        SqlDataTypeTest.create().addRoundTrip("float", "1E100", (Type)DoubleType.DOUBLE, "double '1E100'").addRoundTrip("float", "1.0", (Type)DoubleType.DOUBLE, "double '1.0'").addRoundTrip("float", "123456.123456", (Type)DoubleType.DOUBLE, "double '123456.123456'").addRoundTrip("float", "NULL", (Type)DoubleType.DOUBLE, "CAST(NULL AS double)").addRoundTrip("float(126)", "1E100", (Type)DoubleType.DOUBLE, "double '1E100'").addRoundTrip("float(126)", "1.0", (Type)DoubleType.DOUBLE, "double '1.0'").addRoundTrip("float(126)", "1234567890123456789.0123456789", (Type)DoubleType.DOUBLE, "double '1234567890123456789.0123456789'").addRoundTrip("float(126)", "NULL", (Type)DoubleType.DOUBLE, "CAST(NULL AS double)").addRoundTrip("float(1)", "100000.0", (Type)DoubleType.DOUBLE, "double '100000.0'").addRoundTrip("float(7)", "123000.0", (Type)DoubleType.DOUBLE, "double '123000.0'").execute(this.getQueryRunner(), this.oracleCreateAndInsert("oracle_float"));
    }

    @Test
    public void testFloatingPointReadMappings() {
        SqlDataTypeTest.create().addRoundTrip("binary_float", "123.45", (Type)RealType.REAL, "REAL '123.45'").addRoundTrip("binary_float", "'nan'", (Type)RealType.REAL, "CAST(nan() AS REAL)").addRoundTrip("binary_float", "'infinity'", (Type)RealType.REAL, "CAST(+infinity() AS REAL)").addRoundTrip("binary_float", "'-infinity'", (Type)RealType.REAL, "CAST(-infinity() AS REAL)").addRoundTrip("binary_float", "NULL", (Type)RealType.REAL, "CAST(NULL AS REAL)").addRoundTrip("binary_double", "1.0E100", (Type)DoubleType.DOUBLE, "double '1.0E100'").addRoundTrip("binary_double", "'nan'", (Type)DoubleType.DOUBLE, "CAST(nan() AS double)").addRoundTrip("binary_double", "'infinity'", (Type)DoubleType.DOUBLE, "CAST(+infinity() AS double)").addRoundTrip("binary_double", "'-infinity'", (Type)DoubleType.DOUBLE, "CAST(-infinity() AS double)").execute(this.getQueryRunner(), this.oracleCreateAndInsert("read_floats"));
    }

    @Test
    public void testVarcharMapping() {
        SqlDataTypeTest.create().addRoundTrip("varchar(10)", "'string 010'", (Type)VarcharType.createVarcharType((int)10), "CAST('string 010' AS VARCHAR(10))").addRoundTrip("varchar(20)", "'string 20'", (Type)VarcharType.createVarcharType((int)20), "CAST('string 20' AS VARCHAR(20))").addRoundTrip(String.format("varchar(%d)", 1000), "'string max size'", (Type)VarcharType.createVarcharType((int)1000), String.format("CAST('string max size' AS VARCHAR(%d))", 1000)).addRoundTrip("varchar(5)", "NULL", (Type)VarcharType.createVarcharType((int)5), "CAST(NULL AS VARCHAR(5))").execute(this.getQueryRunner(), this.trinoCreateAsSelect("varchar")).execute(this.getQueryRunner(), this.trinoCreateAndInsert("varchar"));
    }

    @Test
    public void testVarcharReadMapping() {
        SqlDataTypeTest.create().addRoundTrip("varchar2(5 char)", "NULL", (Type)VarcharType.createVarcharType((int)5), "CAST(NULL AS VARCHAR(5))").addRoundTrip("varchar2(10 char)", "'string 010'", (Type)VarcharType.createVarcharType((int)10), "CAST('string 010' AS VARCHAR(10))").addRoundTrip("varchar2(20 char)", "'string 20'", (Type)VarcharType.createVarcharType((int)20), "CAST('string 20' AS VARCHAR(20))").addRoundTrip(String.format("varchar2(%d char)", 1000), "'string max size'", (Type)VarcharType.createVarcharType((int)1000), String.format("CAST('string max size' AS VARCHAR(%d))", 1000)).addRoundTrip("varchar2(5 byte)", "NULL", (Type)VarcharType.createVarcharType((int)5), "CAST(NULL AS VARCHAR(5))").addRoundTrip("varchar2(10 byte)", "'string 010'", (Type)VarcharType.createVarcharType((int)10), "CAST('string 010' AS VARCHAR(10))").addRoundTrip("varchar2(20 byte)", "'string 20'", (Type)VarcharType.createVarcharType((int)20), "CAST('string 20' AS VARCHAR(20))").addRoundTrip(String.format("varchar2(%d byte)", 4000), "'string max size'", (Type)VarcharType.createVarcharType((int)4000), String.format("CAST('string max size' AS VARCHAR(%d))", 4000)).addRoundTrip("nvarchar2(5)", "NULL", (Type)VarcharType.createVarcharType((int)5), "CAST(NULL AS VARCHAR(5))").addRoundTrip("nvarchar2(10)", "'string 010'", (Type)VarcharType.createVarcharType((int)10), "CAST('string 010' AS VARCHAR(10))").addRoundTrip("nvarchar2(20)", "'string 20'", (Type)VarcharType.createVarcharType((int)20), "CAST('string 20' AS VARCHAR(20))").addRoundTrip(String.format("nvarchar2(%d)", 2000), "'string max size'", (Type)VarcharType.createVarcharType((int)2000), String.format("CAST('string max size' AS VARCHAR(%d))", 2000)).execute(this.getQueryRunner(), this.oracleCreateAndInsert("read_varchar"));
    }

    @Test
    public void testVarcharUnicodeMapping() {
        SqlDataTypeTest.create().addRoundTrip("varchar(5)", "'\u653b\u6bbb\u6a5f\u52d5\u968a'", (Type)VarcharType.createVarcharType((int)5), "CAST('\u653b\u6bbb\u6a5f\u52d5\u968a' AS varchar(5))").addRoundTrip("varchar(13)", "'\u653b\u6bbb\u6a5f\u52d5\u968a'", (Type)VarcharType.createVarcharType((int)13), "CAST('\u653b\u6bbb\u6a5f\u52d5\u968a' AS varchar(13))").addRoundTrip(String.format("varchar(%d)", 1000), "'\u653b\u6bbb\u6a5f\u52d5\u968a'", (Type)VarcharType.createVarcharType((int)1000), String.format("CAST('\u653b\u6bbb\u6a5f\u52d5\u968a' AS varchar(%d))", 1000)).addRoundTrip("varchar(1)", "'\ud83d\ude02'", (Type)VarcharType.createVarcharType((int)1), "CAST('\ud83d\ude02' AS varchar(1))").addRoundTrip("varchar(6)", "'\ud83d\ude02'", (Type)VarcharType.createVarcharType((int)6), "CAST('\ud83d\ude02' AS varchar(6))").execute(this.getQueryRunner(), this.trinoCreateAsSelect("varchar_unicode")).execute(this.getQueryRunner(), this.trinoCreateAndInsert("varchar_unicode"));
    }

    @Test
    public void testVarcharUnicodeReadMapping() {
        SqlDataTypeTest.create().addRoundTrip("varchar2(5 char)", "'\u653b\u6bbb\u6a5f\u52d5\u968a'", (Type)VarcharType.createVarcharType((int)5), "CAST('\u653b\u6bbb\u6a5f\u52d5\u968a' AS varchar(5))").addRoundTrip("varchar2(13 char)", "'\u653b\u6bbb\u6a5f\u52d5\u968a'", (Type)VarcharType.createVarcharType((int)13), "CAST('\u653b\u6bbb\u6a5f\u52d5\u968a' AS varchar(13))").addRoundTrip(String.format("varchar2(%d char)", 4000), "'\u653b\u6bbb\u6a5f\u52d5\u968a'", (Type)VarcharType.createVarcharType((int)4000), String.format("CAST('\u653b\u6bbb\u6a5f\u52d5\u968a' AS varchar(%d))", 4000)).addRoundTrip("varchar2(1 char)", "'\ud83d\ude02'", (Type)VarcharType.createVarcharType((int)1), "CAST('\ud83d\ude02' AS varchar(1))").addRoundTrip("varchar2(6 char)", "'\ud83d\ude02'", (Type)VarcharType.createVarcharType((int)6), "CAST('\ud83d\ude02' AS varchar(6))").addRoundTrip("varchar2(15 byte)", "'\u653b\u6bbb\u6a5f\u52d5\u968a'", (Type)VarcharType.createVarcharType((int)15), "CAST('\u653b\u6bbb\u6a5f\u52d5\u968a' AS varchar(15))").addRoundTrip("varchar2(23 byte)", "'\u653b\u6bbb\u6a5f\u52d5\u968a'", (Type)VarcharType.createVarcharType((int)23), "CAST('\u653b\u6bbb\u6a5f\u52d5\u968a' AS varchar(23))").addRoundTrip(String.format("varchar2(%d byte)", 4000), "'\u653b\u6bbb\u6a5f\u52d5\u968a'", (Type)VarcharType.createVarcharType((int)4000), String.format("CAST('\u653b\u6bbb\u6a5f\u52d5\u968a' AS varchar(%d))", 4000)).addRoundTrip("varchar2(4 byte)", "'\ud83d\ude02'", (Type)VarcharType.createVarcharType((int)4), "CAST('\ud83d\ude02' AS varchar(4))").addRoundTrip("varchar2(9 byte)", "'\ud83d\ude02'", (Type)VarcharType.createVarcharType((int)9), "CAST('\ud83d\ude02' AS varchar(9))").addRoundTrip("nvarchar2(5)", "'\u653b\u6bbb\u6a5f\u52d5\u968a'", (Type)VarcharType.createVarcharType((int)5), "CAST('\u653b\u6bbb\u6a5f\u52d5\u968a' AS varchar(5))").addRoundTrip("nvarchar2(13)", "'\u653b\u6bbb\u6a5f\u52d5\u968a'", (Type)VarcharType.createVarcharType((int)13), "CAST('\u653b\u6bbb\u6a5f\u52d5\u968a' AS varchar(13))").addRoundTrip(String.format("nvarchar2(%d)", 2000), "'\u653b\u6bbb\u6a5f\u52d5\u968a'", (Type)VarcharType.createVarcharType((int)2000), String.format("CAST('\u653b\u6bbb\u6a5f\u52d5\u968a' AS varchar(%d))", 2000)).addRoundTrip("nvarchar2(2)", "'\ud83d\ude02'", (Type)VarcharType.createVarcharType((int)2), "CAST('\ud83d\ude02' AS varchar(2))").addRoundTrip("nvarchar2(7)", "'\ud83d\ude02'", (Type)VarcharType.createVarcharType((int)7), "CAST('\ud83d\ude02' AS varchar(7))").execute(this.getQueryRunner(), this.oracleCreateAndInsert("read_varchar_unicode"));
    }

    @Test
    public void testUnboundedVarcharMapping() {
        SqlDataTypeTest.create().addRoundTrip("varchar", "'\u653b\u6bbb\u6a5f\u52d5\u968a'", (Type)VarcharType.createUnboundedVarcharType(), "VARCHAR '\u653b\u6bbb\u6a5f\u52d5\u968a'").addRoundTrip("varchar", "'\ud83d\ude02'", (Type)VarcharType.createUnboundedVarcharType(), "VARCHAR '\ud83d\ude02'").addRoundTrip("varchar", "'clob'", (Type)VarcharType.createUnboundedVarcharType(), "VARCHAR 'clob'").addRoundTrip("varchar", "NULL", (Type)VarcharType.createUnboundedVarcharType(), "CAST(NULL AS varchar)").addRoundTrip(String.format("varchar(%d)", 1001), "'\u653b\u6bbb\u6a5f\u52d5\u968a'", (Type)VarcharType.createUnboundedVarcharType(), "VARCHAR '\u653b\u6bbb\u6a5f\u52d5\u968a'").addRoundTrip(String.format("varchar(%d)", 1001), "'\ud83d\ude02'", (Type)VarcharType.createUnboundedVarcharType(), "VARCHAR '\ud83d\ude02'").addRoundTrip(String.format("varchar(%d)", 1001), "'clob'", (Type)VarcharType.createUnboundedVarcharType(), "VARCHAR 'clob'").addRoundTrip(String.format("varchar(%d)", 1001), "NULL", (Type)VarcharType.createUnboundedVarcharType(), "CAST(NULL AS varchar)").addRoundTrip(String.format("char(%d)", 501), "'\u653b\u6bbb\u6a5f\u52d5\u968a'", (Type)VarcharType.createUnboundedVarcharType(), "VARCHAR '\u653b\u6bbb\u6a5f\u52d5\u968a'").addRoundTrip(String.format("char(%d)", 501), "'\ud83d\ude02'", (Type)VarcharType.createUnboundedVarcharType(), "VARCHAR '\ud83d\ude02'").addRoundTrip(String.format("char(%d)", 501), "'clob'", (Type)VarcharType.createUnboundedVarcharType(), "VARCHAR 'clob'").addRoundTrip(String.format("char(%d)", 501), "NULL", (Type)VarcharType.createUnboundedVarcharType(), "CAST(NULL AS varchar)").execute(this.getQueryRunner(), this.trinoCreateAsSelect("unbounded")).execute(this.getQueryRunner(), this.trinoCreateAndInsert("unbounded"));
    }

    @Test
    public void testUnboundedVarcharReadMapping() {
        SqlDataTypeTest.create().addRoundTrip("clob", "'\u653b\u6bbb\u6a5f\u52d5\u968a'", (Type)VarcharType.createUnboundedVarcharType(), "VARCHAR '\u653b\u6bbb\u6a5f\u52d5\u968a'").addRoundTrip("clob", "'\ud83d\ude02'", (Type)VarcharType.createUnboundedVarcharType(), "VARCHAR '\ud83d\ude02'").addRoundTrip("clob", "'clob'", (Type)VarcharType.createUnboundedVarcharType(), "VARCHAR 'clob'").addRoundTrip("clob", "NULL", (Type)VarcharType.createUnboundedVarcharType(), "CAST(NULL AS VARCHAR)").addRoundTrip("clob", "empty_clob()", (Type)VarcharType.createUnboundedVarcharType(), "VARCHAR ''").addRoundTrip("nclob", "'\u653b\u6bbb\u6a5f\u52d5\u968a'", (Type)VarcharType.createUnboundedVarcharType(), "VARCHAR '\u653b\u6bbb\u6a5f\u52d5\u968a'").addRoundTrip("nclob", "'\ud83d\ude02'", (Type)VarcharType.createUnboundedVarcharType(), "VARCHAR '\ud83d\ude02'").addRoundTrip("nclob", "'clob'", (Type)VarcharType.createUnboundedVarcharType(), "VARCHAR 'clob'").addRoundTrip("nclob", "NULL", (Type)VarcharType.createUnboundedVarcharType(), "CAST(NULL AS VARCHAR)").addRoundTrip("nclob", "empty_clob()", (Type)VarcharType.createUnboundedVarcharType(), "VARCHAR ''").execute(this.getQueryRunner(), this.oracleCreateAndInsert("read_unbounded"));
    }

    @Test
    public void testCharMapping() {
        SqlDataTypeTest.create().addRoundTrip("char(10)", "'string 010'", (Type)CharType.createCharType((long)10L), "CAST('string 010' AS CHAR(10))").addRoundTrip("char(20)", "'string 20'", (Type)CharType.createCharType((long)20L), "CAST('string 20' AS CHAR(20))").addRoundTrip(String.format("char(%d)", 500), "'string max size'", (Type)CharType.createCharType((long)500L), String.format("CAST('string max size' AS CHAR(%d))", 500)).addRoundTrip("char(5)", "NULL", (Type)CharType.createCharType((long)5L), "CAST(NULL AS CHAR(5))").execute(this.getQueryRunner(), this.trinoCreateAsSelect("char")).execute(this.getQueryRunner(), this.trinoCreateAndInsert("char"));
    }

    @Test
    public void testCharReadMapping() {
        SqlDataTypeTest.create().addRoundTrip("char(5 char)", "NULL", (Type)CharType.createCharType((long)5L), "CAST(NULL AS CHAR(5))").addRoundTrip("char(10 char)", "'string 010'", (Type)CharType.createCharType((long)10L), "CAST('string 010' AS CHAR(10))").addRoundTrip("char(20 char)", "'string 20'", (Type)CharType.createCharType((long)20L), "CAST('string 20' AS CHAR(20))").addRoundTrip(String.format("char(%d char)", 2000), "'string max size'", (Type)CharType.createCharType((long)2000L), String.format("CAST('string max size' AS CHAR(%d))", 2000)).addRoundTrip("char(5 byte)", "NULL", (Type)CharType.createCharType((long)5L), "CAST(NULL AS CHAR(5))").addRoundTrip("char(10 byte)", "'string 010'", (Type)CharType.createCharType((long)10L), "CAST('string 010' AS CHAR(10))").addRoundTrip("char(20 byte)", "'string 20'", (Type)CharType.createCharType((long)20L), "CAST('string 20' AS CHAR(20))").addRoundTrip(String.format("char(%d byte)", 2000), "'string max size'", (Type)CharType.createCharType((long)2000L), String.format("CAST('string max size' AS CHAR(%d))", 2000)).addRoundTrip("nchar(5)", "NULL", (Type)CharType.createCharType((long)5L), "CAST(NULL AS CHAR(5))").addRoundTrip("nchar(10)", "'string 010'", (Type)CharType.createCharType((long)10L), "CAST('string 010' AS CHAR(10))").addRoundTrip("nchar(20)", "'string 20'", (Type)CharType.createCharType((long)20L), "CAST('string 20' AS CHAR(20))").addRoundTrip(String.format("nchar(%d)", 1000), "'string max size'", (Type)CharType.createCharType((long)1000L), String.format("CAST('string max size' AS CHAR(%d))", 1000)).execute(this.getQueryRunner(), this.oracleCreateAndInsert("read_char"));
    }

    @Test
    public void testCharUnicodeMapping() {
        SqlDataTypeTest.create().addRoundTrip("char(5)", "'\u653b\u6bbb\u6a5f\u52d5\u968a'", (Type)CharType.createCharType((long)5L), "CAST('\u653b\u6bbb\u6a5f\u52d5\u968a' AS char(5))").addRoundTrip("char(13)", "'\u653b\u6bbb\u6a5f\u52d5\u968a'", (Type)CharType.createCharType((long)13L), "CAST('\u653b\u6bbb\u6a5f\u52d5\u968a' AS char(13))").addRoundTrip(String.format("char(%d)", 500), "'\u653b\u6bbb\u6a5f\u52d5\u968a'", (Type)CharType.createCharType((long)500L), String.format("CAST('\u653b\u6bbb\u6a5f\u52d5\u968a' AS char(%d))", 500)).addRoundTrip("char(1)", "'\ud83d\ude02'", (Type)CharType.createCharType((long)1L), "CAST('\ud83d\ude02' AS char(1))").addRoundTrip("char(6)", "'\ud83d\ude02'", (Type)CharType.createCharType((long)6L), "CAST('\ud83d\ude02' AS char(6))").execute(this.getQueryRunner(), this.trinoCreateAsSelect("char_unicode"));
    }

    @Test
    public void testCharUnicodeReadMapping() {
        SqlDataTypeTest.create().addRoundTrip("char(5 char)", "'\u653b\u6bbb\u6a5f\u52d5\u968a'", (Type)CharType.createCharType((long)5L), "CAST('\u653b\u6bbb\u6a5f\u52d5\u968a' AS CHAR(5))").addRoundTrip("char(13 char)", "'\u653b\u6bbb\u6a5f\u52d5\u968a'", (Type)CharType.createCharType((long)13L), "CAST('\u653b\u6bbb\u6a5f\u52d5\u968a' AS CHAR(13))").addRoundTrip(String.format("char(%d char)", 2000), "'\u653b\u6bbb\u6a5f\u52d5\u968a'", (Type)CharType.createCharType((long)2000L), String.format("CAST('\u653b\u6bbb\u6a5f\u52d5\u968a' AS char(%d))", 2000)).addRoundTrip("char(1 char)", "'\ud83d\ude02'", (Type)CharType.createCharType((long)1L), "CAST('\ud83d\ude02' AS CHAR(1))").addRoundTrip("char(6 char)", "'\ud83d\ude02'", (Type)CharType.createCharType((long)6L), "CAST('\ud83d\ude02' AS CHAR(6))").addRoundTrip("char(15 byte)", "'\u653b\u6bbb\u6a5f\u52d5\u968a'", (Type)CharType.createCharType((long)15L), "CAST('\u653b\u6bbb\u6a5f\u52d5\u968a' AS CHAR(15))").addRoundTrip("char(23 byte)", "'\u653b\u6bbb\u6a5f\u52d5\u968a'", (Type)CharType.createCharType((long)23L), "CAST('\u653b\u6bbb\u6a5f\u52d5\u968a' AS CHAR(23))").addRoundTrip(String.format("char(%d byte)", 2000), "'\u653b\u6bbb\u6a5f\u52d5\u968a'", (Type)CharType.createCharType((long)2000L), String.format("CAST('\u653b\u6bbb\u6a5f\u52d5\u968a' AS CHAR(%d))", 2000)).addRoundTrip("char(4 byte)", "'\ud83d\ude02'", (Type)CharType.createCharType((long)4L), "CAST('\ud83d\ude02' AS CHAR(4))").addRoundTrip("char(9 byte)", "'\ud83d\ude02'", (Type)CharType.createCharType((long)9L), "CAST('\ud83d\ude02' AS CHAR(9))").addRoundTrip("nchar(5)", "'\u653b\u6bbb\u6a5f\u52d5\u968a'", (Type)CharType.createCharType((long)5L), "CAST('\u653b\u6bbb\u6a5f\u52d5\u968a' AS CHAR(5))").addRoundTrip("nchar(13)", "'\u653b\u6bbb\u6a5f\u52d5\u968a'", (Type)CharType.createCharType((long)13L), "CAST('\u653b\u6bbb\u6a5f\u52d5\u968a' AS CHAR(13))").addRoundTrip(String.format("nchar(%d)", 1000), "'\u653b\u6bbb\u6a5f\u52d5\u968a'", (Type)CharType.createCharType((long)1000L), String.format("CAST('\u653b\u6bbb\u6a5f\u52d5\u968a' AS CHAR(%d))", 1000)).addRoundTrip("nchar(2)", "'\ud83d\ude02'", (Type)CharType.createCharType((long)2L), "CAST('\ud83d\ude02' AS CHAR(2))").addRoundTrip("nchar(7)", "'\ud83d\ude02'", (Type)CharType.createCharType((long)7L), "CAST('\ud83d\ude02' AS CHAR(7))").execute(this.getQueryRunner(), this.oracleCreateAndInsert("read_char_unicode"));
    }

    private static DataTypeTest unicodeTests(IntFunction<DataType<String>> typeConstructor, ToIntFunction<String> stringLength, int maxSize) {
        String unicodeText = "\u653b\u6bbb\u6a5f\u52d5\u968a";
        String nonBmpCharacter = "\ud83d\ude02";
        int unicodeLength = stringLength.applyAsInt(unicodeText);
        int nonBmpLength = stringLength.applyAsInt(nonBmpCharacter);
        return DataTypeTest.create().addRoundTrip(typeConstructor.apply(unicodeLength), (Object)unicodeText).addRoundTrip(typeConstructor.apply(unicodeLength + 8), (Object)unicodeText).addRoundTrip(typeConstructor.apply(maxSize), (Object)unicodeText).addRoundTrip(typeConstructor.apply(nonBmpLength), (Object)nonBmpCharacter).addRoundTrip(typeConstructor.apply(nonBmpLength + 5), (Object)nonBmpCharacter);
    }

    @Test
    public void testDecimalMapping() {
        SqlDataTypeTest.create().addRoundTrip("decimal(3, 0)", "CAST(193 AS DECIMAL(3, 0))", (Type)DecimalType.createDecimalType((int)3, (int)0), "CAST(193 AS DECIMAL(3, 0))").addRoundTrip("decimal(3, 0)", "CAST(19 AS DECIMAL(3, 0)) ", (Type)DecimalType.createDecimalType((int)3, (int)0), "CAST(19 AS DECIMAL(3, 0))").addRoundTrip("decimal(3, 0)", "CAST(-193 AS DECIMAL(3, 0))", (Type)DecimalType.createDecimalType((int)3, (int)0), "CAST(-193 AS DECIMAL(3, 0))").addRoundTrip("decimal(3, 1)", "CAST(10.0 AS DECIMAL(3, 1))", (Type)DecimalType.createDecimalType((int)3, (int)1), "CAST(10.0 AS DECIMAL(3, 1))").addRoundTrip("decimal(3, 1)", "CAST(10.1 AS DECIMAL(3, 1))", (Type)DecimalType.createDecimalType((int)3, (int)1), "CAST(10.1 AS DECIMAL(3, 1))").addRoundTrip("decimal(3, 1)", "CAST(-10.1 AS DECIMAL(3, 1))", (Type)DecimalType.createDecimalType((int)3, (int)1), "CAST(-10.1 AS DECIMAL(3, 1))").addRoundTrip("decimal(4, 2)", "CAST(2 AS DECIMAL(4, 2))", (Type)DecimalType.createDecimalType((int)4, (int)2), "CAST(2 AS DECIMAL(4, 2))").addRoundTrip("decimal(4, 2)", "CAST(2.3 AS DECIMAL(4, 2))", (Type)DecimalType.createDecimalType((int)4, (int)2), "CAST(2.3 AS DECIMAL(4, 2))").addRoundTrip("decimal(24, 2)", "CAST(2 AS DECIMAL(24, 2))", (Type)DecimalType.createDecimalType((int)24, (int)2), "CAST(2 AS DECIMAL(24, 2))").addRoundTrip("decimal(24, 2)", "CAST(2.3 AS DECIMAL(24, 2))", (Type)DecimalType.createDecimalType((int)24, (int)2), "CAST(2.3 AS DECIMAL(24, 2))").addRoundTrip("decimal(24, 2)", "CAST(123456789.3 AS DECIMAL(24, 2))", (Type)DecimalType.createDecimalType((int)24, (int)2), "CAST(123456789.3 AS DECIMAL(24, 2))").addRoundTrip("decimal(24, 4)", "CAST(12345678901234567890.31 AS DECIMAL(24, 4))", (Type)DecimalType.createDecimalType((int)24, (int)4), "CAST(12345678901234567890.31 AS DECIMAL(24, 4))").addRoundTrip("decimal(30, 5)", "CAST(3141592653589793238462643.38327 AS DECIMAL(30, 5))", (Type)DecimalType.createDecimalType((int)30, (int)5), "CAST(3141592653589793238462643.38327 AS DECIMAL(30, 5))").addRoundTrip("decimal(30, 5)", "CAST(-3141592653589793238462643.38327 AS DECIMAL(30, 5))", (Type)DecimalType.createDecimalType((int)30, (int)5), "CAST(-3141592653589793238462643.38327 AS DECIMAL(30, 5))").addRoundTrip("decimal(38, 0)", "CAST('27182818284590452353602874713526624977' AS DECIMAL(38, 0))", (Type)DecimalType.createDecimalType((int)38, (int)0), "CAST('27182818284590452353602874713526624977' AS DECIMAL(38, 0))").addRoundTrip("decimal(38, 0)", "CAST('-27182818284590452353602874713526624977' AS DECIMAL(38, 0))", (Type)DecimalType.createDecimalType((int)38, (int)0), "CAST('-27182818284590452353602874713526624977' AS DECIMAL(38, 0))").addRoundTrip("decimal(38, 38)", "CAST(.10000200003000040000500006000070000888 AS DECIMAL(38, 38))", (Type)DecimalType.createDecimalType((int)38, (int)38), "CAST(.10000200003000040000500006000070000888 AS DECIMAL(38, 38))").addRoundTrip("decimal(38, 38)", "CAST(-.27182818284590452353602874713526624977 AS DECIMAL(38, 38))", (Type)DecimalType.createDecimalType((int)38, (int)38), "CAST(-.27182818284590452353602874713526624977 AS DECIMAL(38, 38))").addRoundTrip("decimal(10, 3)", "CAST(NULL AS DECIMAL(10, 3))", (Type)DecimalType.createDecimalType((int)10, (int)3), "CAST(NULL AS DECIMAL(10, 3))").execute(this.getQueryRunner(), this.trinoCreateAsSelect("decimals")).execute(this.getQueryRunner(), this.trinoCreateAndInsert("decimals"));
    }

    @Test
    public void testIntegerMappings() {
        SqlDataTypeTest.create().addRoundTrip("tinyint", "0", (Type)DecimalType.createDecimalType((int)3, (int)0), "CAST(0 AS DECIMAL(3, 0))").addRoundTrip("smallint", "0", (Type)DecimalType.createDecimalType((int)5, (int)0), "CAST(0 AS DECIMAL(5, 0))").addRoundTrip("integer", "0", (Type)DecimalType.createDecimalType((int)10, (int)0), "CAST(0 AS DECIMAL(10, 0))").addRoundTrip("bigint", "0", (Type)DecimalType.createDecimalType((int)19, (int)0), "CAST(0 AS DECIMAL(19, 0))").execute(this.getQueryRunner(), this.trinoCreateAsSelect("integers")).execute(this.getQueryRunner(), this.trinoCreateAndInsert("integers"));
    }

    @Test
    public void testDecimalReadMapping() {
        SqlDataTypeTest.create().addRoundTrip("decimal(3, 0)", "193", (Type)DecimalType.createDecimalType((int)3, (int)0), "CAST(193 AS DECIMAL(3, 0))").addRoundTrip("decimal(3, 0)", "19", (Type)DecimalType.createDecimalType((int)3, (int)0), "CAST(19 AS DECIMAL(3, 0))").addRoundTrip("decimal(3, 0)", "-193", (Type)DecimalType.createDecimalType((int)3, (int)0), "CAST(-193 AS DECIMAL(3, 0))").addRoundTrip("decimal(3, 1)", "10.0", (Type)DecimalType.createDecimalType((int)3, (int)1), "CAST(10.0 AS DECIMAL(3, 1))").addRoundTrip("decimal(3, 1)", "10.1", (Type)DecimalType.createDecimalType((int)3, (int)1), "CAST(10.1 AS DECIMAL(3, 1))").addRoundTrip("decimal(3, 1)", "-10.1", (Type)DecimalType.createDecimalType((int)3, (int)1), "CAST(-10.1 AS DECIMAL(3, 1))").addRoundTrip("decimal(4, 2)", "2", (Type)DecimalType.createDecimalType((int)4, (int)2), "CAST(2 AS DECIMAL(4, 2))").addRoundTrip("decimal(4, 2)", "2.3", (Type)DecimalType.createDecimalType((int)4, (int)2), "CAST(2.3 AS DECIMAL(4, 2))").addRoundTrip("decimal(24, 2)", "2", (Type)DecimalType.createDecimalType((int)24, (int)2), "CAST(2 AS DECIMAL(24, 2))").addRoundTrip("decimal(24, 2)", "2.3", (Type)DecimalType.createDecimalType((int)24, (int)2), "CAST(2.3 AS DECIMAL(24, 2))").addRoundTrip("decimal(24, 2)", "123456789.3", (Type)DecimalType.createDecimalType((int)24, (int)2), "CAST(123456789.3 AS DECIMAL(24, 2))").addRoundTrip("decimal(24, 4)", "12345678901234567890.31", (Type)DecimalType.createDecimalType((int)24, (int)4), "CAST(12345678901234567890.31 AS DECIMAL(24, 4))").addRoundTrip("decimal(30, 5)", "3141592653589793238462643.38327", (Type)DecimalType.createDecimalType((int)30, (int)5), "CAST(3141592653589793238462643.38327 AS DECIMAL(30, 5))").addRoundTrip("decimal(30, 5)", "-3141592653589793238462643.38327", (Type)DecimalType.createDecimalType((int)30, (int)5), "CAST(-3141592653589793238462643.38327 AS DECIMAL(30, 5))").addRoundTrip("decimal(38, 0)", "27182818284590452353602874713526624977", (Type)DecimalType.createDecimalType((int)38, (int)0), "CAST('27182818284590452353602874713526624977' AS DECIMAL(38, 0))").addRoundTrip("decimal(38, 0)", "-27182818284590452353602874713526624977", (Type)DecimalType.createDecimalType((int)38, (int)0), "CAST('-27182818284590452353602874713526624977' AS DECIMAL(38, 0))").addRoundTrip("decimal(38, 38)", ".10000200003000040000500006000070000888", (Type)DecimalType.createDecimalType((int)38, (int)38), "CAST(.10000200003000040000500006000070000888 AS DECIMAL(38, 38))").addRoundTrip("decimal(38, 38)", "-.27182818284590452353602874713526624977", (Type)DecimalType.createDecimalType((int)38, (int)38), "CAST(-.27182818284590452353602874713526624977 AS DECIMAL(38, 38))").addRoundTrip("decimal(10, 3)", "NULL", (Type)DecimalType.createDecimalType((int)10, (int)3), "CAST(NULL AS DECIMAL(10, 3))").execute(this.getQueryRunner(), this.oracleCreateAndInsert("read_decimals"));
    }

    @Test
    public void testNumberWithoutScaleReadMapping() {
        SqlDataTypeTest.create().addRoundTrip("number(1)", "1", (Type)DecimalType.createDecimalType((int)1, (int)0), "CAST (1 AS DECIMAL(1, 0))").addRoundTrip("number(2)", "99", (Type)DecimalType.createDecimalType((int)2, (int)0), "CAST (99 AS DECIMAL(2, 0))").addRoundTrip("number(38)", "99999999999999999999999999999999999999", (Type)DecimalType.createDecimalType((int)38, (int)0), "CAST ('99999999999999999999999999999999999999' AS DECIMAL(38, 0))").addRoundTrip("number(38)", "-99999999999999999999999999999999999999", (Type)DecimalType.createDecimalType((int)38, (int)0), "CAST ('-99999999999999999999999999999999999999' AS DECIMAL(38, 0))").execute(this.getQueryRunner(), this.oracleCreateAndInsert("number_without_scale"));
    }

    @Test
    public void testNumberWithoutPrecisionAndScaleReadMapping() {
        SqlDataTypeTest.create().addRoundTrip("number", "1", (Type)DecimalType.createDecimalType((int)38, (int)9), "CAST(1 AS DECIMAL(38, 9))").addRoundTrip("number", "99", (Type)DecimalType.createDecimalType((int)38, (int)9), "CAST(99 AS DECIMAL(38, 9))").addRoundTrip("number", "9999999999999999999999999999.999999999", (Type)DecimalType.createDecimalType((int)38, (int)9), "CAST('9999999999999999999999999999.999999999' AS DECIMAL(38, 9))").addRoundTrip("number", "-9999999999999999999999999999.999999999", (Type)DecimalType.createDecimalType((int)38, (int)9), "CAST('-9999999999999999999999999999.999999999' AS DECIMAL(38, 9))").execute(this.getQueryRunner(), this.number(9), this.oracleCreateAndInsert("no_prec_and_scale"));
    }

    @Test
    public void testRoundingOfUnspecifiedNumber() {
        try (TestTable table = this.oracleTable("rounding", "col NUMBER", "(0.123456789)");){
            this.assertQuery(this.number(9), "SELECT * FROM " + table.getName(), "VALUES 0.123456789");
            this.assertQuery(this.number(RoundingMode.HALF_EVEN, 6), "SELECT * FROM " + table.getName(), "VALUES 0.123457");
            this.assertQuery(this.number(RoundingMode.HALF_EVEN, 3), "SELECT * FROM " + table.getName(), "VALUES 0.123");
            this.assertQueryFails(this.number(RoundingMode.UNNECESSARY, 3), "SELECT * FROM " + table.getName(), "Rounding necessary");
        }
        table = this.oracleTable("rounding", "col NUMBER", "(123456789012345678901234567890.123456789)");
        try {
            this.assertQueryFails(this.number(9), "SELECT * FROM " + table.getName(), "Decimal overflow");
            this.assertQuery(this.number(RoundingMode.HALF_EVEN, 8), "SELECT * FROM " + table.getName(), "VALUES 123456789012345678901234567890.12345679");
            this.assertQuery(this.number(RoundingMode.HALF_EVEN, 6), "SELECT * FROM " + table.getName(), "VALUES 123456789012345678901234567890.123457");
            this.assertQuery(this.number(RoundingMode.HALF_EVEN, 3), "SELECT * FROM " + table.getName(), "VALUES 123456789012345678901234567890.123");
            this.assertQueryFails(this.number(RoundingMode.UNNECESSARY, 3), "SELECT * FROM " + table.getName(), "Rounding necessary");
        }
        finally {
            if (table != null) {
                table.close();
            }
        }
        table = this.oracleTable("rounding", "col NUMBER", "(123456789012345678901234567890123456789)");
        try {
            this.assertQueryFails(this.number(0), "SELECT * FROM " + table.getName(), "Decimal overflow");
            this.assertQueryFails(this.number(RoundingMode.HALF_EVEN, 8), "SELECT * FROM " + table.getName(), "Decimal overflow");
            this.assertQueryFails(this.number(RoundingMode.HALF_EVEN, 0), "SELECT * FROM " + table.getName(), "Decimal overflow");
        }
        finally {
            if (table != null) {
                table.close();
            }
        }
    }

    @Test
    public void testNumberNegativeScaleReadMapping() {
        SqlDataTypeTest.create().addRoundTrip("number(1, -1)", "20", (Type)DecimalType.createDecimalType((int)2, (int)0), "CAST(20 AS DECIMAL(2, 0))").addRoundTrip("number(1, -1)", "35", (Type)DecimalType.createDecimalType((int)2, (int)0), "CAST(40 AS DECIMAL(2, 0))").addRoundTrip("number(2, -4)", "470000", (Type)DecimalType.createDecimalType((int)6, (int)0), "CAST(470000 AS DECIMAL(6, 0))").addRoundTrip("number(2, -4)", "-80000", (Type)DecimalType.createDecimalType((int)6, (int)0), "CAST(-80000 AS DECIMAL(6, 0))").addRoundTrip("number(8, -3)", "-8.8888888E+10", (Type)DecimalType.createDecimalType((int)11, (int)0), "CAST(-8.8888888E+10 AS DECIMAL(11, 0))").addRoundTrip("number(8, -3)", "4050000", (Type)DecimalType.createDecimalType((int)11, (int)0), "CAST(4050000 AS DECIMAL(11, 0))").addRoundTrip("number(14, -14)", "1.4000014000014E+27", (Type)DecimalType.createDecimalType((int)28, (int)0), "CAST(1.4000014000014E+27 AS DECIMAL(28, 0))").addRoundTrip("number(14, -14)", "1E+21", (Type)DecimalType.createDecimalType((int)28, (int)0), "CAST(1E+21 AS DECIMAL(28, 0))").addRoundTrip("number(5, -33)", "1.2345E+37", (Type)DecimalType.createDecimalType((int)38, (int)0), "CAST(1.2345E+37 AS DECIMAL(38, 0))").addRoundTrip("number(5, -33)", "-1.2345E+37", (Type)DecimalType.createDecimalType((int)38, (int)0), "CAST(-1.2345E+37 AS DECIMAL(38, 0))").addRoundTrip("number(1, -37)", "1E+37", (Type)DecimalType.createDecimalType((int)38, (int)0), "CAST(1E+37 AS DECIMAL(38, 0))").addRoundTrip("number(1, -37)", "-1E+37", (Type)DecimalType.createDecimalType((int)38, (int)0), "CAST(-1E+37 AS DECIMAL(38, 0))").addRoundTrip("number(37, -1)", "99999999999999999999999999999999999990", (Type)DecimalType.createDecimalType((int)38, (int)0), "CAST('99999999999999999999999999999999999990' AS DECIMAL(38, 0))").addRoundTrip("number(37, -1)", "-99999999999999999999999999999999999990", (Type)DecimalType.createDecimalType((int)38, (int)0), "CAST('-99999999999999999999999999999999999990' AS DECIMAL(38, 0))").execute(this.getQueryRunner(), this.oracleCreateAndInsert("number_negative_s"));
    }

    @Test
    public void testHighNumberScale() {
        try (TestTable table = this.oracleTable("highNumberScale", "col NUMBER(38, 40)", "(0.0012345678901234567890123456789012345678)");){
            this.assertQueryFails(this.number(RoundingMode.UNNECESSARY), "SELECT * FROM " + table.getName(), NO_SUPPORTED_COLUMNS);
            this.assertQuery(this.number(RoundingMode.HALF_EVEN), "SELECT * FROM " + table.getName(), "VALUES 0.00123456789012345678901234567890123457");
            this.assertQuery(this.numberConvertToVarchar(), "SELECT * FROM " + table.getName(), "VALUES '1.2345678901234567890123456789012345678E-03'");
        }
        table = this.oracleTable("highNumberScale", "col NUMBER(18, 40)", "(0.0000000000000000000000123456789012345678)");
        try {
            this.assertQueryFails(this.number(RoundingMode.UNNECESSARY), "SELECT * FROM " + table.getName(), NO_SUPPORTED_COLUMNS);
            this.assertQuery(this.number(RoundingMode.HALF_EVEN), "SELECT * FROM " + table.getName(), "VALUES 0.00000000000000000000001234567890123457");
        }
        finally {
            if (table != null) {
                table.close();
            }
        }
        table = this.oracleTable("highNumberScale", "col NUMBER(38, 80)", "(0.00000000000000000000000000000000000000000000012345678901234567890123456789012345678)");
        try {
            this.assertQuery(this.number(RoundingMode.HALF_EVEN), "SELECT * FROM " + table.getName(), "VALUES 0");
            this.assertQuery(this.numberConvertToVarchar(), "SELECT * FROM " + table.getName(), "VALUES '1.2345678901234567890123456789012346E-46'");
        }
        finally {
            if (table != null) {
                table.close();
            }
        }
    }

    @Test
    public void testNumberWithHiveNegativeScaleReadMapping() {
        try (TestTable table = this.oracleTable("highNegativeScale", "col NUMBER(38, -60)", "(1234567890123456789012345678901234567000000000000000000000000000000000000000000000000000000000000)");){
            this.assertQuery(this.numberConvertToVarchar(), "SELECT * FROM " + table.getName(), "VALUES '1.234567890123456789012345678901234567E96'");
        }
        table = this.oracleTable("highNumberScale", "col NUMBER(18, 60)", "(0.000000000000000000000000000000000000000000000123456789012345678)");
        try {
            this.assertQuery(this.number(RoundingMode.HALF_EVEN), "SELECT * FROM " + table.getName(), "VALUES 0");
        }
        finally {
            if (table != null) {
                table.close();
            }
        }
    }

    private Session number(int scale) {
        return this.number(UnsupportedTypeHandling.IGNORE, RoundingMode.UNNECESSARY, Optional.of(scale));
    }

    private Session number(RoundingMode roundingMode) {
        return this.number(UnsupportedTypeHandling.IGNORE, roundingMode, Optional.empty());
    }

    private Session number(RoundingMode roundingMode, int scale) {
        return this.number(UnsupportedTypeHandling.IGNORE, roundingMode, Optional.of(scale));
    }

    private Session numberConvertToVarchar() {
        return this.number(UnsupportedTypeHandling.CONVERT_TO_VARCHAR, RoundingMode.UNNECESSARY, Optional.empty());
    }

    private Session number(UnsupportedTypeHandling unsupportedTypeHandlingStrategy, RoundingMode roundingMode, Optional<Integer> scale) {
        Session.SessionBuilder builder = Session.builder((Session)this.getSession()).setCatalogSessionProperty("oracle", "unsupported_type_handling", unsupportedTypeHandlingStrategy.name()).setCatalogSessionProperty("oracle", "number_rounding_mode", roundingMode.name());
        scale.ifPresent(value -> builder.setCatalogSessionProperty("oracle", "number_default_scale", value.toString()));
        return builder.build();
    }

    @Test
    public void testSpecialNumberFormats() {
        this.getOracleSqlExecutor().execute("CREATE TABLE test (num1 number)");
        this.getOracleSqlExecutor().execute("INSERT INTO test VALUES (12345678901234567890.12345678901234567890123456789012345678)");
        this.assertQuery(this.number(RoundingMode.HALF_UP, 10), "SELECT * FROM test", "VALUES (12345678901234567890.1234567890)");
    }

    @Test
    public void testBooleanType() {
        SqlDataTypeTest.create().addRoundTrip("boolean", "CAST(true AS DECIMAL(1, 0))", (Type)DecimalType.createDecimalType((int)1, (int)0), "CAST(true AS DECIMAL(1, 0))").addRoundTrip("boolean", "CAST(false AS DECIMAL(1, 0))", (Type)DecimalType.createDecimalType((int)1, (int)0), "CAST(false AS DECIMAL(1, 0))").execute(this.getQueryRunner(), this.trinoCreateAsSelect("boolean_types")).execute(this.getQueryRunner(), this.trinoCreateAndInsert("boolean_types"));
    }

    @Test
    public void testVarbinary() {
        SqlDataTypeTest.create().addRoundTrip("varbinary", "NULL", (Type)VarbinaryType.VARBINARY, "CAST(NULL AS varbinary)").addRoundTrip("varbinary", "X''", (Type)VarbinaryType.VARBINARY, "CAST(NULL AS varbinary)").addRoundTrip("varbinary", "X'68656C6C6F'", (Type)VarbinaryType.VARBINARY, "to_utf8('hello')").addRoundTrip("varbinary", "X'5069C4996B6E6120C582C4856B61207720E69DB1E4BAACE983BD'", (Type)VarbinaryType.VARBINARY, "to_utf8('Pi\u0119kna \u0142\u0105ka w \u6771\u4eac\u90fd')").addRoundTrip("varbinary", "X'4261672066756C6C206F6620F09F92B0'", (Type)VarbinaryType.VARBINARY, "to_utf8('Bag full of \ud83d\udcb0')").addRoundTrip("varbinary", "X'0001020304050607080DF9367AA7000000'", (Type)VarbinaryType.VARBINARY, "X'0001020304050607080DF9367AA7000000'").addRoundTrip("varbinary", "X'000000000000'", (Type)VarbinaryType.VARBINARY, "X'000000000000'").execute(this.getQueryRunner(), this.trinoCreateAsSelect("test_varbinary")).execute(this.getQueryRunner(), this.trinoCreateAndInsert("test_varbinary"));
        SqlDataTypeTest.create().addRoundTrip("blob", "NULL", (Type)VarbinaryType.VARBINARY, "CAST(NULL AS varbinary)").addRoundTrip("blob", "empty_blob()", (Type)VarbinaryType.VARBINARY, "X''").addRoundTrip("blob", "hextoraw('68656C6C6F')", (Type)VarbinaryType.VARBINARY, "to_utf8('hello')").addRoundTrip("blob", "hextoraw('5069C4996B6E6120C582C4856B61207720E69DB1E4BAACE983BD')", (Type)VarbinaryType.VARBINARY, "to_utf8('Pi\u0119kna \u0142\u0105ka w \u6771\u4eac\u90fd')").addRoundTrip("blob", "hextoraw('4261672066756C6C206F6620F09F92B0')", (Type)VarbinaryType.VARBINARY, "to_utf8('Bag full of \ud83d\udcb0')").addRoundTrip("blob", "hextoraw('0001020304050607080DF9367AA7000000')", (Type)VarbinaryType.VARBINARY, "X'0001020304050607080DF9367AA7000000'").addRoundTrip("blob", "hextoraw('000000000000')", (Type)VarbinaryType.VARBINARY, "X'000000000000'").execute(this.getQueryRunner(), this.oracleCreateAndInsert("test_blob"));
        SqlDataTypeTest.create().addRoundTrip("raw(2000)", "NULL", (Type)VarbinaryType.VARBINARY, "CAST(NULL AS varbinary)").addRoundTrip("raw(2000)", "empty_blob()", (Type)VarbinaryType.VARBINARY, "CAST(NULL AS varbinary)").addRoundTrip("raw(2000)", "hextoraw('68656C6C6F')", (Type)VarbinaryType.VARBINARY, "to_utf8('hello')").addRoundTrip("raw(2000)", "hextoraw('5069C4996B6E6120C582C4856B61207720E69DB1E4BAACE983BD')", (Type)VarbinaryType.VARBINARY, "to_utf8('Pi\u0119kna \u0142\u0105ka w \u6771\u4eac\u90fd')").addRoundTrip("raw(2000)", "hextoraw('4261672066756C6C206F6620F09F92B0')", (Type)VarbinaryType.VARBINARY, "to_utf8('Bag full of \ud83d\udcb0')").addRoundTrip("raw(2000)", "hextoraw('0001020304050607080DF9367AA7000000')", (Type)VarbinaryType.VARBINARY, "X'0001020304050607080DF9367AA7000000'").addRoundTrip("raw(2000)", "hextoraw('000000000000')", (Type)VarbinaryType.VARBINARY, "X'000000000000'").execute(this.getQueryRunner(), this.oracleCreateAndInsert("test_blob"));
    }

    @Test
    public void testDate() {
        LocalDate dateOfLocalTimeChangeForwardAtMidnightInJvmZone = LocalDate.of(1970, 1, 1);
        Verify.verify((boolean)this.jvmZone.getRules().getValidOffsets(dateOfLocalTimeChangeForwardAtMidnightInJvmZone.atStartOfDay()).isEmpty());
        ZoneId someZone = ZoneId.of("Europe/Vilnius");
        LocalDate dateOfLocalTimeChangeForwardAtMidnightInSomeZone = LocalDate.of(1983, 4, 1);
        Verify.verify((boolean)someZone.getRules().getValidOffsets(dateOfLocalTimeChangeForwardAtMidnightInSomeZone.atStartOfDay()).isEmpty());
        LocalDate dateOfLocalTimeChangeBackwardAtMidnightInSomeZone = LocalDate.of(1983, 10, 1);
        Verify.verify((someZone.getRules().getValidOffsets(dateOfLocalTimeChangeBackwardAtMidnightInSomeZone.atStartOfDay().minusMinutes(1L)).size() == 2 ? 1 : 0) != 0);
        SqlDataTypeTest dateTests = SqlDataTypeTest.create().addRoundTrip("DATE", "DATE '1952-04-03'", (Type)TimestampType.TIMESTAMP_MILLIS, "TIMESTAMP '1952-04-03 00:00:00.000'").addRoundTrip("DATE", "DATE '1970-01-01'", (Type)TimestampType.TIMESTAMP_MILLIS, "TIMESTAMP '1970-01-01 00:00:00.000'").addRoundTrip("DATE", "DATE '1970-02-03'", (Type)TimestampType.TIMESTAMP_MILLIS, "TIMESTAMP '1970-02-03 00:00:00.000'").addRoundTrip("DATE", "DATE '2017-07-01'", (Type)TimestampType.TIMESTAMP_MILLIS, "TIMESTAMP '2017-07-01 00:00:00.000'").addRoundTrip("DATE", "DATE '2017-01-01'", (Type)TimestampType.TIMESTAMP_MILLIS, "TIMESTAMP '2017-01-01 00:00:00.000'").addRoundTrip("DATE", "DATE '1983-04-01'", (Type)TimestampType.TIMESTAMP_MILLIS, "TIMESTAMP '1983-04-01 00:00:00.000'").addRoundTrip("DATE", "DATE '1983-10-01'", (Type)TimestampType.TIMESTAMP_MILLIS, "TIMESTAMP '1983-10-01 00:00:00.000'");
        for (String timeZoneId : ImmutableList.of((Object)TimeZoneKey.UTC_KEY.getId(), (Object)ZoneId.systemDefault().getId(), (Object)ZoneId.of("Europe/Vilnius").getId())) {
            Session session = Session.builder((Session)this.getSession()).setTimeZoneKey(TimeZoneKey.getTimeZoneKey((String)timeZoneId)).build();
            dateTests.execute(this.getQueryRunner(), session, this.oracleCreateAndInsert("test_date"));
            dateTests.execute(this.getQueryRunner(), session, this.trinoCreateAsSelect("test_date"));
            dateTests.execute(this.getQueryRunner(), session, this.trinoCreateAndInsert("test_date"));
        }
    }

    @Test(dataProvider="testTimestampDataProvider")
    public void testTimestamp(ZoneId sessionZone) {
        SqlDataTypeTest tests = SqlDataTypeTest.create().addRoundTrip("timestamp", "TIMESTAMP '1958-01-01 13:18:03.123'", (Type)TimestampType.TIMESTAMP_MILLIS, "TIMESTAMP '1958-01-01 13:18:03.123'").addRoundTrip("timestamp", "TIMESTAMP '2019-03-18 10:01:17.987'", (Type)TimestampType.TIMESTAMP_MILLIS, "TIMESTAMP '2019-03-18 10:01:17.987'").addRoundTrip("timestamp", "TIMESTAMP '1970-01-01 00:00:00.000'", (Type)TimestampType.TIMESTAMP_MILLIS, "TIMESTAMP '1970-01-01 00:00:00.000'").addRoundTrip("timestamp", DataType.timestampDataType((int)3).toLiteral((Object)this.timeDoubledInJvmZone), (Type)TimestampType.TIMESTAMP_MILLIS, DataType.timestampDataType((int)3).toLiteral((Object)this.timeDoubledInJvmZone)).addRoundTrip("timestamp", DataType.timestampDataType((int)3).toLiteral((Object)this.timeDoubledInVilnius), (Type)TimestampType.TIMESTAMP_MILLIS, DataType.timestampDataType((int)3).toLiteral((Object)this.timeDoubledInVilnius)).addRoundTrip("timestamp", DataType.timestampDataType((int)3).toLiteral((Object)this.timeGapInJvmZone1), (Type)TimestampType.TIMESTAMP_MILLIS, DataType.timestampDataType((int)3).toLiteral((Object)this.timeGapInJvmZone1)).addRoundTrip("timestamp", DataType.timestampDataType((int)3).toLiteral((Object)this.timeGapInJvmZone2), (Type)TimestampType.TIMESTAMP_MILLIS, DataType.timestampDataType((int)3).toLiteral((Object)this.timeGapInJvmZone2)).addRoundTrip("timestamp", DataType.timestampDataType((int)3).toLiteral((Object)this.timeGapInVilnius), (Type)TimestampType.TIMESTAMP_MILLIS, DataType.timestampDataType((int)3).toLiteral((Object)this.timeGapInVilnius)).addRoundTrip("timestamp", DataType.timestampDataType((int)3).toLiteral((Object)this.timeGapInKathmandu), (Type)TimestampType.TIMESTAMP_MILLIS, DataType.timestampDataType((int)3).toLiteral((Object)this.timeGapInKathmandu));
        Session session = Session.builder((Session)this.getSession()).setTimeZoneKey(TimeZoneKey.getTimeZoneKey((String)sessionZone.getId())).build();
        tests.execute(this.getQueryRunner(), session, this.trinoCreateAsSelect(session, "test_timestamp"));
        tests.execute(this.getQueryRunner(), session, this.trinoCreateAndInsert("test_timestamp"));
        tests.execute(this.getQueryRunner(), session, this.oracleCreateAndInsert("test_timestamp"));
    }

    @DataProvider
    public Object[][] testTimestampDataProvider() {
        return new Object[][]{{ZoneOffset.UTC}, {this.jvmZone}, {this.vilnius}, {this.kathmandu}, {ZoneId.of(TestingSession.DEFAULT_TIME_ZONE_KEY.getId())}};
    }

    @Test
    public void testTimestampWithTimeZoneFromTrino() {
        SqlDataTypeTest.create().addRoundTrip("timestamp with time zone", "TIMESTAMP '1970-01-01 00:00:00.000 Z'", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, "TIMESTAMP '1970-01-01 00:00:00.000 Z'").addRoundTrip("timestamp with time zone", "TIMESTAMP '1970-01-01 00:00:00.000 Asia/Kathmandu'", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, "TIMESTAMP '1970-01-01 00:00:00.000 Asia/Kathmandu'").addRoundTrip("timestamp with time zone", "TIMESTAMP '1970-01-01 00:00:00.000 +02:17'", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, "TIMESTAMP '1970-01-01 00:00:00.000 +02:17'").addRoundTrip("timestamp with time zone", "TIMESTAMP '1970-01-01 00:00:00.000 -07:31'", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, "TIMESTAMP '1970-01-01 00:00:00.000 -07:31'").addRoundTrip("timestamp with time zone", "TIMESTAMP '1958-01-01 13:18:03.123 Z'", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, "TIMESTAMP '1958-01-01 13:18:03.123 Z'").addRoundTrip("timestamp with time zone", "TIMESTAMP '1958-01-01 13:18:03.123 Asia/Kathmandu'", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, "TIMESTAMP '1958-01-01 13:18:03.123 Asia/Kathmandu'").addRoundTrip("timestamp with time zone", "TIMESTAMP '1958-01-01 13:18:03.123 +02:17'", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, "TIMESTAMP '1958-01-01 13:18:03.123 +02:17'").addRoundTrip("timestamp with time zone", "TIMESTAMP '1958-01-01 13:18:03.123 -07:31'", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, "TIMESTAMP '1958-01-01 13:18:03.123 -07:31'").addRoundTrip("timestamp with time zone", "TIMESTAMP '2019-03-18 10:01:17.987 Z'", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, "TIMESTAMP '2019-03-18 10:01:17.987 Z'").addRoundTrip("timestamp with time zone", "TIMESTAMP '2019-03-18 10:01:17.987 Asia/Kathmandu'", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, "TIMESTAMP '2019-03-18 10:01:17.987 Asia/Kathmandu'").addRoundTrip("timestamp with time zone", "TIMESTAMP '2019-03-18 10:01:17.987 +02:17'", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, "TIMESTAMP '2019-03-18 10:01:17.987 +02:17'").addRoundTrip("timestamp with time zone", "TIMESTAMP '2019-03-18 10:01:17.987 -07:31'", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, "TIMESTAMP '2019-03-18 10:01:17.987 -07:31'").addRoundTrip("timestamp with time zone", DataType.timestampWithTimeZoneDataType((int)3).toLiteral((Object)this.timeDoubledInJvmZone.atZone(ZoneOffset.UTC)), (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, DataType.timestampWithTimeZoneDataType((int)3).toLiteral((Object)this.timeDoubledInJvmZone.atZone(ZoneOffset.UTC))).addRoundTrip("timestamp with time zone", DataType.timestampWithTimeZoneDataType((int)3).toLiteral((Object)this.timeDoubledInJvmZone.atZone(this.jvmZone)), (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, DataType.timestampWithTimeZoneDataType((int)3).toLiteral((Object)this.timeDoubledInJvmZone.atZone(this.jvmZone))).addRoundTrip("timestamp with time zone", DataType.timestampWithTimeZoneDataType((int)3).toLiteral((Object)this.timeDoubledInJvmZone.atZone(this.kathmandu)), (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, DataType.timestampWithTimeZoneDataType((int)3).toLiteral((Object)this.timeDoubledInJvmZone.atZone(this.kathmandu))).addRoundTrip("timestamp with time zone", DataType.timestampWithTimeZoneDataType((int)3).toLiteral((Object)this.timeDoubledInVilnius.atZone(ZoneOffset.UTC)), (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, DataType.timestampWithTimeZoneDataType((int)3).toLiteral((Object)this.timeDoubledInVilnius.atZone(ZoneOffset.UTC))).addRoundTrip("timestamp with time zone", DataType.timestampWithTimeZoneDataType((int)3).toLiteral((Object)this.timeDoubledInVilnius.atZone(this.vilnius)), (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, DataType.timestampWithTimeZoneDataType((int)3).toLiteral((Object)this.timeDoubledInVilnius.atZone(this.vilnius))).addRoundTrip("timestamp with time zone", DataType.timestampWithTimeZoneDataType((int)3).toLiteral((Object)this.timeDoubledInVilnius.atZone(this.kathmandu)), (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, DataType.timestampWithTimeZoneDataType((int)3).toLiteral((Object)this.timeDoubledInVilnius.atZone(this.kathmandu))).addRoundTrip("timestamp with time zone", DataType.timestampWithTimeZoneDataType((int)3).toLiteral((Object)this.timeGapInJvmZone1.atZone(ZoneOffset.UTC)), (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, DataType.timestampWithTimeZoneDataType((int)3).toLiteral((Object)this.timeGapInJvmZone1.atZone(ZoneOffset.UTC))).addRoundTrip("timestamp with time zone", DataType.timestampWithTimeZoneDataType((int)3).toLiteral((Object)this.timeGapInJvmZone1.atZone(this.kathmandu)), (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, DataType.timestampWithTimeZoneDataType((int)3).toLiteral((Object)this.timeGapInJvmZone1.atZone(this.kathmandu))).addRoundTrip("timestamp with time zone", DataType.timestampWithTimeZoneDataType((int)3).toLiteral((Object)this.timeGapInJvmZone2.atZone(ZoneOffset.UTC)), (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, DataType.timestampWithTimeZoneDataType((int)3).toLiteral((Object)this.timeGapInJvmZone2.atZone(ZoneOffset.UTC))).addRoundTrip("timestamp with time zone", DataType.timestampWithTimeZoneDataType((int)3).toLiteral((Object)this.timeGapInJvmZone2.atZone(this.kathmandu)), (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, DataType.timestampWithTimeZoneDataType((int)3).toLiteral((Object)this.timeGapInJvmZone2.atZone(this.kathmandu))).addRoundTrip("timestamp with time zone", DataType.timestampWithTimeZoneDataType((int)3).toLiteral((Object)this.timeGapInVilnius.atZone(this.kathmandu)), (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, DataType.timestampWithTimeZoneDataType((int)3).toLiteral((Object)this.timeGapInVilnius.atZone(this.kathmandu))).addRoundTrip("timestamp with time zone", DataType.timestampWithTimeZoneDataType((int)3).toLiteral((Object)this.timeGapInKathmandu.atZone(this.vilnius)), (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, DataType.timestampWithTimeZoneDataType((int)3).toLiteral((Object)this.timeGapInKathmandu.atZone(this.vilnius))).execute(this.getQueryRunner(), this.trinoCreateAsSelect("timestamp_tz")).execute(this.getQueryRunner(), this.trinoCreateAndInsert("timestamp_tz"));
    }

    @Test
    public void testTimestampWithTimeZoneFromOracle() {
        DataTypeTest.create().addRoundTrip(OracleDataTypes.oracleTimestamp3TimeZoneDataType(), (Object)this.timeDoubledInJvmZone.atZone(this.jvmZone)).addRoundTrip(OracleDataTypes.oracleTimestamp3TimeZoneDataType(), (Object)this.timeDoubledInVilnius.atZone(this.vilnius)).execute(this.getQueryRunner(), this.oracleCreateAndInsert("timestamp_tz"));
        SqlDataTypeTest.create().addRoundTrip("TIMESTAMP(3) WITH TIME ZONE", "from_tz(TIMESTAMP '1970-01-01 00:00:00.000000000', 'UTC')", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, "TIMESTAMP '1970-01-01 00:00:00.000 Z'").addRoundTrip("TIMESTAMP(3) WITH TIME ZONE", "from_tz(TIMESTAMP '1970-01-01 00:00:00.000000000', 'Asia/Kathmandu')", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, "TIMESTAMP '1970-01-01 00:00:00.000 Asia/Kathmandu'").addRoundTrip("TIMESTAMP(3) WITH TIME ZONE", "from_tz(TIMESTAMP '1970-01-01 00:00:00.000000000', '+02:17')", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, "TIMESTAMP '1970-01-01 00:00:00.000 +02:17'").addRoundTrip("TIMESTAMP(3) WITH TIME ZONE", "from_tz(TIMESTAMP '1970-01-01 00:00:00.000000000', '-07:31')", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, "TIMESTAMP '1970-01-01 00:00:00.000 -07:31'").addRoundTrip("TIMESTAMP(3) WITH TIME ZONE", "from_tz(TIMESTAMP '1958-01-01 13:18:03.123000000', 'UTC')", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, "TIMESTAMP '1958-01-01 13:18:03.123 Z'").addRoundTrip("TIMESTAMP(3) WITH TIME ZONE", "from_tz(TIMESTAMP '1958-01-01 13:18:03.123000000', 'Asia/Kathmandu')", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, "TIMESTAMP '1958-01-01 13:18:03.123 Asia/Kathmandu'").addRoundTrip("TIMESTAMP(3) WITH TIME ZONE", "from_tz(TIMESTAMP '1958-01-01 13:18:03.123000000', '+02:17')", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, "TIMESTAMP '1958-01-01 13:18:03.123 +02:17'").addRoundTrip("TIMESTAMP(3) WITH TIME ZONE", "from_tz(TIMESTAMP '1958-01-01 13:18:03.123000000', '-07:31')", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, "TIMESTAMP '1958-01-01 13:18:03.123 -07:31'").addRoundTrip("TIMESTAMP(3) WITH TIME ZONE", "from_tz(TIMESTAMP '2019-03-18 10:01:17.987000000', 'UTC')", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, "TIMESTAMP '2019-03-18 10:01:17.987 Z'").addRoundTrip("TIMESTAMP(3) WITH TIME ZONE", "from_tz(TIMESTAMP '2019-03-18 10:01:17.987000000', 'Asia/Kathmandu')", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, "TIMESTAMP '2019-03-18 10:01:17.987 Asia/Kathmandu'").addRoundTrip("TIMESTAMP(3) WITH TIME ZONE", "from_tz(TIMESTAMP '2019-03-18 10:01:17.987000000', '+02:17')", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, "TIMESTAMP '2019-03-18 10:01:17.987 +02:17'").addRoundTrip("TIMESTAMP(3) WITH TIME ZONE", "from_tz(TIMESTAMP '2019-03-18 10:01:17.987000000', '-07:31')", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, "TIMESTAMP '2019-03-18 10:01:17.987 -07:31'").addRoundTrip("TIMESTAMP(3) WITH TIME ZONE", OracleDataTypes.oracleTimestamp3TimeZoneDataType().toLiteral((Object)this.timeDoubledInJvmZone.atZone(ZoneOffset.UTC)), (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, DataType.timestampWithTimeZoneDataType((int)3).toLiteral((Object)this.timeDoubledInJvmZone.atZone(ZoneOffset.UTC))).addRoundTrip("TIMESTAMP(3) WITH TIME ZONE", OracleDataTypes.oracleTimestamp3TimeZoneDataType().toLiteral((Object)this.timeDoubledInJvmZone.atZone(this.kathmandu)), (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, DataType.timestampWithTimeZoneDataType((int)3).toLiteral((Object)this.timeDoubledInJvmZone.atZone(this.kathmandu))).addRoundTrip("TIMESTAMP(3) WITH TIME ZONE", OracleDataTypes.oracleTimestamp3TimeZoneDataType().toLiteral((Object)this.timeDoubledInVilnius.atZone(ZoneOffset.UTC)), (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, DataType.timestampWithTimeZoneDataType((int)3).toLiteral((Object)this.timeDoubledInVilnius.atZone(ZoneOffset.UTC))).addRoundTrip("TIMESTAMP(3) WITH TIME ZONE", OracleDataTypes.oracleTimestamp3TimeZoneDataType().toLiteral((Object)this.timeDoubledInVilnius.atZone(this.kathmandu)), (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, DataType.timestampWithTimeZoneDataType((int)3).toLiteral((Object)this.timeDoubledInVilnius.atZone(this.kathmandu))).addRoundTrip("TIMESTAMP(3) WITH TIME ZONE", OracleDataTypes.oracleTimestamp3TimeZoneDataType().toLiteral((Object)this.timeGapInJvmZone1.atZone(ZoneOffset.UTC)), (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, DataType.timestampWithTimeZoneDataType((int)3).toLiteral((Object)this.timeGapInJvmZone1.atZone(ZoneOffset.UTC))).addRoundTrip("TIMESTAMP(3) WITH TIME ZONE", OracleDataTypes.oracleTimestamp3TimeZoneDataType().toLiteral((Object)this.timeGapInJvmZone1.atZone(this.kathmandu)), (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, DataType.timestampWithTimeZoneDataType((int)3).toLiteral((Object)this.timeGapInJvmZone1.atZone(this.kathmandu))).addRoundTrip("TIMESTAMP(3) WITH TIME ZONE", OracleDataTypes.oracleTimestamp3TimeZoneDataType().toLiteral((Object)this.timeGapInJvmZone2.atZone(ZoneOffset.UTC)), (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, DataType.timestampWithTimeZoneDataType((int)3).toLiteral((Object)this.timeGapInJvmZone2.atZone(ZoneOffset.UTC))).addRoundTrip("TIMESTAMP(3) WITH TIME ZONE", OracleDataTypes.oracleTimestamp3TimeZoneDataType().toLiteral((Object)this.timeGapInJvmZone2.atZone(this.kathmandu)), (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, DataType.timestampWithTimeZoneDataType((int)3).toLiteral((Object)this.timeGapInJvmZone2.atZone(this.kathmandu))).addRoundTrip("TIMESTAMP(3) WITH TIME ZONE", OracleDataTypes.oracleTimestamp3TimeZoneDataType().toLiteral((Object)this.timeGapInVilnius.atZone(this.kathmandu)), (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, DataType.timestampWithTimeZoneDataType((int)3).toLiteral((Object)this.timeGapInVilnius.atZone(this.kathmandu))).addRoundTrip("TIMESTAMP(3) WITH TIME ZONE", OracleDataTypes.oracleTimestamp3TimeZoneDataType().toLiteral((Object)this.timeGapInKathmandu.atZone(this.vilnius)), (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, DataType.timestampWithTimeZoneDataType((int)3).toLiteral((Object)this.timeGapInKathmandu.atZone(this.vilnius))).execute(this.getQueryRunner(), this.oracleCreateAndInsert("timestamp_tz"));
    }

    @Test
    public void testUnsupportedBasicType() {
        this.testUnsupportedOracleType("BFILE");
    }

    @Test
    public void testUnsupportedNumberScale() {
        this.testUnsupportedOracleType("number(20, -20)");
        this.testUnsupportedOracleType("number(38, -84)");
        this.testUnsupportedOracleType("NUMBER(2, 4)");
    }

    private void testUnsupportedOracleType(String dataTypeName) {
        try (TestTable table = new TestTable(this.getOracleSqlExecutor(), "unsupported_type", String.format("(unsupported_type %s)", dataTypeName));){
            this.assertQueryFails("SELECT * FROM " + table.getName(), NO_SUPPORTED_COLUMNS);
        }
    }

    private DataSetup oracleCreateAndInsert(String tableNamePrefix) {
        return new CreateAndInsertDataSetup(this.getOracleSqlExecutor(), tableNamePrefix);
    }

    protected abstract SqlExecutor getOracleSqlExecutor();

    private static void checkIsGap(ZoneId zone, LocalDateTime dateTime) {
        Verify.verify((boolean)AbstractTestOracleTypeMapping.isGap(zone, dateTime), (String)"Expected %s to be a gap in %s", (Object)dateTime, (Object)zone);
    }

    private static boolean isGap(ZoneId zone, LocalDateTime dateTime) {
        return zone.getRules().getValidOffsets(dateTime).isEmpty();
    }

    private static void checkIsDoubled(ZoneId zone, LocalDateTime dateTime) {
        Verify.verify((zone.getRules().getValidOffsets(dateTime).size() == 2 ? 1 : 0) != 0, (String)"Expected %s to be doubled in %s", (Object)dateTime, (Object)zone);
    }

    private TestTable oracleTable(String tableName, String schema, String data) {
        return new TestTable(this.getOracleSqlExecutor(), tableName, String.format("(%s)", schema), (List)ImmutableList.of((Object)data));
    }
}

