/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.oracle;

import com.google.common.collect.ImmutableList;
import io.trino.Session;
import io.trino.execution.QueryInfo;
import io.trino.plugin.jdbc.BaseJdbcConnectorTest;
import io.trino.plugin.oracle.TestSynonym;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.AbstractTestDistributedQueries;
import io.trino.testing.MaterializedResult;
import io.trino.testing.QueryRunner;
import io.trino.testing.ResultWithQueryId;
import io.trino.testing.TestingConnectorBehavior;
import io.trino.testing.assertions.Assert;
import io.trino.testing.sql.TestTable;
import io.trino.testing.sql.TestView;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public abstract class BaseOracleConnectorTest
extends BaseJdbcConnectorTest {
    protected boolean hasBehavior(TestingConnectorBehavior connectorBehavior) {
        switch (connectorBehavior) {
            case SUPPORTS_LIMIT_PUSHDOWN: {
                return false;
            }
            case SUPPORTS_TOPN_PUSHDOWN: {
                return false;
            }
            case SUPPORTS_AGGREGATION_PUSHDOWN: {
                return false;
            }
            case SUPPORTS_JOIN_PUSHDOWN: {
                return true;
            }
            case SUPPORTS_JOIN_PUSHDOWN_WITH_DISTINCT_FROM: {
                return false;
            }
            case SUPPORTS_COMMENT_ON_TABLE: {
                return false;
            }
            case SUPPORTS_ARRAY: {
                return false;
            }
            case SUPPORTS_CREATE_SCHEMA: {
                return false;
            }
            case SUPPORTS_RENAME_TABLE_ACROSS_SCHEMAS: {
                return false;
            }
        }
        return super.hasBehavior(connectorBehavior);
    }

    public void testCreateSchema() {
        this.assertQueryFails("CREATE SCHEMA test_schema_create", "This connector does not support creating schemas");
    }

    protected String dataMappingTableName(String trinoTypeName) {
        return "tmp_trino_" + System.nanoTime();
    }

    protected Optional<AbstractTestDistributedQueries.DataMappingTestSetup> filterDataMappingSmokeTestData(AbstractTestDistributedQueries.DataMappingTestSetup dataMappingTestSetup) {
        String typeName = dataMappingTestSetup.getTrinoTypeName();
        if (typeName.equals("time")) {
            return Optional.empty();
        }
        if (typeName.equals("boolean")) {
            return Optional.empty();
        }
        return Optional.of(dataMappingTestSetup);
    }

    protected TestTable createTableWithDefaultColumns() {
        return new TestTable(this.onRemoteDatabase(), "test_default_cols", "(col_required decimal(20,0) NOT NULL,col_nullable decimal(20,0),col_default decimal(20,0) DEFAULT 43,col_nonnull_default decimal(20,0) DEFAULT 42 NOT NULL ,col_required2 decimal(20,0) NOT NULL)");
    }

    protected TestTable createTableWithUnsupportedColumn() {
        return new TestTable(this.onRemoteDatabase(), "test_unsupported_col", "(one NUMBER(19), two NUMBER, three VARCHAR2(10 CHAR))");
    }

    @Test
    public void testSymbolAliasing() {
        String tableName = "symbol_aliasing" + System.currentTimeMillis();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT 1 foo_1, 2 foo_2_4", 1L);
        this.assertQuery("SELECT foo_1, foo_2_4 FROM " + tableName, "SELECT 1, 2");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testRenameColumn() {
        String tableName = "test_renamecol_" + System.currentTimeMillis();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT 'some value' x", 1L);
        this.assertUpdate("ALTER TABLE " + tableName + " RENAME COLUMN x TO y");
        this.assertQuery("SELECT y FROM " + tableName, "VALUES 'some value'");
        this.assertUpdate("ALTER TABLE " + tableName + " RENAME COLUMN y TO Z");
        this.assertQuery("SELECT z FROM " + tableName, "VALUES 'some value'");
        this.assertQuery("SELECT * FROM " + tableName, "VALUES 'some value'");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testWrittenStats() {
        String tableName = "written_stats_" + System.currentTimeMillis();
        String sql = "CREATE TABLE " + tableName + " AS SELECT * FROM nation";
        ResultWithQueryId resultResultWithQueryId = this.getDistributedQueryRunner().executeWithQueryId(this.getSession(), sql);
        QueryInfo queryInfo = this.getDistributedQueryRunner().getCoordinator().getQueryManager().getFullQueryInfo(resultResultWithQueryId.getQueryId());
        Assert.assertEquals((long)queryInfo.getQueryStats().getOutputPositions(), (long)1L);
        Assert.assertEquals((long)queryInfo.getQueryStats().getWrittenPositions(), (long)25L);
        org.testng.Assert.assertTrue((queryInfo.getQueryStats().getLogicalWrittenDataSize().toBytes() > 0L ? 1 : 0) != 0);
        sql = "INSERT INTO " + tableName + " SELECT * FROM nation LIMIT 10";
        resultResultWithQueryId = this.getDistributedQueryRunner().executeWithQueryId(this.getSession(), sql);
        queryInfo = this.getDistributedQueryRunner().getCoordinator().getQueryManager().getFullQueryInfo(resultResultWithQueryId.getQueryId());
        Assert.assertEquals((long)queryInfo.getQueryStats().getOutputPositions(), (long)1L);
        Assert.assertEquals((long)queryInfo.getQueryStats().getWrittenPositions(), (long)10L);
        org.testng.Assert.assertTrue((queryInfo.getQueryStats().getLogicalWrittenDataSize().toBytes() > 0L ? 1 : 0) != 0);
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testShowColumns() {
        MaterializedResult actual = this.computeActual("SHOW COLUMNS FROM orders");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{"orderkey", "decimal(19,0)", "", ""}).row(new Object[]{"custkey", "decimal(19,0)", "", ""}).row(new Object[]{"orderstatus", "varchar(1)", "", ""}).row(new Object[]{"totalprice", "double", "", ""}).row(new Object[]{"orderdate", "timestamp(3)", "", ""}).row(new Object[]{"orderpriority", "varchar(15)", "", ""}).row(new Object[]{"clerk", "varchar(15)", "", ""}).row(new Object[]{"shippriority", "decimal(10,0)", "", ""}).row(new Object[]{"comment", "varchar(79)", "", ""}).build();
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
    }

    @Test
    public void testCommentColumn() {
        String tableName = "test_comment_column_" + TestTable.randomTableSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + "(a integer)");
        this.assertUpdate("COMMENT ON COLUMN " + tableName + ".a IS 'new comment'");
        Assertions.assertThat((String)((String)this.computeActual("SHOW CREATE TABLE " + tableName).getOnlyValue())).doesNotContain(new CharSequence[]{"COMMENT 'new comment'"});
    }

    public void testInformationSchemaFiltering() {
        this.assertQuery("SELECT table_name FROM information_schema.tables WHERE table_name = 'orders' LIMIT 1", "SELECT 'orders' table_name");
        this.assertQuery("SELECT table_name FROM information_schema.columns WHERE data_type = 'decimal(19,0)' AND table_name = 'customer' AND column_name = 'custkey' LIMIT 1", "SELECT 'customer' table_name");
    }

    protected boolean isColumnNameRejected(Exception exception, String columnName, boolean delimited) {
        return columnName.equals("a\"quote") && exception.getMessage().contains("ORA-03001: unimplemented feature");
    }

    @Test
    public void testDescribeTable() {
        MaterializedResult expectedColumns = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{"orderkey", "decimal(19,0)", "", ""}).row(new Object[]{"custkey", "decimal(19,0)", "", ""}).row(new Object[]{"orderstatus", "varchar(1)", "", ""}).row(new Object[]{"totalprice", "double", "", ""}).row(new Object[]{"orderdate", "timestamp(3)", "", ""}).row(new Object[]{"orderpriority", "varchar(15)", "", ""}).row(new Object[]{"clerk", "varchar(15)", "", ""}).row(new Object[]{"shippriority", "decimal(10,0)", "", ""}).row(new Object[]{"comment", "varchar(79)", "", ""}).build();
        MaterializedResult actualColumns = this.computeActual("DESCRIBE orders");
        Assert.assertEquals((Iterable)actualColumns, (Iterable)expectedColumns);
    }

    @Test
    public void testShowCreateTable() {
        Assertions.assertThat((String)((String)this.computeActual("SHOW CREATE TABLE orders").getOnlyValue())).matches((CharSequence)"CREATE TABLE \\w+\\.\\w+\\.orders \\Q(\n   orderkey decimal(19, 0),\n   custkey decimal(19, 0),\n   orderstatus varchar(1),\n   totalprice double,\n   orderdate timestamp(3),\n   orderpriority varchar(15),\n   clerk varchar(15),\n   shippriority decimal(10, 0),\n   comment varchar(79)\n)");
    }

    public void testCharVarcharComparison() {
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_char_varchar", "(k, v) AS VALUES   (-1, CAST(NULL AS char(3))),    (3, CAST('x  ' AS char(3)))");){
            this.assertQuery("SELECT k, v FROM " + table.getName() + " WHERE v = CAST('x ' AS varchar(2))", "VALUES (3, 'x  ')");
            this.assertQuery("SELECT k, v FROM " + table.getName() + " WHERE v = CAST('x ' AS varchar(4))", "VALUES (3, 'x  ')");
        }
    }

    public void testVarcharCharComparison() {
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_varchar_char", "(k, v) AS VALUES   (-1, CAST(NULL AS varchar(3))),    (0, CAST('' AS varchar(3))),   (1, CAST(' ' AS varchar(3))),    (2, CAST('  ' AS varchar(3))),    (3, CAST('   ' AS varchar(3))),   (4, CAST('x' AS varchar(3))),   (5, CAST('x ' AS varchar(3))),   (6, CAST('x  ' AS varchar(3)))");){
            this.assertQuery("SELECT k, v FROM " + table.getName() + " WHERE v = CAST('  ' AS char(2))", "VALUES (1, ' '), (2, '  '), (3, '   ')");
            this.assertQuery("SELECT k, v FROM " + table.getName() + " WHERE v = CAST('x ' AS char(2))", "VALUES (4, 'x'), (5, 'x '), (6, 'x  ')");
        }
    }

    public void testAggregationWithUnsupportedResultType() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT array_agg(nationkey) FROM nation"))).skipResultsCorrectnessCheckForPushdown().isNotFullyPushedDown(new Class[]{AggregationNode.class});
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT histogram(regionkey) FROM nation"))).isNotFullyPushedDown(new Class[]{AggregationNode.class});
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT multimap_agg(regionkey, nationkey) FROM nation"))).isNotFullyPushedDown(new Class[]{AggregationNode.class});
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT approx_set(nationkey) FROM nation"))).isNotFullyPushedDown(new Class[]{AggregationNode.class, ProjectNode.class});
    }

    @Test
    public void testDropTable() {
        String tableName = "test_drop" + TestTable.randomTableSuffix();
        this.assertUpdate(String.format("CREATE TABLE %s AS SELECT 1 test_drop", tableName), 1L);
        org.testng.Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
        this.assertUpdate("DROP TABLE " + tableName);
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
    }

    @Test
    public void testViews() {
        try (TestView view = new TestView(this.onRemoteDatabase(), this.getUser() + ".test_view", "SELECT 'O' as status FROM dual");){
            this.assertQuery("SELECT status FROM " + view.getName(), "SELECT 'O'");
        }
    }

    @Test
    public void testSynonyms() {
        try (TestSynonym synonym = new TestSynonym(this.onRemoteDatabase(), this.getUser() + ".test_synonym", "FOR ORDERS");){
            this.assertQueryFails("SELECT orderkey FROM " + synonym.getName(), "line 1:22: Table 'oracle.*' does not exist");
        }
    }

    @Test
    public void testPredicatePushdown() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT regionkey, nationkey, name FROM nation WHERE name = 'ROMANIA'"))).matches("VALUES (CAST(3 AS DECIMAL(19,0)), CAST(19 AS DECIMAL(19,0)), CAST('ROMANIA' AS varchar(25)))").isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT regionkey, nationkey, name FROM nation WHERE name BETWEEN 'POLAND' AND 'RPA'"))).matches("VALUES (CAST(3 AS DECIMAL(19,0)), CAST(19 AS DECIMAL(19,0)), CAST('ROMANIA' AS varchar(25)))").isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT regionkey, nationkey, name FROM nation WHERE name = 'romania'"))).returnsEmptyResult().isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT orderkey FROM orders WHERE orderdate = DATE '1992-09-29'"))).matches("VALUES CAST(1250 AS DECIMAL(19,0)), 34406, 38436, 57570").isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM (SELECT regionkey, sum(nationkey) FROM nation GROUP BY regionkey) WHERE regionkey = 3"))).matches("VALUES (CAST(3 AS decimal(19,0)), CAST(77 AS decimal(38,0)))").isNotFullyPushedDown(new Class[]{AggregationNode.class, ProjectNode.class});
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT regionkey, sum(nationkey) FROM nation GROUP BY regionkey HAVING sum(nationkey) = 77"))).matches("VALUES (CAST(3 AS decimal(19,0)), CAST(77 AS decimal(38,0)))").isNotFullyPushedDown(new Class[]{AggregationNode.class, ProjectNode.class});
    }

    @Test
    public void testPredicatePushdownForNumerics() {
        this.predicatePushdownTest("DECIMAL(9, 3)", "123.321", "<=", "124");
        this.predicatePushdownTest("DECIMAL(9, 3)", "123.321", "<=", "123.321");
        this.predicatePushdownTest("DECIMAL(9, 3)", "123.321", "=", "123.321");
        this.predicatePushdownTest("DECIMAL(30, 10)", "123456789.987654321", "<=", "123456790");
        this.predicatePushdownTest("DECIMAL(30, 10)", "123456789.987654321", "<=", "123456789.987654321");
        this.predicatePushdownTest("DECIMAL(30, 10)", "123456789.987654321", "=", "123456789.987654321");
        this.predicatePushdownTest("FLOAT(63)", "123456789.987654321", "<=", "CAST(123456789.99 AS REAL)");
        this.predicatePushdownTest("FLOAT(63)", "123456789.987654321", "<=", "CAST(123456789.99 AS DOUBLE)");
        this.predicatePushdownTest("FLOAT(126)", "123456789.987654321", "<=", "CAST(123456789.99 AS REAL)");
        this.predicatePushdownTest("FLOAT(126)", "123456789.987654321", "<=", "CAST(123456789.99 AS DOUBLE)");
        this.predicatePushdownTest("BINARY_FLOAT", "5.0f", "=", "CAST(5.0 AS REAL)");
        this.predicatePushdownTest("BINARY_DOUBLE", "20.233", "=", "CAST(20.233 AS DOUBLE)");
        this.predicatePushdownTest("NUMBER(5,3)", "5.0", "=", "CAST(5.0 AS DECIMAL(5,3))");
    }

    @Test
    public void testPredicatePushdownForChars() {
        this.predicatePushdownTest("CHAR(1)", "'0'", "=", "'0'");
        this.predicatePushdownTest("CHAR(1)", "'0'", "<=", "'0'");
        this.predicatePushdownTest("CHAR(5)", "'0'", "=", "CHAR'0'");
        this.predicatePushdownTest("CHAR(7)", "'my_char'", "=", "CAST('my_char' AS CHAR(7))");
        this.predicatePushdownTest("NCHAR(7)", "'my_char'", "=", "CAST('my_char' AS CHAR(7))");
        this.predicatePushdownTest("VARCHAR2(7)", "'my_char'", "=", "CAST('my_char' AS VARCHAR(7))");
        this.predicatePushdownTest("NVARCHAR2(7)", "'my_char'", "=", "CAST('my_char' AS VARCHAR(7))");
        try (TestTable table = new TestTable(this.onRemoteDatabase(), this.getUser() + ".test_pdown_", "(c_clob CLOB, c_nclob NCLOB)", (List)ImmutableList.of((Object)"'my_clob', 'my_nclob'"));){
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT c_clob FROM %s WHERE c_clob = VARCHAR 'my_clob'", table.getName())))).isNotFullyPushedDown(new Class[]{FilterNode.class});
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT c_nclob FROM %s WHERE c_nclob = VARCHAR 'my_nclob'", table.getName())))).isNotFullyPushedDown(new Class[]{FilterNode.class});
        }
    }

    @Test
    public void testTooLargeDomainCompactionThreshold() {
        this.assertQueryFails(Session.builder((Session)this.getSession()).setCatalogSessionProperty("oracle", "domain_compaction_threshold", "10000").build(), "SELECT * from nation", "Domain compaction threshold \\(10000\\) cannot exceed 1000");
    }

    private void predicatePushdownTest(String oracleType, String oracleLiteral, String operator, String filterLiteral) {
        String tableName = ("test_pdown_" + oracleType.replaceAll("[^a-zA-Z0-9]", "")).replaceFirst("^(.{18}).*", "$1__");
        try (TestTable table = new TestTable(this.onRemoteDatabase(), this.getUser() + "." + tableName, String.format("(c %s)", oracleType));){
            this.onRemoteDatabase().execute(String.format("INSERT INTO %s VALUES (%s)", table.getName(), oracleLiteral));
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT * FROM %s WHERE c %s %s", table.getName(), operator, filterLiteral)))).isFullyPushedDown();
        }
    }

    protected String getUser() {
        return "trino_test";
    }
}

