/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.oracle;

import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.testing.datatype.DataType;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.function.Function;

public final class OracleDataTypes {
    private OracleDataTypes() {
    }

    public static DataType<ZonedDateTime> oracleTimestamp3TimeZoneDataType() {
        return OracleDataTypes.dataType("TIMESTAMP(3) WITH TIME ZONE", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, zonedDateTime -> {
            String zoneId = zonedDateTime.getZone().getId();
            if (zoneId.equals("Z")) {
                zoneId = "UTC";
            }
            return String.format("from_tz(TIMESTAMP '%s', '%s')", DateTimeFormatter.ofPattern("uuuu-MM-dd HH:mm:ss.SSSSSSSSS").format(zonedDateTime.toLocalDateTime()), zoneId);
        }, OracleDataTypes::normalizeForOracleStorage);
    }

    private static ZonedDateTime normalizeForOracleStorage(ZonedDateTime zonedDateTime) {
        String zoneId = zonedDateTime.getZone().getId();
        if (zoneId.equals("Z")) {
            return zonedDateTime.withZoneSameInstant(ZoneId.of("UTC"));
        }
        return zonedDateTime;
    }

    @Deprecated
    private static <T> DataType<T> dataType(String insertType, Type trinoResultType, Function<T, String> toLiteral, Function<T, ?> toTrinoQueryResult) {
        return DataType.dataType((String)insertType, (Type)trinoResultType, toLiteral, toTrinoQueryResult);
    }
}

