/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.oracle;

import com.google.common.collect.ImmutableMap;
import io.airlift.log.Logger;
import io.airlift.log.Logging;
import io.airlift.testing.Closeables;
import io.trino.Session;
import io.trino.plugin.oracle.OraclePlugin;
import io.trino.plugin.oracle.TestingOracleServer;
import io.trino.plugin.tpch.TpchPlugin;
import io.trino.spi.Plugin;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryAssertions;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingSession;
import io.trino.tpch.TpchTable;
import java.util.Map;

public final class OracleQueryRunner {
    private OracleQueryRunner() {
    }

    public static DistributedQueryRunner createOracleQueryRunner(TestingOracleServer server, Map<String, String> extraProperties, Map<String, String> connectorProperties, Iterable<TpchTable<?>> tables) throws Exception {
        DistributedQueryRunner queryRunner = null;
        try {
            queryRunner = DistributedQueryRunner.builder((Session)OracleQueryRunner.createSession()).setExtraProperties(extraProperties).build();
            queryRunner.installPlugin((Plugin)new TpchPlugin());
            queryRunner.createCatalog("tpch", "tpch");
            queryRunner.installPlugin((Plugin)new OraclePlugin());
            queryRunner.createCatalog("oracle", "oracle", connectorProperties);
            QueryAssertions.copyTpchTables((QueryRunner)queryRunner, (String)"tpch", (String)"tiny", (Session)OracleQueryRunner.createSession(), tables);
            return queryRunner;
        }
        catch (Throwable e) {
            Closeables.closeAllSuppress((Throwable)e, (AutoCloseable[])new AutoCloseable[]{queryRunner, server});
            throw e;
        }
    }

    public static Session createSession() {
        return TestingSession.testSessionBuilder().setCatalog("oracle").setSchema("trino_test").build();
    }

    public static Map<String, String> connectionProperties(TestingOracleServer server) {
        return ImmutableMap.builder().put((Object)"connection-url", (Object)server.getJdbcUrl()).put((Object)"connection-user", (Object)"trino_test").put((Object)"connection-password", (Object)"trino_test_password").put((Object)"allow-drop-table", (Object)"true").build();
    }

    public static void main(String[] args) throws Exception {
        Logging.initialize();
        TestingOracleServer server = new TestingOracleServer();
        DistributedQueryRunner queryRunner = OracleQueryRunner.createOracleQueryRunner(server, (Map<String, String>)ImmutableMap.of((Object)"http-server.http.port", (Object)"8080"), (Map<String, String>)ImmutableMap.builder().put((Object)"connection-url", (Object)server.getJdbcUrl()).put((Object)"connection-user", (Object)"trino_test").put((Object)"connection-password", (Object)"trino_test_password").put((Object)"allow-drop-table", (Object)"true").put((Object)"oracle.connection-pool.enabled", (Object)"false").put((Object)"oracle.remarks-reporting.enabled", (Object)"false").build(), TpchTable.getTables());
        Logger log = Logger.get(OracleQueryRunner.class);
        log.info("======== SERVER STARTED ========");
        log.info("\n====\n%s\n====", new Object[]{queryRunner.getCoordinator().getBaseUrl()});
    }
}

