/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.oracle;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.plugin.oracle.OracleQueryRunner;
import io.trino.plugin.oracle.TestingOracleServer;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.QueryRunner;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestOracleCaseInsensitiveMapping
extends AbstractTestQueryFramework {
    private TestingOracleServer oracleServer;

    protected QueryRunner createQueryRunner() throws Exception {
        this.oracleServer = (TestingOracleServer)this.closeAfterClass(new TestingOracleServer());
        return OracleQueryRunner.createOracleQueryRunner(this.oracleServer, (Map<String, String>)ImmutableMap.of(), (Map<String, String>)ImmutableMap.builder().putAll(OracleQueryRunner.connectionProperties(this.oracleServer)).put((Object)"case-insensitive-name-matching", (Object)"true").build(), ImmutableList.of());
    }

    @Test
    public void testNonLowerCaseSchemaName() throws Exception {
        try (AutoCloseable ignore1 = this.withSchema("\"NonLowerCaseSchema\"");
             AutoCloseable ignore2 = this.withTable("\"NonLowerCaseSchema\".lower_case_name", "(c varchar(5))");
             AutoCloseable ignore3 = this.withTable("\"NonLowerCaseSchema\".\"Mixed_Case_Name\"", "(c varchar(5))");
             AutoCloseable ignore4 = this.withTable("\"NonLowerCaseSchema\".\"UPPER_CASE_NAME\"", "(c varchar(5))");){
            Assertions.assertThat((Stream)this.computeActual("SHOW SCHEMAS").getOnlyColumn()).contains(new Object[]{"nonlowercaseschema"});
            this.assertQuery("SHOW SCHEMAS LIKE 'nonlowerc%'", "VALUES 'nonlowercaseschema'");
            this.assertQuery("SELECT schema_name FROM information_schema.schemata WHERE schema_name LIKE '%nonlowercaseschema'", "VALUES 'nonlowercaseschema'");
            this.assertQuery("SHOW TABLES FROM nonlowercaseschema", "VALUES 'lower_case_name', 'mixed_case_name', 'upper_case_name'");
            this.assertQuery("SELECT table_name FROM information_schema.tables WHERE table_schema = 'nonlowercaseschema'", "VALUES 'lower_case_name', 'mixed_case_name', 'upper_case_name'");
            this.assertQueryReturnsEmptyResult("SELECT * FROM nonlowercaseschema.lower_case_name");
        }
    }

    @Test
    public void testNonLowerCaseTableName() throws Exception {
        try (AutoCloseable ignore1 = this.withSchema("\"SomeSchema\"");
             AutoCloseable ignore2 = this.withTable("\"SomeSchema\".\"NonLowerCaseTable\"", "(\"lower_case_name\", \"Mixed_Case_Name\", \"UPPER_CASE_NAME\") AS SELECT 'a', 'b', 'c' FROM dual");){
            this.assertQuery("SELECT column_name FROM information_schema.columns WHERE table_schema = 'someschema' AND table_name = 'nonlowercasetable'", "VALUES 'lower_case_name', 'mixed_case_name', 'upper_case_name'");
            this.assertQuery("SELECT column_name FROM information_schema.columns WHERE table_name = 'nonlowercasetable'", "VALUES 'lower_case_name', 'mixed_case_name', 'upper_case_name'");
            Assert.assertEquals((Set)((Set)this.computeActual("SHOW COLUMNS FROM someschema.nonlowercasetable").getMaterializedRows().stream().map(row -> row.getField(0)).collect(ImmutableSet.toImmutableSet())), (Set)ImmutableSet.of((Object)"lower_case_name", (Object)"mixed_case_name", (Object)"upper_case_name"));
            this.assertQuery("SELECT lower_case_name FROM someschema.nonlowercasetable", "VALUES 'a'");
            this.assertQuery("SELECT mixed_case_name FROM someschema.nonlowercasetable", "VALUES 'b'");
            this.assertQuery("SELECT upper_case_name FROM someschema.nonlowercasetable", "VALUES 'c'");
            this.assertQuery("SELECT upper_case_name FROM SomeSchema.NonLowerCaseTable", "VALUES 'c'");
            this.assertQuery("SELECT upper_case_name FROM \"SomeSchema\".\"NonLowerCaseTable\"", "VALUES 'c'");
            this.assertUpdate("INSERT INTO someschema.nonlowercasetable (lower_case_name) VALUES ('l')", 1L);
            this.assertUpdate("INSERT INTO someschema.nonlowercasetable (mixed_case_name) VALUES ('m')", 1L);
            this.assertUpdate("INSERT INTO someschema.nonlowercasetable (upper_case_name) VALUES ('u')", 1L);
            this.assertQuery("SELECT * FROM someschema.nonlowercasetable", "VALUES ('a', 'b', 'c'),('l', NULL, NULL),(NULL, 'm', NULL),(NULL, NULL, 'u')");
        }
    }

    @Test
    public void testSchemaNameClash() throws Exception {
        String[] nameVariants = new String[]{"\"casesensitivename\"", "\"CaseSensitiveName\"", "\"CASESENSITIVENAME\""};
        Assertions.assertThat((Iterable)((Iterable)Stream.of(nameVariants).map(name -> name.replace("\"", "").toLowerCase(Locale.ENGLISH)).collect(ImmutableSet.toImmutableSet()))).hasSize(1);
        for (int i = 0; i < nameVariants.length; ++i) {
            for (int j = i + 1; j < nameVariants.length; ++j) {
                String schemaName = nameVariants[i];
                String otherSchemaName = nameVariants[j];
                try (AutoCloseable ignore1 = this.withSchema(schemaName);
                     AutoCloseable ignore2 = this.withSchema(otherSchemaName);
                     AutoCloseable ignore3 = this.withTable(schemaName + ".some_table_name", "(c varchar(5))");){
                    Assertions.assertThat(this.computeActual("SHOW SCHEMAS").getOnlyColumn().filter("casesensitivename"::equals)).hasSize(1);
                    this.assertQueryFails("SHOW TABLES FROM casesensitivename", "Failed to find remote schema name: Ambiguous name: casesensitivename");
                    this.assertQueryFails("SELECT * FROM casesensitivename.some_table_name", "Failed to find remote schema name: Ambiguous name: casesensitivename");
                    continue;
                }
            }
        }
    }

    @Test
    public void testTableNameClash() throws Exception {
        String[] nameVariants = new String[]{"\"casesensitivename\"", "\"CaseSensitiveName\"", "\"CASESENSITIVENAME\""};
        Assertions.assertThat((Iterable)((Iterable)Stream.of(nameVariants).map(name -> name.replace("\"", "").toLowerCase(Locale.ENGLISH)).collect(ImmutableSet.toImmutableSet()))).hasSize(1);
        for (int i = 0; i < nameVariants.length; ++i) {
            for (int j = i + 1; j < nameVariants.length; ++j) {
                try (AutoCloseable ignore1 = this.withTable("trino_test." + nameVariants[i], "(c varchar(5))");
                     AutoCloseable ignore2 = this.withTable("trino_test." + nameVariants[j], "(d varchar(5))");){
                    Assertions.assertThat(this.computeActual("SHOW TABLES").getOnlyColumn().filter("casesensitivename"::equals)).hasSize(1);
                    this.assertQueryFails("SHOW COLUMNS FROM casesensitivename", "Failed to find remote table name: Ambiguous name: casesensitivename");
                    this.assertQueryFails("SELECT * FROM casesensitivename", "Failed to find remote table name: Ambiguous name: casesensitivename");
                    continue;
                }
            }
        }
    }

    private AutoCloseable withSchema(String schemaName) {
        this.oracleServer.execute(String.format("CREATE USER %s IDENTIFIED BY SCM", schemaName));
        this.oracleServer.execute(String.format("ALTER USER %s QUOTA 100M ON SYSTEM", schemaName));
        return () -> this.oracleServer.execute("DROP USER " + schemaName);
    }

    @Deprecated
    private AutoCloseable withTable(String tableName, String tableDefinition) {
        this.oracleServer.execute(String.format("CREATE TABLE %s %s", tableName, tableDefinition));
        return () -> this.oracleServer.execute(String.format("DROP TABLE %s", tableName));
    }
}

