/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.oracle;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.plugin.oracle.AbstractTestOracleTypeMapping;
import io.trino.plugin.oracle.OracleQueryRunner;
import io.trino.plugin.oracle.TestingOracleServer;
import io.trino.testing.QueryRunner;
import io.trino.testing.sql.SqlExecutor;
import java.util.Map;
import org.testng.annotations.AfterClass;

public class TestOracleTypeMapping
extends AbstractTestOracleTypeMapping {
    private TestingOracleServer oracleServer;

    protected QueryRunner createQueryRunner() throws Exception {
        this.oracleServer = new TestingOracleServer();
        return OracleQueryRunner.createOracleQueryRunner(this.oracleServer, (Map<String, String>)ImmutableMap.of(), (Map<String, String>)ImmutableMap.builder().put((Object)"connection-url", (Object)this.oracleServer.getJdbcUrl()).put((Object)"connection-user", (Object)"trino_test").put((Object)"connection-password", (Object)"trino_test_password").put((Object)"allow-drop-table", (Object)"true").put((Object)"oracle.connection-pool.enabled", (Object)"false").put((Object)"oracle.remarks-reporting.enabled", (Object)"false").build(), ImmutableList.of());
    }

    @AfterClass(alwaysRun=true)
    public final void destroy() {
        if (this.oracleServer != null) {
            this.oracleServer.close();
        }
    }

    @Override
    protected SqlExecutor getOracleSqlExecutor() {
        return sql -> this.oracleServer.execute(sql);
    }
}

