/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.oracle;

import io.airlift.log.Logger;
import io.airlift.testing.Closeables;
import io.trino.plugin.jdbc.BaseJdbcConfig;
import io.trino.plugin.jdbc.ConnectionFactory;
import io.trino.plugin.jdbc.DriverConnectionFactory;
import io.trino.plugin.jdbc.RetryingConnectionFactory;
import io.trino.plugin.jdbc.credential.CredentialProvider;
import io.trino.plugin.jdbc.credential.StaticCredentialProvider;
import io.trino.testing.TestingConnectorSession;
import java.io.Closeable;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.temporal.ChronoUnit;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.RetryPolicy;
import oracle.jdbc.OracleDriver;
import org.testcontainers.containers.OracleContainer;
import org.testcontainers.utility.MountableFile;

public class TestingOracleServer
implements Closeable {
    private static final Logger log = Logger.get(TestingOracleServer.class);
    private static final RetryPolicy<Object> CONTAINER_RETRY_POLICY = new RetryPolicy().withBackoff(1L, 5L, ChronoUnit.SECONDS).withMaxAttempts(5).onRetry(event -> log.warn("Container initialization failed on attempt %s, will retry. Exception: %s", new Object[]{event.getAttemptCount(), event.getLastFailure().getMessage()}));
    private static final String TEST_TABLESPACE = "trino_test";
    public static final String TEST_USER = "trino_test";
    public static final String TEST_SCHEMA = "trino_test";
    public static final String TEST_PASS = "trino_test_password";
    private final TestingOracleContainer container = (TestingOracleContainer)((Object)Failsafe.with((Policy[])new RetryPolicy[]{CONTAINER_RETRY_POLICY}).get(this::createContainer));

    private TestingOracleContainer createContainer() {
        TestingOracleContainer container = new TestingOracleContainer("wnameless/oracle-xe-11g-r2");
        container.withCopyFileToContainer(MountableFile.forClasspathResource((String)"init.sql"), "/docker-entrypoint-initdb.d/init.sql");
        container.start();
        try {
            this.setUpDatabase(container);
        }
        catch (Exception e) {
            AutoCloseable[] autoCloseableArray = new AutoCloseable[1];
            autoCloseableArray[0] = () -> ((TestingOracleContainer)container).stop();
            Closeables.closeAllSuppress((Throwable)e, (AutoCloseable[])autoCloseableArray);
            throw new RuntimeException(e);
        }
        return container;
    }

    private void setUpDatabase(TestingOracleContainer container) throws Exception {
        Statement statement;
        try (Connection connection = this.getConnectionFactory(container).openConnection(TestingConnectorSession.SESSION);){
            statement = connection.createStatement();
            try {
                statement.execute("ALTER SYSTEM SET processes=1000 SCOPE=SPFILE");
                statement.execute("ALTER SYSTEM SET disk_asynch_io = FALSE SCOPE = SPFILE");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        container.execInContainer(new String[]{"/bin/bash", "/etc/init.d/oracle-xe", "restart"});
        container.waitUntilContainerStarted();
        connection = this.getConnectionFactory(container).openConnection(TestingConnectorSession.SESSION);
        try {
            statement = connection.createStatement();
            try {
                statement.execute(String.format("CREATE TABLESPACE %s DATAFILE 'test_db.dat' SIZE 100M ONLINE", "trino_test"));
                statement.execute(String.format("CREATE USER %s IDENTIFIED BY %s DEFAULT TABLESPACE %s", "trino_test", TEST_PASS, "trino_test"));
                statement.execute(String.format("GRANT UNLIMITED TABLESPACE TO %s", "trino_test"));
                statement.execute(String.format("GRANT ALL PRIVILEGES TO %s", "trino_test"));
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    public String getJdbcUrl() {
        return this.container.getJdbcUrl();
    }

    public void execute(String sql) {
        this.execute(sql, "trino_test", TEST_PASS);
    }

    public void execute(String sql, String user, String password) {
        try (Connection connection = this.getConnectionFactory(this.getJdbcUrl(), user, password).openConnection(TestingConnectorSession.SESSION);
             Statement statement = connection.createStatement();){
            statement.execute(sql);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private ConnectionFactory getConnectionFactory(TestingOracleContainer container) {
        return this.getConnectionFactory(container.getJdbcUrl(), container.getUsername(), container.getPassword());
    }

    private ConnectionFactory getConnectionFactory(String connectionUrl, String username, String password) {
        DriverConnectionFactory connectionFactory = new DriverConnectionFactory((Driver)new OracleDriver(), new BaseJdbcConfig().setConnectionUrl(connectionUrl), (CredentialProvider)StaticCredentialProvider.of((String)username, (String)password));
        return new RetryingConnectionFactory((ConnectionFactory)connectionFactory);
    }

    @Override
    public void close() {
        this.container.stop();
    }

    private static class TestingOracleContainer
    extends OracleContainer {
        public TestingOracleContainer(String dockerImageName) {
            super(dockerImageName);
        }

        protected void waitUntilContainerStarted() {
            super.waitUntilContainerStarted();
        }
    }
}

