/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcSplit;
import io.trino.plugin.jdbc.JdbcTableHandle;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.predicate.TupleDomain;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class DynamicFilteringJdbcSplitSource
implements ConnectorSplitSource {
    private final ConnectorSplitSource delegateSplitSource;
    private final DynamicFilter dynamicFilter;
    private final JdbcTableHandle tableHandle;

    DynamicFilteringJdbcSplitSource(ConnectorSplitSource delegateSplitSource, DynamicFilter dynamicFilter, JdbcTableHandle tableHandle) {
        this.delegateSplitSource = Objects.requireNonNull(delegateSplitSource, "delegateSplitSource is null");
        this.dynamicFilter = Objects.requireNonNull(dynamicFilter, "dynamicFilter is null");
        this.tableHandle = Objects.requireNonNull(tableHandle, "tableHandle is null");
    }

    public CompletableFuture<ConnectorSplitSource.ConnectorSplitBatch> getNextBatch(int maxSize) {
        if (!DynamicFilteringJdbcSplitSource.isEligibleForDynamicFilter(this.tableHandle)) {
            return this.delegateSplitSource.getNextBatch(maxSize);
        }
        return this.delegateSplitSource.getNextBatch(maxSize).thenApply(batch -> {
            TupleDomain dynamicFilterPredicate = this.dynamicFilter.getCurrentPredicate().transformKeys(JdbcColumnHandle.class::cast);
            return new ConnectorSplitSource.ConnectorSplitBatch((List)batch.getSplits().stream().map(split -> {
                JdbcSplit jdbcSplit = (JdbcSplit)split;
                Verify.verify((jdbcSplit.getClass() == JdbcSplit.class ? 1 : 0) != 0, (String)"Unexpected split type %s", (Object)jdbcSplit);
                return jdbcSplit.withDynamicFilter((TupleDomain<JdbcColumnHandle>)dynamicFilterPredicate);
            }).collect(ImmutableList.toImmutableList()), batch.isNoMoreSplits());
        });
    }

    public void close() {
        this.delegateSplitSource.close();
    }

    public boolean isFinished() {
        return this.delegateSplitSource.isFinished();
    }

    public static boolean isEligibleForDynamicFilter(JdbcTableHandle tableHandle) {
        return tableHandle.getLimit().isEmpty();
    }
}

