/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.units.DataSize;
import io.trino.plugin.jdbc.JoinPushdownStrategy;
import java.util.Optional;

public class JdbcJoinPushdownConfig {
    private JoinPushdownStrategy joinPushdownStrategy = JoinPushdownStrategy.AUTOMATIC;
    private Optional<DataSize> joinPushdownAutomaticMaxTableSize = Optional.empty();
    private double joinPushdownAutomaticMaxJoinToTablesRatio = 1.25;

    public JoinPushdownStrategy getJoinPushdownStrategy() {
        return this.joinPushdownStrategy;
    }

    @Config(value="join-pushdown.strategy")
    public JdbcJoinPushdownConfig setJoinPushdownStrategy(JoinPushdownStrategy joinPushdownStrategy) {
        this.joinPushdownStrategy = joinPushdownStrategy;
        return this;
    }

    public Optional<DataSize> getJoinPushdownAutomaticMaxTableSize() {
        return this.joinPushdownAutomaticMaxTableSize;
    }

    @Config(value="experimental.join-pushdown.automatic.max-table-size")
    @ConfigDescription(value="Maximum table size to be considered for join pushdown")
    public JdbcJoinPushdownConfig setJoinPushdownAutomaticMaxTableSize(DataSize joinPushdownAutomaticMaxTableSize) {
        this.joinPushdownAutomaticMaxTableSize = Optional.ofNullable(joinPushdownAutomaticMaxTableSize);
        return this;
    }

    public double getJoinPushdownAutomaticMaxJoinToTablesRatio() {
        return this.joinPushdownAutomaticMaxJoinToTablesRatio;
    }

    @Config(value="experimental.join-pushdown.automatic.max-join-to-tables-ratio")
    @ConfigDescription(value="If estimated join output size is greater than or equal to ratio * sum of table sizes, then join pushdown will not be performed")
    public JdbcJoinPushdownConfig setJoinPushdownAutomaticMaxJoinToTablesRatio(double joinPushdownAutomaticMaxJoinToTablesRatio) {
        this.joinPushdownAutomaticMaxJoinToTablesRatio = joinPushdownAutomaticMaxJoinToTablesRatio;
        return this;
    }
}

