/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.base.Throwables;
import dev.failsafe.Failsafe;
import dev.failsafe.FailsafeException;
import dev.failsafe.Policy;
import dev.failsafe.RetryPolicy;
import dev.failsafe.RetryPolicyBuilder;
import io.trino.plugin.jdbc.ConnectionFactory;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Objects;

public class RetryingConnectionFactory
implements ConnectionFactory {
    private static final RetryPolicy<Object> RETRY_POLICY = ((RetryPolicyBuilder)RetryPolicy.builder().withMaxDuration(Duration.of(30L, ChronoUnit.SECONDS)).withMaxAttempts(5).withBackoff(50L, 5000L, ChronoUnit.MILLIS, 4.0).handleIf(RetryingConnectionFactory::isSqlRecoverableException)).abortOn(TrinoException.class).build();
    private final ConnectionFactory delegate;

    public RetryingConnectionFactory(ConnectionFactory delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
    }

    @Override
    public Connection openConnection(ConnectorSession session) throws SQLException {
        try {
            return (Connection)Failsafe.with(RETRY_POLICY, (Policy[])new RetryPolicy[0]).get(() -> this.delegate.openConnection(session));
        }
        catch (FailsafeException ex) {
            if (ex.getCause() instanceof SQLException) {
                throw (SQLException)ex.getCause();
            }
            throw ex;
        }
    }

    @Override
    public void close() throws SQLException {
        this.delegate.close();
    }

    private static boolean isSqlRecoverableException(Throwable exception) {
        return Throwables.getCausalChain((Throwable)exception).stream().anyMatch(SQLRecoverableException.class::isInstance);
    }
}

