/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.trino.plugin.jdbc.ConnectionFactory;
import io.trino.plugin.jdbc.ForReusableConnectionFactory;
import io.trino.plugin.jdbc.JdbcQueryEventListener;
import io.trino.plugin.jdbc.LazyConnectionFactory;
import io.trino.plugin.jdbc.ReusableConnectionFactory;
import io.trino.spi.NodeManager;
import javax.inject.Singleton;

public final class ReusableConnectionFactoryModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        binder.bind(ConnectionFactory.class).annotatedWith(ForReusableConnectionFactory.class).to(LazyConnectionFactory.class).in(Scopes.SINGLETON);
        binder.bind(ReusableConnectionFactory.class).in(Scopes.SINGLETON);
        Multibinder.newSetBinder((Binder)binder, JdbcQueryEventListener.class).addBinding().to(Key.get(ReusableConnectionFactory.class)).in(Scopes.SINGLETON);
    }

    @Provides
    @Singleton
    public static ConnectionFactory getReusableConnectionFactory(NodeManager nodeManager, @ForReusableConnectionFactory ConnectionFactory delegate, ReusableConnectionFactory reusableConnectionFactory) {
        if (nodeManager.getCurrentNode().isCoordinator()) {
            return reusableConnectionFactory;
        }
        return delegate;
    }
}

