/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc.logging;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import io.trino.plugin.jdbc.JdbcErrorCode;
import io.trino.plugin.jdbc.logging.FormatBasedRemoteQueryModifierConfig;
import io.trino.plugin.jdbc.logging.RemoteQueryModifier;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public class FormatBasedRemoteQueryModifier
implements RemoteQueryModifier {
    private final String commentFormat;

    @Inject
    public FormatBasedRemoteQueryModifier(FormatBasedRemoteQueryModifierConfig config) {
        this.commentFormat = Objects.requireNonNull(config, "config is null").getFormat();
        Preconditions.checkState((!this.commentFormat.isBlank() ? 1 : 0) != 0, (Object)"comment format is blank");
    }

    @Override
    public String apply(ConnectorSession session, String query) {
        String message = this.commentFormat;
        for (PredefinedValue predefinedValue : PredefinedValue.values()) {
            if (!message.contains(predefinedValue.getPredefinedValueCode())) continue;
            message = message.replaceAll(predefinedValue.getMatchCase(), predefinedValue.value(session));
        }
        return query + " /*" + message + "*/";
    }

    static enum PredefinedValue {
        QUERY_ID(ConnectorSession::getQueryId),
        SOURCE(new SanitizedValuesProvider(session -> session.getSource().orElse(""), "$SOURCE")),
        USER(ConnectorSession::getUser),
        TRACE_TOKEN(new SanitizedValuesProvider(session -> session.getTraceToken().orElse(""), "$TRACE_TOKEN"));

        private final Function<ConnectorSession, String> valueProvider;

        private PredefinedValue(Function<ConnectorSession, String> valueProvider) {
            this.valueProvider = valueProvider;
        }

        String getMatchCase() {
            return "\\$" + this.name();
        }

        String getPredefinedValueCode() {
            return "$" + this.name();
        }

        String value(ConnectorSession session) {
            return this.valueProvider.apply(session);
        }
    }

    private static class SanitizedValuesProvider
    implements Function<ConnectorSession, String> {
        private static final Predicate<String> VALIDATION_MATCHER = Pattern.compile("^[\\w_-]*$").asMatchPredicate();
        private final Function<ConnectorSession, String> valueProvider;
        private final String name;

        private SanitizedValuesProvider(Function<ConnectorSession, String> valueProvider, String name) {
            this.valueProvider = Objects.requireNonNull(valueProvider, "valueProvider is null");
            this.name = Objects.requireNonNull(name, "name is null");
        }

        @Override
        public String apply(ConnectorSession session) {
            String value = this.valueProvider.apply(session);
            if (VALIDATION_MATCHER.test(value)) {
                return value;
            }
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_NON_TRANSIENT_ERROR, String.format("Passed value %s as %s does not meet security criteria. It can contain only letters, digits, underscores and hyphens", value, this.name));
        }
    }
}

