/*
 * Decompiled with CFR 0.152.
 */
package org.weakref.jmx;

import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.weakref.jmx.AnnotationUtils;
import org.weakref.jmx.ManagedAttribute;
import org.weakref.jmx.ReflectionUtils;
import org.weakref.jmx.internal.guava.collect.ImmutableMap;
import org.weakref.jmx.internal.guava.collect.ImmutableSet;

public class ManagedClass {
    private final WeakReference<Object> target;
    private final Map<String, ManagedClass> children;
    private final Map<String, ManagedAttribute> attributes;

    private ManagedClass(Object target, Map<String, ManagedClass> children, Map<String, ManagedAttribute> attributes) {
        this.target = new WeakReference<Object>(target);
        this.children = children;
        this.attributes = attributes;
    }

    public static ManagedClass fromExportedObject(Object target) {
        ImmutableMap.Builder<String, ManagedAttribute> attributes = ImmutableMap.builder();
        ImmutableMap.Builder<String, ManagedClass> children = ImmutableMap.builder();
        for (Map.Entry<Method, Method> entry : AnnotationUtils.findManagedMethods(target.getClass()).entrySet()) {
            Method concreteMethod = entry.getKey();
            Method annotatedMethod = entry.getValue();
            if (!ReflectionUtils.isGetter(concreteMethod)) continue;
            String attributeName = AnnotationUtils.getName(annotatedMethod);
            String description = AnnotationUtils.getDescription(annotatedMethod);
            if (attributeName == null || attributeName.equals("")) {
                attributeName = ReflectionUtils.getAttributeName(concreteMethod);
            }
            if (AnnotationUtils.isNested(annotatedMethod)) {
                try {
                    Object childTarget = concreteMethod.invoke(target, new Object[0]);
                    if (childTarget != null) {
                        children.put(attributeName, ManagedClass.fromExportedObject(childTarget));
                    }
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    // empty catch block
                }
            }
            attributes.put(attributeName, new ManagedAttribute(concreteMethod, attributeName, description, AnnotationUtils.isFlatten(concreteMethod)));
        }
        return new ManagedClass(target, children.build(), attributes.build());
    }

    public Class getTargetClass() {
        return this.getTarget().getClass();
    }

    public Object getTarget() {
        Object reference = this.target.get();
        if (reference == null) {
            throw new IllegalStateException("Reference to target is no longer present.");
        }
        return reference;
    }

    public Map<String, ManagedClass> getChildren() {
        if (this.target.get() == null) {
            return Collections.emptyMap();
        }
        return this.children;
    }

    public Set<String> getAttributeNames() {
        if (this.target.get() == null) {
            return Collections.emptySet();
        }
        return ImmutableSet.copyOf(this.attributes.keySet());
    }

    public Object invokeAttribute(String attributeName) throws InvocationTargetException, IllegalAccessException {
        return this.getManagedAttribute(attributeName).getMethod().invoke(this.getTarget(), new Object[0]);
    }

    public String getAttributeDescription(String attributeName) {
        return this.getManagedAttribute(attributeName).getDescription();
    }

    public boolean isAttributeFlatten(String attributeName) {
        return this.getManagedAttribute(attributeName).isFlatten();
    }

    private ManagedAttribute getManagedAttribute(String attributeName) {
        ManagedAttribute managedAttribute = this.attributes.get(attributeName);
        if (managedAttribute == null) {
            throw new IllegalArgumentException("No attribute with name " + attributeName + " is registered with this managed class");
        }
        return managedAttribute;
    }
}

