/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.discovery.client;

import com.google.common.collect.ImmutableList;
import io.airlift.discovery.client.HttpServiceSelector;
import io.airlift.discovery.client.ServiceDescriptor;
import io.airlift.discovery.client.ServiceSelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class HttpServiceSelectorImpl
implements HttpServiceSelector {
    private final ServiceSelector serviceSelector;

    public HttpServiceSelectorImpl(ServiceSelector serviceSelector) {
        Objects.requireNonNull(serviceSelector, "serviceSelector is null");
        this.serviceSelector = serviceSelector;
    }

    @Override
    public String getType() {
        return this.serviceSelector.getType();
    }

    @Override
    public String getPool() {
        return this.serviceSelector.getPool();
    }

    @Override
    public List<URI> selectHttpService() {
        ArrayList<ServiceDescriptor> serviceDescriptors = new ArrayList<ServiceDescriptor>(this.serviceSelector.selectAllServices());
        if (serviceDescriptors.isEmpty()) {
            return ImmutableList.of();
        }
        ArrayList<URI> httpsUri = new ArrayList<URI>();
        for (ServiceDescriptor serviceDescriptor : serviceDescriptors) {
            String https = serviceDescriptor.getProperties().get("https");
            if (https == null) continue;
            try {
                httpsUri.add(new URI(https));
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        ArrayList<URI> httpUri = new ArrayList<URI>();
        for (ServiceDescriptor serviceDescriptor : serviceDescriptors) {
            String http = serviceDescriptor.getProperties().get("http");
            if (http == null) continue;
            try {
                httpUri.add(new URI(http));
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        Collections.shuffle(httpsUri);
        Collections.shuffle(httpUri);
        return ImmutableList.builder().addAll(httpsUri).addAll(httpUri).build();
    }
}

