/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.extension;

import java.lang.reflect.Method;
import java.util.Optional;
import org.jdbi.v3.core.extension.ExtensionHandler;
import org.jdbi.v3.core.extension.ExtensionHandlerFactory;
import org.jdbi.v3.core.extension.UnableToCreateExtensionException;

final class DefaultMethodExtensionHandlerFactory
implements ExtensionHandlerFactory {
    static final ExtensionHandlerFactory INSTANCE = new DefaultMethodExtensionHandlerFactory();

    DefaultMethodExtensionHandlerFactory() {
    }

    @Override
    public boolean accepts(Class<?> extensionType, Method method) {
        return extensionType.isInterface() && method.isDefault();
    }

    @Override
    public Optional<ExtensionHandler> createExtensionHandler(Class<?> extensionType, Method method) {
        try {
            return Optional.of(ExtensionHandler.createForSpecialMethod(method));
        }
        catch (IllegalAccessException e) {
            throw new UnableToCreateExtensionException(e, "Default method handler for %s couldn't unreflect %s", extensionType, method);
        }
    }
}

