/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.extension;

import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.extension.ConfigCustomizerFactory;
import org.jdbi.v3.core.extension.ExtensionFactory;
import org.jdbi.v3.core.extension.ExtensionHandler;
import org.jdbi.v3.core.extension.ExtensionHandlerCustomizer;
import org.jdbi.v3.core.extension.ExtensionHandlerFactory;
import org.jdbi.v3.core.extension.ExtensionMetadata;
import org.jdbi.v3.core.extension.Extensions;
import org.jdbi.v3.core.extension.FilteringExtensionHandlerFactory;
import org.jdbi.v3.core.extension.HandleSupplier;
import org.jdbi.v3.core.internal.JdbiClassUtils;

final class ExtensionFactoryDelegate
implements ExtensionFactory {
    private final ExtensionFactory delegatedFactory;

    ExtensionFactoryDelegate(ExtensionFactory delegatedFactory) {
        this.delegatedFactory = delegatedFactory;
    }

    @Override
    public boolean accepts(Class<?> extensionType) {
        return this.delegatedFactory.accepts(extensionType);
    }

    ExtensionFactory getDelegatedFactory() {
        return this.delegatedFactory;
    }

    @Override
    public Collection<ExtensionHandlerFactory> getExtensionHandlerFactories(ConfigRegistry config) {
        return Collections.unmodifiableCollection(this.delegatedFactory.getExtensionHandlerFactories(config).stream().map(FilteringExtensionHandlerFactory::forDelegate).collect(Collectors.toList()));
    }

    @Override
    public Collection<ExtensionHandlerCustomizer> getExtensionHandlerCustomizers(ConfigRegistry config) {
        return this.delegatedFactory.getExtensionHandlerCustomizers(config);
    }

    @Override
    public Collection<ConfigCustomizerFactory> getConfigCustomizerFactories(ConfigRegistry config) {
        return this.delegatedFactory.getConfigCustomizerFactories(config);
    }

    @Override
    public void buildExtensionMetadata(ExtensionMetadata.Builder builder) {
        this.delegatedFactory.buildExtensionMetadata(builder);
    }

    @Override
    public Set<ExtensionFactory.FactoryFlag> getFactoryFlags() {
        return this.delegatedFactory.getFactoryFlags();
    }

    @Override
    public <E> E attach(Class<E> extensionType, HandleSupplier handleSupplier) {
        Set<ExtensionFactory.FactoryFlag> factoryFlags = this.getFactoryFlags();
        if (factoryFlags.contains((Object)ExtensionFactory.FactoryFlag.DONT_USE_PROXY)) {
            return this.delegatedFactory.attach(extensionType, handleSupplier);
        }
        if (extensionType == null || !extensionType.isInterface()) {
            throw new IllegalArgumentException(String.format("Can not attach %s as an extension with %s", extensionType, this.delegatedFactory.getClass().getSimpleName()));
        }
        ConfigRegistry config = handleSupplier.getConfig();
        Extensions extensions = config.get(Extensions.class);
        extensions.onCreateProxy();
        ExtensionMetadata extensionMetaData = extensions.findMetadata(extensionType, this.delegatedFactory);
        ConfigRegistry instanceConfig = extensionMetaData.createInstanceConfiguration(config);
        HashMap<Method, ExtensionMetadata.ExtensionHandlerInvoker> handlers = new HashMap<Method, ExtensionMetadata.ExtensionHandlerInvoker>();
        Object proxy = Proxy.newProxyInstance(extensionType.getClassLoader(), new Class[]{extensionType}, (proxyInstance, method, args) -> ((ExtensionMetadata.ExtensionHandlerInvoker)handlers.get(method)).invoke(args));
        Object delegatedInstance = factoryFlags.contains((Object)ExtensionFactory.FactoryFlag.NON_VIRTUAL_FACTORY) ? this.delegatedFactory.attach(extensionType, handleSupplier) : proxy;
        ExtensionHandler toStringHandler = (h, target, args) -> "Jdbi extension proxy for " + extensionType.getName() + "@" + Integer.toHexString(proxy.hashCode());
        ExtensionMetadata extensionMetadata = extensionMetaData;
        Objects.requireNonNull(extensionMetadata);
        handlers.put(JdbiClassUtils.TOSTRING_METHOD, new ExtensionMetadata.ExtensionHandlerInvoker(extensionMetadata, proxy, JdbiClassUtils.TOSTRING_METHOD, toStringHandler, handleSupplier, instanceConfig));
        ExtensionMetadata extensionMetadata2 = extensionMetaData;
        Objects.requireNonNull(extensionMetadata2);
        handlers.put(JdbiClassUtils.EQUALS_METHOD, new ExtensionMetadata.ExtensionHandlerInvoker(extensionMetadata2, proxy, JdbiClassUtils.EQUALS_METHOD, ExtensionHandler.EQUALS_HANDLER, handleSupplier, instanceConfig));
        ExtensionMetadata extensionMetadata3 = extensionMetaData;
        Objects.requireNonNull(extensionMetadata3);
        handlers.put(JdbiClassUtils.HASHCODE_METHOD, new ExtensionMetadata.ExtensionHandlerInvoker(extensionMetadata3, proxy, JdbiClassUtils.HASHCODE_METHOD, ExtensionHandler.HASHCODE_HANDLER, handleSupplier, instanceConfig));
        extensionMetaData.getExtensionMethods().forEach(method -> handlers.put((Method)method, extensionMetaData.createExtensionHandlerInvoker(delegatedInstance, (Method)method, handleSupplier, instanceConfig)));
        extensionMetaData.getFinalizer().ifPresent(method -> {
            ExtensionMetadata extensionMetadata = extensionMetaData;
            Objects.requireNonNull(extensionMetadata);
            handlers.put((Method)method, new ExtensionMetadata.ExtensionHandlerInvoker(extensionMetadata, proxy, (Method)method, ExtensionHandler.NULL_HANDLER, handleSupplier, instanceConfig));
        });
        return extensionType.cast(proxy);
    }

    public String toString() {
        return "ExtensionFactoryDelegate for " + this.delegatedFactory.toString();
    }
}

