/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import io.trino.plugin.jdbc.JdbcTypeHandle;
import io.trino.spi.block.Block;
import io.trino.spi.predicate.Utils;
import io.trino.spi.type.Type;
import java.util.Objects;
import java.util.Optional;

public final class QueryParameter {
    private final Optional<JdbcTypeHandle> jdbcType;
    private final Type type;
    private final Optional<Object> value;

    public QueryParameter(Type type, Optional<Object> value) {
        this(Optional.empty(), type, value);
    }

    public QueryParameter(JdbcTypeHandle jdbcType, Type type, Optional<Object> value) {
        this(Optional.of(jdbcType), type, value);
    }

    private QueryParameter(Optional<JdbcTypeHandle> jdbcType, Type type, Optional<Object> value) {
        this.jdbcType = Objects.requireNonNull(jdbcType, "jdbcType is null");
        this.type = Objects.requireNonNull(type, "type is null");
        this.value = Objects.requireNonNull(value, "value is null");
    }

    @JsonCreator
    public static QueryParameter fromValueAsBlock(Optional<JdbcTypeHandle> jdbcType, Type type, Block valueBlock) {
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(valueBlock, "valueBlock is null");
        Optional<Object> value = Optional.ofNullable(Utils.blockToNativeValue((Type)type, (Block)valueBlock));
        return new QueryParameter(jdbcType, type, value);
    }

    @JsonProperty
    public Optional<JdbcTypeHandle> getJdbcType() {
        return this.jdbcType;
    }

    @JsonProperty
    public Type getType() {
        return this.type;
    }

    @JsonProperty
    public Block getValueBlock() {
        return Utils.nativeValueToBlock((Type)this.type, this.value.orElse(null));
    }

    @JsonIgnore
    public Optional<Object> getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryParameter that = (QueryParameter)o;
        return this.jdbcType.equals(that.jdbcType) && this.type.equals(that.type) && this.value.equals(that.value);
    }

    public int hashCode() {
        return Objects.hash(this.jdbcType, this.type, this.value);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("jdbcType", this.jdbcType).add("type", (Object)this.type).add("value", this.value).toString();
    }
}

