/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc.expression;

import com.google.common.collect.ImmutableList;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.plugin.base.expression.ConnectorExpressionPatterns;
import io.trino.plugin.jdbc.expression.ExpressionPattern;
import io.trino.plugin.jdbc.expression.MatchContext;
import io.trino.plugin.jdbc.expression.TypePattern;
import io.trino.spi.expression.Call;
import io.trino.spi.expression.ConnectorExpression;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class CallPattern
extends ExpressionPattern {
    private final String functionName;
    private final List<ExpressionPattern> parameters;
    private final Optional<TypePattern> resultType;
    private final Pattern<Call> pattern;

    public CallPattern(String functionName, List<ExpressionPattern> parameters, Optional<TypePattern> resultType) {
        this.functionName = Objects.requireNonNull(functionName, "functionName is null");
        this.parameters = ImmutableList.copyOf((Collection)Objects.requireNonNull(parameters, "parameters is null"));
        this.resultType = Objects.requireNonNull(resultType, "resultType is null");
        Pattern pattern = ConnectorExpressionPatterns.call().with(ConnectorExpressionPatterns.functionUnqualifiedName().equalTo((Object)functionName));
        if (resultType.isPresent()) {
            pattern = pattern.with(ConnectorExpressionPatterns.type().matching(resultType.get().getPattern()));
        }
        pattern = pattern.with(ConnectorExpressionPatterns.argumentCount().equalTo((Object)parameters.size()));
        for (int i = 0; i < parameters.size(); ++i) {
            pattern = pattern.with(ConnectorExpressionPatterns.argument((int)i).matching(parameters.get(i).getPattern()));
        }
        this.pattern = pattern;
    }

    @Override
    public Pattern<? extends ConnectorExpression> getPattern() {
        return this.pattern;
    }

    @Override
    public void resolve(Captures captures, MatchContext matchContext) {
        for (ExpressionPattern parameter : this.parameters) {
            parameter.resolve(captures, matchContext);
        }
        this.resultType.ifPresent(resultType -> resultType.resolve(captures, matchContext));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CallPattern that = (CallPattern)o;
        return Objects.equals(this.functionName, that.functionName) && Objects.equals(this.parameters, that.parameters) && Objects.equals(this.resultType, that.resultType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.functionName, this.parameters, this.resultType);
    }

    @Override
    public String toString() {
        return String.format("%s(%s)%s", this.functionName, this.parameters.stream().map(Object::toString).collect(Collectors.joining(", ")), this.resultType.map(resultType -> ": " + resultType).orElse(""));
    }
}

