/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc.expression;

import com.google.common.collect.ImmutableList;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.plugin.base.expression.ConnectorExpressionPatterns;
import io.trino.plugin.base.expression.ConnectorExpressionRule;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.QueryParameter;
import io.trino.plugin.jdbc.expression.ParameterizedExpression;
import io.trino.spi.expression.Variable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public class RewriteVariable
implements ConnectorExpressionRule<Variable, ParameterizedExpression> {
    private final Function<String, String> identifierQuote;

    public RewriteVariable(Function<String, String> identifierQuote) {
        this.identifierQuote = Objects.requireNonNull(identifierQuote, "identifierQuote is null");
    }

    public Pattern<Variable> getPattern() {
        return ConnectorExpressionPatterns.variable();
    }

    public Optional<ParameterizedExpression> rewrite(Variable variable, Captures captures, ConnectorExpressionRule.RewriteContext<ParameterizedExpression> context) {
        JdbcColumnHandle columnHandle = (JdbcColumnHandle)context.getAssignment(variable.getName());
        return Optional.of(new ParameterizedExpression(this.identifierQuote.apply(columnHandle.getColumnName()), (List<QueryParameter>)ImmutableList.of()));
    }
}

