/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.configuration;

import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConfigurationUtils {
    private static final Pattern ENV_PATTERN = Pattern.compile("\\$\\{ENV:([a-zA-Z][a-zA-Z0-9_-]*)}");

    private ConfigurationUtils() {
    }

    public static Map<String, String> replaceEnvironmentVariables(Map<String, String> properties) {
        return ConfigurationUtils.replaceEnvironmentVariables(properties, System.getenv(), (k, v) -> {});
    }

    @VisibleForTesting
    public static Map<String, String> replaceEnvironmentVariables(Map<String, String> properties, Map<String, String> environment, BiConsumer<String, String> onError) {
        HashMap<String, String> replaced = new HashMap<String, String>();
        properties.forEach((propertyKey, propertyValue) -> {
            StringBuilder replacedPropertyValue = new StringBuilder();
            Matcher matcher = ENV_PATTERN.matcher((CharSequence)propertyValue);
            while (matcher.find()) {
                String envName = matcher.group(1);
                String envValue = (String)environment.get(envName);
                if (envValue == null) {
                    onError.accept((String)propertyKey, String.format("Configuration property '%s' references unset environment variable '%s'", propertyKey, envName));
                    return;
                }
                matcher.appendReplacement(replacedPropertyValue, Matcher.quoteReplacement(envValue));
            }
            matcher.appendTail(replacedPropertyValue);
            replaced.put((String)propertyKey, replacedPropertyValue.toString());
        });
        return replaced;
    }
}

