/*
 * Decompiled with CFR 0.152.
 */
package io.trino.collect.cache;

import com.google.common.cache.AbstractCache;
import com.google.common.cache.AbstractLoadingCache;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.CacheStats;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import javax.annotation.CheckForNull;

class EmptyCache<K, V>
extends AbstractLoadingCache<K, V> {
    private final CacheLoader<? super K, V> loader;
    private final AbstractCache.StatsCounter statsCounter;

    EmptyCache(CacheLoader<? super K, V> loader, boolean recordStats) {
        this.loader = Objects.requireNonNull(loader, "loader is null");
        this.statsCounter = recordStats ? new AbstractCache.SimpleStatsCounter() : new NoopStatsCounter();
    }

    @CheckForNull
    public V getIfPresent(Object key) {
        this.statsCounter.recordMisses(1);
        return null;
    }

    public V get(K key) throws ExecutionException {
        return (V)this.get(key, () -> this.loader.load(key));
    }

    public V get(K key, Callable<? extends V> valueLoader) throws ExecutionException {
        this.statsCounter.recordMisses(1);
        try {
            V value = valueLoader.call();
            this.statsCounter.recordLoadSuccess(1L);
            return value;
        }
        catch (RuntimeException e) {
            this.statsCounter.recordLoadException(1L);
            throw new UncheckedExecutionException((Throwable)e);
        }
        catch (Exception e) {
            this.statsCounter.recordLoadException(1L);
            throw new ExecutionException(e);
        }
    }

    public void put(K key, V value) {
    }

    public void refresh(K key) {
    }

    public void invalidate(Object key) {
    }

    public void invalidateAll(Iterable<?> keys) {
    }

    public void invalidateAll() {
    }

    public long size() {
        return 0L;
    }

    public CacheStats stats() {
        return this.statsCounter.snapshot();
    }

    public ConcurrentMap<K, V> asMap() {
        return new ConcurrentMap<K, V>(){

            @Override
            public V putIfAbsent(K key, V value) {
                return value;
            }

            @Override
            public boolean remove(Object key, Object value) {
                return false;
            }

            @Override
            public boolean replace(K key, V oldValue, V newValue) {
                return false;
            }

            @Override
            public V replace(K key, V value) {
                return null;
            }

            @Override
            public int size() {
                return 0;
            }

            @Override
            public boolean isEmpty() {
                return true;
            }

            @Override
            public boolean containsKey(Object key) {
                return false;
            }

            @Override
            public boolean containsValue(Object value) {
                return false;
            }

            @Override
            public V get(Object key) {
                return null;
            }

            @Override
            public V put(K key, V value) {
                return null;
            }

            @Override
            public V remove(Object key) {
                return null;
            }

            @Override
            public void putAll(Map<? extends K, ? extends V> m) {
            }

            @Override
            public void clear() {
            }

            @Override
            public Set<K> keySet() {
                return ImmutableSet.of();
            }

            @Override
            public Collection<V> values() {
                return ImmutableSet.of();
            }

            @Override
            public Set<Map.Entry<K, V>> entrySet() {
                return ImmutableSet.of();
            }
        };
    }

    private static class NoopStatsCounter
    implements AbstractCache.StatsCounter {
        private static final CacheStats EMPTY_STATS = new AbstractCache.SimpleStatsCounter().snapshot();

        private NoopStatsCounter() {
        }

        public void recordHits(int count) {
        }

        public void recordMisses(int count) {
        }

        public void recordLoadSuccess(long loadTime) {
        }

        public void recordLoadException(long loadTime) {
        }

        public void recordEviction() {
        }

        public CacheStats snapshot() {
            return EMPTY_STATS;
        }
    }
}

