/*
 * Decompiled with CFR 0.152.
 */
package io.trino.collect.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.ForwardingCache;
import io.trino.collect.cache.NonKeyEvictableCache;
import java.util.Objects;

class NonKeyEvictableCacheImpl<K, V>
extends ForwardingCache<K, V>
implements NonKeyEvictableCache<K, V> {
    private final Cache<K, V> delegate;

    NonKeyEvictableCacheImpl(Cache<K, V> delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
    }

    protected Cache<K, V> delegate() {
        return this.delegate;
    }

    @Override
    public void invalidate(Object key) {
        throw new UnsupportedOperationException("invalidate(key) does not invalidate ongoing loads, so a stale value may remain in the cache for ever. Use EvictableCache if you need invalidation");
    }

    @Override
    public void invalidateAll(Iterable<?> keys) {
        throw new UnsupportedOperationException("invalidateAll(keys) does not invalidate ongoing loads, so a stale value may remain in the cache for ever. Use EvictableCache if you need invalidation");
    }
}

