/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import io.airlift.json.ObjectMapperProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;

public final class JsonUtils {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapperProvider().get().enable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS});

    private JsonUtils() {
    }

    public static <T> T parseJson(Path path, Class<T> javaType) {
        if (!path.isAbsolute()) {
            path = path.toAbsolutePath();
        }
        Preconditions.checkArgument((boolean)Files.exists(path, new LinkOption[0]), (String)"File does not exist: %s", (Object)path);
        Preconditions.checkArgument((boolean)Files.isReadable(path), (String)"File is not readable: %s", (Object)path);
        try {
            byte[] json = Files.readAllBytes(path);
            return JsonUtils.parseJson(json, javaType);
        }
        catch (IOException | RuntimeException e) {
            throw new IllegalArgumentException(String.format("Invalid JSON file '%s' for '%s'", path, javaType), e);
        }
    }

    public static <T> T parseJson(String json, Class<T> javaType) {
        return JsonUtils.parseJson(OBJECT_MAPPER, json, javaType);
    }

    public static <T> T parseJson(ObjectMapper mapper, String json, Class<T> javaType) {
        return JsonUtils.parseJson(mapper, ObjectMapper::createParser, json, javaType);
    }

    public static <T> T parseJson(byte[] jsonBytes, Class<T> javaType) {
        return JsonUtils.parseJson(OBJECT_MAPPER, jsonBytes, javaType);
    }

    public static <T> T parseJson(ObjectMapper mapper, byte[] jsonBytes, Class<T> javaType) {
        return JsonUtils.parseJson(mapper, ObjectMapper::createParser, jsonBytes, javaType);
    }

    public static <T> T parseJson(InputStream inputStream, Class<T> javaType) {
        return JsonUtils.parseJson(OBJECT_MAPPER, inputStream, javaType);
    }

    public static <T> T parseJson(ObjectMapper mapper, InputStream inputStream, Class<T> javaType) {
        return JsonUtils.parseJson(mapper, ObjectMapper::createParser, inputStream, javaType);
    }

    public static <T> T parseJson(URL url, Class<T> javaType) {
        return JsonUtils.parseJson(OBJECT_MAPPER, url, javaType);
    }

    public static <T> T parseJson(ObjectMapper mapper, URL url, Class<T> javaType) {
        return JsonUtils.parseJson(mapper, ObjectMapper::createParser, url, javaType);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <I, T> T parseJson(ObjectMapper mapper, ParserConstructor<I> parserConstructor, I input, Class<T> javaType) {
        Objects.requireNonNull(mapper, "mapper is null");
        Objects.requireNonNull(parserConstructor, "parserConstructor is null");
        Objects.requireNonNull(input, "input is null");
        Objects.requireNonNull(javaType, "javaType is null");
        try (JsonParser parser = parserConstructor.createParser(mapper, input);){
            Object value = mapper.readValue(parser, javaType);
            Preconditions.checkArgument((parser.nextToken() == null ? 1 : 0) != 0, (Object)"Found characters after the expected end of input");
            Object object = value;
            return (T)object;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Could not parse JSON", e);
        }
    }

    public static <T> T jsonTreeToValue(JsonNode treeNode, Class<T> javaType) {
        try {
            return (T)OBJECT_MAPPER.treeToValue((TreeNode)treeNode, javaType);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException("Failed to convert JSON tree node", (IOException)((Object)e));
        }
    }

    private static interface ParserConstructor<I> {
        public JsonParser createParser(ObjectMapper var1, I var2) throws IOException;
    }
}

