/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import io.airlift.log.Logger;
import io.trino.plugin.jdbc.BaseJdbcConfig;
import io.trino.plugin.jdbc.CaseSensitivity;
import io.trino.plugin.jdbc.ColumnMapping;
import io.trino.plugin.jdbc.ConnectionFactory;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcErrorCode;
import io.trino.plugin.jdbc.JdbcJoinCondition;
import io.trino.plugin.jdbc.JdbcOutputTableHandle;
import io.trino.plugin.jdbc.JdbcQueryRelationHandle;
import io.trino.plugin.jdbc.JdbcSortItem;
import io.trino.plugin.jdbc.JdbcSplit;
import io.trino.plugin.jdbc.JdbcTableHandle;
import io.trino.plugin.jdbc.JdbcTypeHandle;
import io.trino.plugin.jdbc.JdbcWriteSessionProperties;
import io.trino.plugin.jdbc.PredicatePushdownController;
import io.trino.plugin.jdbc.PreparedQuery;
import io.trino.plugin.jdbc.QueryBuilder;
import io.trino.plugin.jdbc.RemoteTableName;
import io.trino.plugin.jdbc.StandardColumnMappings;
import io.trino.plugin.jdbc.TypeHandlingJdbcSessionProperties;
import io.trino.plugin.jdbc.UnsupportedTypeHandling;
import io.trino.plugin.jdbc.WriteFunction;
import io.trino.plugin.jdbc.mapping.IdentifierMapping;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.FixedSplitSource;
import io.trino.spi.connector.JoinStatistics;
import io.trino.spi.connector.JoinType;
import io.trino.spi.connector.SchemaNotFoundException;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.spi.statistics.TableStatistics;
import io.trino.spi.type.CharType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public abstract class BaseJdbcClient
implements JdbcClient {
    private static final Logger log = Logger.get(BaseJdbcClient.class);
    protected final ConnectionFactory connectionFactory;
    protected final QueryBuilder queryBuilder;
    protected final String identifierQuote;
    protected final Set<String> jdbcTypesMappedToVarchar;
    private final IdentifierMapping identifierMapping;

    public BaseJdbcClient(BaseJdbcConfig config, String identifierQuote, ConnectionFactory connectionFactory, QueryBuilder queryBuilder, IdentifierMapping identifierMapping) {
        this(identifierQuote, connectionFactory, queryBuilder, config.getJdbcTypesMappedToVarchar(), identifierMapping);
    }

    public BaseJdbcClient(String identifierQuote, ConnectionFactory connectionFactory, QueryBuilder queryBuilder, Set<String> jdbcTypesMappedToVarchar, IdentifierMapping identifierMapping) {
        this.identifierQuote = Objects.requireNonNull(identifierQuote, "identifierQuote is null");
        this.connectionFactory = Objects.requireNonNull(connectionFactory, "connectionFactory is null");
        this.queryBuilder = Objects.requireNonNull(queryBuilder, "queryBuilder is null");
        this.jdbcTypesMappedToVarchar = ImmutableSortedSet.orderedBy((Comparator)String.CASE_INSENSITIVE_ORDER).addAll((Iterable)Objects.requireNonNull(jdbcTypesMappedToVarchar, "jdbcTypesMappedToVarchar is null")).build();
        this.identifierMapping = Objects.requireNonNull(identifierMapping, "identifierMapping is null");
    }

    protected IdentifierMapping getIdentifierMapping() {
        return this.identifierMapping;
    }

    @Override
    public final Set<String> getSchemaNames(ConnectorSession session) {
        Set set;
        block8: {
            Connection connection = this.connectionFactory.openConnection(session);
            try {
                set = (Set)this.listSchemas(connection).stream().map(remoteSchemaName -> this.identifierMapping.fromRemoteSchemaName((String)remoteSchemaName)).collect(ImmutableSet.toImmutableSet());
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
                }
            }
            connection.close();
        }
        return set;
    }

    public Collection<String> listSchemas(Connection connection) {
        ImmutableSet immutableSet;
        block9: {
            ResultSet resultSet = connection.getMetaData().getSchemas(connection.getCatalog(), null);
            try {
                ImmutableSet.Builder schemaNames = ImmutableSet.builder();
                while (resultSet.next()) {
                    String schemaName = resultSet.getString("TABLE_SCHEM");
                    if (!this.filterSchema(schemaName)) continue;
                    schemaNames.add((Object)schemaName);
                }
                immutableSet = schemaNames.build();
                if (resultSet == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
                }
            }
            resultSet.close();
        }
        return immutableSet;
    }

    protected boolean filterSchema(String schemaName) {
        return !schemaName.equalsIgnoreCase("information_schema");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<SchemaTableName> getTableNames(ConnectorSession session, Optional<String> schema) {
        try (Connection connection = this.connectionFactory.openConnection(session);){
            ImmutableList immutableList;
            block17: {
                ConnectorIdentity identity = session.getIdentity();
                Optional<String> remoteSchema = schema.map(schemaName -> this.identifierMapping.toRemoteSchemaName(identity, connection, (String)schemaName));
                if (remoteSchema.isPresent() && !this.filterSchema(remoteSchema.get())) {
                    ImmutableList immutableList2 = ImmutableList.of();
                    return immutableList2;
                }
                ResultSet resultSet = this.getTables(connection, remoteSchema, Optional.empty());
                try {
                    ImmutableList.Builder list = ImmutableList.builder();
                    while (resultSet.next()) {
                        String remoteSchemaFromResultSet = this.getTableSchemaName(resultSet);
                        String tableSchema = this.identifierMapping.fromRemoteSchemaName(remoteSchemaFromResultSet);
                        String tableName = this.identifierMapping.fromRemoteTableName(remoteSchemaFromResultSet, resultSet.getString("TABLE_NAME"));
                        if (!this.filterSchema(tableSchema)) continue;
                        list.add((Object)new SchemaTableName(tableSchema, tableName));
                    }
                    immutableList = list.build();
                    if (resultSet == null) break block17;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return immutableList;
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<JdbcTableHandle> getTableHandle(ConnectorSession session, SchemaTableName schemaTableName) {
        try (Connection connection = this.connectionFactory.openConnection(session);){
            Optional<JdbcTableHandle> optional;
            block20: {
                ArrayList<JdbcTableHandle> tableHandles;
                ResultSet resultSet;
                block18: {
                    Optional<JdbcTableHandle> optional2;
                    block19: {
                        ConnectorIdentity identity = session.getIdentity();
                        String remoteSchema = this.identifierMapping.toRemoteSchemaName(identity, connection, schemaTableName.getSchemaName());
                        String remoteTable = this.identifierMapping.toRemoteTableName(identity, connection, remoteSchema, schemaTableName.getTableName());
                        resultSet = this.getTables(connection, Optional.of(remoteSchema), Optional.of(remoteTable));
                        try {
                            tableHandles = new ArrayList<JdbcTableHandle>();
                            while (resultSet.next()) {
                                tableHandles.add(new JdbcTableHandle(schemaTableName, BaseJdbcClient.getRemoteTable(resultSet), this.getTableComment(resultSet)));
                            }
                            if (!tableHandles.isEmpty()) break block18;
                            optional2 = Optional.empty();
                            if (resultSet == null) break block19;
                        }
                        catch (Throwable throwable) {
                            if (resultSet != null) {
                                try {
                                    resultSet.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        resultSet.close();
                    }
                    return optional2;
                }
                if (tableHandles.size() > 1) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Multiple tables matched: " + schemaTableName);
                }
                optional = Optional.of((JdbcTableHandle)Iterables.getOnlyElement(tableHandles));
                if (resultSet == null) break block20;
                resultSet.close();
            }
            return optional;
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    @Override
    public JdbcTableHandle getTableHandle(ConnectorSession session, PreparedQuery preparedQuery) {
        ImmutableList.Builder columns = ImmutableList.builder();
        try (Connection connection = this.connectionFactory.openConnection(session);
             PreparedStatement preparedStatement = this.queryBuilder.prepareStatement(this, session, connection, preparedQuery);){
            ResultSetMetaData metadata = preparedStatement.getMetaData();
            if (metadata == null) {
                throw new UnsupportedOperationException("Query not supported: ResultSetMetaData not available for query: " + preparedQuery.getQuery());
            }
            for (int column = 1; column <= metadata.getColumnCount(); ++column) {
                String name = metadata.getColumnName(column);
                JdbcTypeHandle jdbcTypeHandle = new JdbcTypeHandle(metadata.getColumnType(column), Optional.ofNullable(metadata.getColumnTypeName(column)), Optional.of(metadata.getPrecision(column)), Optional.of(metadata.getScale(column)), Optional.empty(), Optional.of(metadata.isCaseSensitive(column) ? CaseSensitivity.CASE_SENSITIVE : CaseSensitivity.CASE_INSENSITIVE));
                Type type = this.toColumnMapping(session, connection, jdbcTypeHandle).orElseThrow(() -> new UnsupportedOperationException(String.format("Unsupported type: %s of column: %s", jdbcTypeHandle, name))).getType();
                columns.add((Object)new JdbcColumnHandle(name, jdbcTypeHandle, type));
            }
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, "Failed to get table handle for prepared query. " + MoreObjects.firstNonNull((Object)e.getMessage(), (Object)e), (Throwable)e);
        }
        return new JdbcTableHandle(new JdbcQueryRelationHandle(preparedQuery), (TupleDomain<ColumnHandle>)TupleDomain.all(), (List<String>)ImmutableList.of(), Optional.empty(), OptionalLong.empty(), Optional.of(columns.build()), Optional.empty(), 0);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<JdbcColumnHandle> getColumns(ConnectorSession session, JdbcTableHandle tableHandle) {
        if (tableHandle.getColumns().isPresent()) {
            return tableHandle.getColumns().get();
        }
        Preconditions.checkArgument((boolean)tableHandle.isNamedRelation(), (String)"Cannot get columns for %s", (Object)tableHandle);
        SchemaTableName schemaTableName = tableHandle.getRequiredNamedRelation().getSchemaTableName();
        RemoteTableName remoteTableName = tableHandle.getRequiredNamedRelation().getRemoteTableName();
        try (Connection connection = this.connectionFactory.openConnection(session);){
            ImmutableList immutableList;
            block17: {
                ResultSet resultSet = this.getColumns(tableHandle, connection.getMetaData());
                try {
                    int allColumns = 0;
                    ArrayList columns = new ArrayList();
                    while (resultSet.next()) {
                        if (!Objects.equals(remoteTableName, BaseJdbcClient.getRemoteTable(resultSet))) continue;
                        ++allColumns;
                        String columnName = resultSet.getString("COLUMN_NAME");
                        JdbcTypeHandle typeHandle = new JdbcTypeHandle((int)BaseJdbcClient.getInteger(resultSet, "DATA_TYPE").orElseThrow(() -> new IllegalStateException("DATA_TYPE is null")), Optional.ofNullable(resultSet.getString("TYPE_NAME")), BaseJdbcClient.getInteger(resultSet, "COLUMN_SIZE"), BaseJdbcClient.getInteger(resultSet, "DECIMAL_DIGITS"), Optional.empty(), Optional.empty());
                        Optional<ColumnMapping> columnMapping = this.toColumnMapping(session, connection, typeHandle);
                        log.debug("Mapping data type of '%s' column '%s': %s mapped to %s", new Object[]{schemaTableName, columnName, typeHandle, columnMapping});
                        boolean nullable = resultSet.getInt("NULLABLE") != 0;
                        Optional<String> comment = Optional.ofNullable(Strings.emptyToNull((String)resultSet.getString("REMARKS")));
                        columnMapping.ifPresent(mapping -> columns.add(JdbcColumnHandle.builder().setColumnName(columnName).setJdbcTypeHandle(typeHandle).setColumnType(mapping.getType()).setNullable(nullable).setComment(comment).build()));
                        if (!columnMapping.isEmpty()) continue;
                        UnsupportedTypeHandling unsupportedTypeHandling = TypeHandlingJdbcSessionProperties.getUnsupportedTypeHandling(session);
                        Verify.verify((unsupportedTypeHandling == UnsupportedTypeHandling.IGNORE ? 1 : 0) != 0, (String)"Unsupported type handling is set to %s, but toColumnMapping() returned empty for %s", (Object)((Object)unsupportedTypeHandling), (Object)typeHandle);
                    }
                    if (columns.isEmpty()) {
                        throw new TableNotFoundException(schemaTableName, String.format("Table '%s' has no supported columns (all %s columns are not supported)", schemaTableName, allColumns));
                    }
                    immutableList = ImmutableList.copyOf(columns);
                    if (resultSet == null) break block17;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return immutableList;
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    protected static Optional<Integer> getInteger(ResultSet resultSet, String columnLabel) throws SQLException {
        int value = resultSet.getInt(columnLabel);
        if (resultSet.wasNull()) {
            return Optional.empty();
        }
        return Optional.of(value);
    }

    protected ResultSet getColumns(JdbcTableHandle tableHandle, DatabaseMetaData metadata) throws SQLException {
        RemoteTableName remoteTableName = tableHandle.getRequiredNamedRelation().getRemoteTableName();
        return metadata.getColumns(remoteTableName.getCatalogName().orElse(null), BaseJdbcClient.escapeNamePattern(remoteTableName.getSchemaName(), metadata.getSearchStringEscape()).orElse(null), BaseJdbcClient.escapeNamePattern(remoteTableName.getTableName(), metadata.getSearchStringEscape()), null);
    }

    @Override
    public List<ColumnMapping> toColumnMappings(ConnectorSession session, List<JdbcTypeHandle> typeHandles) {
        List list;
        block8: {
            Connection connection = this.connectionFactory.openConnection(session);
            try {
                list = (List)typeHandles.stream().map(typeHandle -> this.toColumnMapping(session, connection, (JdbcTypeHandle)typeHandle).orElseThrow(() -> new VerifyException(String.format("Unsupported type handle %s", typeHandle)))).collect(ImmutableList.toImmutableList());
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
                }
            }
            connection.close();
        }
        return list;
    }

    protected Optional<ColumnMapping> getForcedMappingToVarchar(JdbcTypeHandle typeHandle) {
        if (typeHandle.getJdbcTypeName().isPresent() && this.jdbcTypesMappedToVarchar.contains(typeHandle.getJdbcTypeName().get())) {
            return BaseJdbcClient.mapToUnboundedVarchar(typeHandle);
        }
        return Optional.empty();
    }

    protected static Optional<ColumnMapping> mapToUnboundedVarchar(JdbcTypeHandle typeHandle) {
        VarcharType unboundedVarcharType = VarcharType.createUnboundedVarcharType();
        return Optional.of(ColumnMapping.sliceMapping((Type)unboundedVarcharType, StandardColumnMappings.varcharReadFunction(unboundedVarcharType), (statement, index, value) -> {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Underlying type that is mapped to VARCHAR is not supported for INSERT: " + typeHandle.getJdbcTypeName().get());
        }, PredicatePushdownController.DISABLE_PUSHDOWN));
    }

    @Override
    public ConnectorSplitSource getSplits(ConnectorSession session, JdbcTableHandle tableHandle) {
        return new FixedSplitSource((Iterable)ImmutableList.of((Object)new JdbcSplit(Optional.empty())));
    }

    @Override
    public Connection getConnection(ConnectorSession session, JdbcSplit split) throws SQLException {
        Connection connection = this.connectionFactory.openConnection(session);
        try {
            connection.setReadOnly(true);
        }
        catch (SQLException e) {
            connection.close();
            throw e;
        }
        return connection;
    }

    @Override
    public PreparedQuery prepareQuery(ConnectorSession session, JdbcTableHandle table, Optional<List<List<JdbcColumnHandle>>> groupingSets, List<JdbcColumnHandle> columns, Map<String, String> columnExpressions) {
        PreparedQuery preparedQuery;
        block8: {
            Connection connection = this.connectionFactory.openConnection(session);
            try {
                preparedQuery = this.prepareQuery(session, connection, table, groupingSets, columns, columnExpressions, Optional.empty());
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
                }
            }
            connection.close();
        }
        return preparedQuery;
    }

    @Override
    public PreparedStatement buildSql(ConnectorSession session, Connection connection, JdbcSplit split, JdbcTableHandle table, List<JdbcColumnHandle> columns) throws SQLException {
        PreparedQuery preparedQuery = this.prepareQuery(session, connection, table, Optional.empty(), columns, (Map<String, String>)ImmutableMap.of(), Optional.of(split));
        return this.queryBuilder.prepareStatement(this, session, connection, preparedQuery);
    }

    protected PreparedQuery prepareQuery(ConnectorSession session, Connection connection, JdbcTableHandle table, Optional<List<List<JdbcColumnHandle>>> groupingSets, List<JdbcColumnHandle> columns, Map<String, String> columnExpressions, Optional<JdbcSplit> split) {
        return this.applyQueryTransformations(table, this.queryBuilder.prepareSelectQuery(this, session, connection, table.getRelationHandle(), groupingSets, columns, columnExpressions, table.getConstraint(), BaseJdbcClient.getAdditionalPredicate(table.getConstraintExpressions(), split.flatMap(JdbcSplit::getAdditionalPredicate))));
    }

    protected static Optional<String> getAdditionalPredicate(List<String> constraintExpressions, Optional<String> splitPredicate) {
        if (constraintExpressions.isEmpty() && splitPredicate.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(Stream.concat(constraintExpressions.stream(), splitPredicate.stream()).collect(Collectors.joining(") AND (", "(", ")")));
    }

    @Override
    public Optional<PreparedQuery> implementJoin(ConnectorSession session, JoinType joinType, PreparedQuery leftSource, PreparedQuery rightSource, List<JdbcJoinCondition> joinConditions, Map<JdbcColumnHandle, String> rightAssignments, Map<JdbcColumnHandle, String> leftAssignments, JoinStatistics statistics) {
        Optional<PreparedQuery> optional;
        block9: {
            for (JdbcJoinCondition joinCondition : joinConditions) {
                if (this.isSupportedJoinCondition(session, joinCondition)) continue;
                return Optional.empty();
            }
            Connection connection = this.connectionFactory.openConnection(session);
            try {
                optional = Optional.of(this.queryBuilder.prepareJoinQuery(this, session, connection, joinType, leftSource, rightSource, joinConditions, leftAssignments, rightAssignments));
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
                }
            }
            connection.close();
        }
        return optional;
    }

    protected boolean isSupportedJoinCondition(ConnectorSession session, JdbcJoinCondition joinCondition) {
        return false;
    }

    protected PreparedQuery applyQueryTransformations(JdbcTableHandle tableHandle, PreparedQuery query) {
        PreparedQuery preparedQuery = query;
        if (tableHandle.getLimit().isPresent()) {
            preparedQuery = tableHandle.getSortOrder().isPresent() ? preparedQuery.transformQuery(this.applyTopN(tableHandle.getSortOrder().get(), tableHandle.getLimit().getAsLong())) : preparedQuery.transformQuery(this.applyLimit(tableHandle.getLimit().getAsLong()));
        }
        return preparedQuery;
    }

    @Override
    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        try {
            this.createTable(session, tableMetadata, tableMetadata.getTable().getTableName());
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    @Override
    public JdbcOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        try {
            return this.createTable(session, tableMetadata, this.generateTemporaryTableName());
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    protected JdbcOutputTableHandle createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, String targetTableName) throws SQLException {
        SchemaTableName schemaTableName = tableMetadata.getTable();
        ConnectorIdentity identity = session.getIdentity();
        if (!this.getSchemaNames(session).contains(schemaTableName.getSchemaName())) {
            throw new SchemaNotFoundException(schemaTableName.getSchemaName());
        }
        try (Connection connection = this.connectionFactory.openConnection(session);){
            String remoteSchema = this.identifierMapping.toRemoteSchemaName(identity, connection, schemaTableName.getSchemaName());
            String remoteTable = this.identifierMapping.toRemoteTableName(identity, connection, remoteSchema, schemaTableName.getTableName());
            String remoteTargetTableName = this.identifierMapping.toRemoteTableName(identity, connection, remoteSchema, targetTableName);
            String catalog = connection.getCatalog();
            this.verifyTableName(connection.getMetaData(), remoteTargetTableName);
            List columns = tableMetadata.getColumns();
            ImmutableList.Builder columnNames = ImmutableList.builderWithExpectedSize((int)columns.size());
            ImmutableList.Builder columnTypes = ImmutableList.builderWithExpectedSize((int)columns.size());
            ImmutableList.Builder columnList = ImmutableList.builderWithExpectedSize((int)columns.size());
            for (ColumnMetadata column : columns) {
                String columnName = this.identifierMapping.toRemoteColumnName(connection, column.getName());
                this.verifyColumnName(connection.getMetaData(), columnName);
                columnNames.add((Object)columnName);
                columnTypes.add((Object)column.getType());
                columnList.add((Object)this.getColumnDefinitionSql(session, column, columnName));
            }
            RemoteTableName remoteTableName = new RemoteTableName(Optional.ofNullable(catalog), Optional.ofNullable(remoteSchema), remoteTargetTableName);
            String sql = this.createTableSql(remoteTableName, (List<String>)columnList.build(), tableMetadata);
            this.execute(connection, sql);
            JdbcOutputTableHandle jdbcOutputTableHandle = new JdbcOutputTableHandle(catalog, remoteSchema, remoteTable, (List<String>)columnNames.build(), (List<Type>)columnTypes.build(), Optional.empty(), Optional.of(remoteTargetTableName));
            return jdbcOutputTableHandle;
        }
    }

    protected String createTableSql(RemoteTableName remoteTableName, List<String> columns, ConnectorTableMetadata tableMetadata) {
        if (tableMetadata.getComment().isPresent()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support creating tables with table comment");
        }
        Preconditions.checkArgument((boolean)tableMetadata.getProperties().isEmpty(), (String)"Unsupported table properties: %s", (Object)tableMetadata.getProperties());
        return String.format("CREATE TABLE %s (%s)", this.quoted(remoteTableName), String.join((CharSequence)", ", columns));
    }

    protected String getColumnDefinitionSql(ConnectorSession session, ColumnMetadata column, String columnName) {
        if (column.getComment() != null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support creating tables with column comment");
        }
        StringBuilder sb = new StringBuilder().append(this.quoted(columnName)).append(" ").append(this.toWriteMapping(session, column.getType()).getDataType());
        if (!column.isNullable()) {
            sb.append(" NOT NULL");
        }
        return sb.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public JdbcOutputTableHandle beginInsertTable(ConnectorSession session, JdbcTableHandle tableHandle, List<JdbcColumnHandle> columns) {
        SchemaTableName schemaTableName = tableHandle.asPlainTable().getSchemaTableName();
        ConnectorIdentity identity = session.getIdentity();
        try (Connection connection = this.connectionFactory.openConnection(session);){
            String remoteSchema = this.identifierMapping.toRemoteSchemaName(identity, connection, schemaTableName.getSchemaName());
            String remoteTable = this.identifierMapping.toRemoteTableName(identity, connection, remoteSchema, schemaTableName.getTableName());
            String catalog = connection.getCatalog();
            ImmutableList.Builder columnNames = ImmutableList.builder();
            ImmutableList.Builder columnTypes = ImmutableList.builder();
            ImmutableList.Builder jdbcColumnTypes = ImmutableList.builder();
            for (JdbcColumnHandle column : columns) {
                columnNames.add((Object)column.getColumnName());
                columnTypes.add((Object)column.getColumnType());
                jdbcColumnTypes.add((Object)column.getJdbcTypeHandle());
            }
            if (JdbcWriteSessionProperties.isNonTransactionalInsert(session)) {
                JdbcOutputTableHandle jdbcOutputTableHandle2 = new JdbcOutputTableHandle(catalog, remoteSchema, remoteTable, (List<String>)columnNames.build(), (List<Type>)columnTypes.build(), Optional.of(jdbcColumnTypes.build()), Optional.empty());
                return jdbcOutputTableHandle2;
            }
            String remoteTemporaryTableName = this.identifierMapping.toRemoteTableName(identity, connection, remoteSchema, this.generateTemporaryTableName());
            this.copyTableSchema(connection, catalog, remoteSchema, remoteTable, remoteTemporaryTableName, (List<String>)columnNames.build());
            JdbcOutputTableHandle jdbcOutputTableHandle = new JdbcOutputTableHandle(catalog, remoteSchema, remoteTable, (List<String>)columnNames.build(), (List<Type>)columnTypes.build(), Optional.of(jdbcColumnTypes.build()), Optional.of(remoteTemporaryTableName));
            return jdbcOutputTableHandle;
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    protected void copyTableSchema(Connection connection, String catalogName, String schemaName, String tableName, String newTableName, List<String> columnNames) {
        String sql = String.format("CREATE TABLE %s AS SELECT %s FROM %s WHERE 0 = 1", this.quoted(catalogName, schemaName, newTableName), columnNames.stream().map(this::quoted).collect(Collectors.joining(", ")), this.quoted(catalogName, schemaName, tableName));
        this.execute(connection, sql);
    }

    protected String generateTemporaryTableName() {
        return "tmp_trino_" + UUID.randomUUID().toString().replace("-", "");
    }

    @Override
    public void commitCreateTable(ConnectorSession session, JdbcOutputTableHandle handle) {
        this.renameTable(session, handle.getCatalogName(), handle.getSchemaName(), handle.getTemporaryTableName().orElseThrow(() -> new IllegalStateException("Temporary table name missing")), new SchemaTableName(handle.getSchemaName(), handle.getTableName()));
    }

    @Override
    public void renameTable(ConnectorSession session, JdbcTableHandle handle, SchemaTableName newTableName) {
        RemoteTableName remoteTableName = handle.asPlainTable().getRemoteTableName();
        this.renameTable(session, remoteTableName.getCatalogName().orElse(null), remoteTableName.getSchemaName().orElse(null), remoteTableName.getTableName(), newTableName);
    }

    protected void renameTable(ConnectorSession session, String catalogName, String remoteSchemaName, String remoteTableName, SchemaTableName newTable) {
        try (Connection connection = this.connectionFactory.openConnection(session);){
            String newSchemaName = newTable.getSchemaName();
            String newTableName = newTable.getTableName();
            this.verifyTableName(connection.getMetaData(), newTableName);
            ConnectorIdentity identity = session.getIdentity();
            String newRemoteSchemaName = this.identifierMapping.toRemoteSchemaName(identity, connection, newSchemaName);
            String newRemoteTableName = this.identifierMapping.toRemoteTableName(identity, connection, newRemoteSchemaName, newTableName);
            String sql = this.renameTableSql(catalogName, remoteSchemaName, remoteTableName, newRemoteSchemaName, newRemoteTableName);
            this.execute(connection, sql);
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    protected String renameTableSql(String catalogName, String remoteSchemaName, String remoteTableName, String newRemoteSchemaName, String newRemoteTableName) {
        return String.format("ALTER TABLE %s RENAME TO %s", this.quoted(catalogName, remoteSchemaName, remoteTableName), this.quoted(catalogName, newRemoteSchemaName, newRemoteTableName));
    }

    @Override
    public void finishInsertTable(ConnectorSession session, JdbcOutputTableHandle handle) {
        if (JdbcWriteSessionProperties.isNonTransactionalInsert(session)) {
            Preconditions.checkState((boolean)handle.getTemporaryTableName().isEmpty(), (Object)"Unexpected use of temporary table when non transactional inserts are enabled");
            return;
        }
        RemoteTableName temporaryTable = new RemoteTableName(Optional.ofNullable(handle.getCatalogName()), Optional.ofNullable(handle.getSchemaName()), handle.getTemporaryTableName().orElseThrow());
        RemoteTableName targetTable = new RemoteTableName(Optional.ofNullable(handle.getCatalogName()), Optional.ofNullable(handle.getSchemaName()), handle.getTableName());
        String insertSql = this.buildInsertSql(session, targetTable, temporaryTable, handle.getColumnNames());
        try (Connection connection = this.getConnection(session, handle);){
            this.execute(connection, insertSql);
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
        finally {
            this.dropTable(session, temporaryTable);
        }
    }

    protected String buildInsertSql(ConnectorSession session, RemoteTableName targetTable, RemoteTableName sourceTable, List<String> columnNames) {
        String columns = columnNames.stream().map(this::quoted).collect(Collectors.joining(", "));
        return String.format("INSERT INTO %s (%s) SELECT %s FROM %s", this.quoted(targetTable), columns, columns, this.quoted(sourceTable));
    }

    @Override
    public void addColumn(ConnectorSession session, JdbcTableHandle handle, ColumnMetadata column) {
        if (column.getComment() != null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support adding columns with comments");
        }
        try (Connection connection = this.connectionFactory.openConnection(session);){
            String columnName = column.getName();
            this.verifyColumnName(connection.getMetaData(), columnName);
            String remoteColumnName = this.identifierMapping.toRemoteColumnName(connection, columnName);
            String sql = String.format("ALTER TABLE %s ADD %s", this.quoted(handle.asPlainTable().getRemoteTableName()), this.getColumnDefinitionSql(session, column, remoteColumnName));
            this.execute(connection, sql);
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    @Override
    public void renameColumn(ConnectorSession session, JdbcTableHandle handle, JdbcColumnHandle jdbcColumn, String newColumnName) {
        try (Connection connection = this.connectionFactory.openConnection(session);){
            String newRemoteColumnName = this.identifierMapping.toRemoteColumnName(connection, newColumnName);
            this.verifyColumnName(connection.getMetaData(), newRemoteColumnName);
            String sql = this.renameColumnSql(handle, jdbcColumn, newRemoteColumnName);
            this.execute(connection, sql);
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    protected String renameColumnSql(JdbcTableHandle handle, JdbcColumnHandle jdbcColumn, String newRemoteColumnName) {
        return String.format("ALTER TABLE %s RENAME COLUMN %s TO %s", this.quoted(handle.asPlainTable().getRemoteTableName()), this.quoted(jdbcColumn.getColumnName()), this.quoted(newRemoteColumnName));
    }

    @Override
    public void dropColumn(ConnectorSession session, JdbcTableHandle handle, JdbcColumnHandle column) {
        try (Connection connection = this.connectionFactory.openConnection(session);){
            String remoteColumnName = this.identifierMapping.toRemoteColumnName(connection, column.getColumnName());
            String sql = String.format("ALTER TABLE %s DROP COLUMN %s", this.quoted(handle.asPlainTable().getRemoteTableName()), this.quoted(remoteColumnName));
            this.execute(connection, sql);
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    @Override
    public void dropTable(ConnectorSession session, JdbcTableHandle handle) {
        this.dropTable(session, handle.asPlainTable().getRemoteTableName());
    }

    private void dropTable(ConnectorSession session, RemoteTableName remoteTableName) {
        String sql = "DROP TABLE " + this.quoted(remoteTableName);
        this.execute(session, sql);
    }

    @Override
    public void rollbackCreateTable(ConnectorSession session, JdbcOutputTableHandle handle) {
        if (handle.getTemporaryTableName().isPresent()) {
            this.dropTable(session, new JdbcTableHandle(new SchemaTableName(handle.getSchemaName(), handle.getTemporaryTableName().get()), new RemoteTableName(Optional.ofNullable(handle.getCatalogName()), Optional.ofNullable(handle.getSchemaName()), handle.getTemporaryTableName().get()), Optional.empty()));
        }
    }

    @Override
    public String buildInsertSql(JdbcOutputTableHandle handle, List<WriteFunction> columnWriters) {
        Preconditions.checkArgument((handle.getColumnNames().size() == columnWriters.size() ? 1 : 0) != 0, (String)"handle and columnWriters mismatch: %s, %s", (Object)handle, columnWriters);
        Object[] objectArray = new Object[3];
        objectArray[0] = this.quoted(handle.getCatalogName(), handle.getSchemaName(), handle.getTemporaryTableName().orElseGet(handle::getTableName));
        objectArray[1] = handle.getColumnNames().stream().map(this::quoted).collect(Collectors.joining(", "));
        objectArray[2] = columnWriters.stream().map(WriteFunction::getBindExpression).collect(Collectors.joining(","));
        return String.format("INSERT INTO %s (%s) VALUES (%s)", objectArray);
    }

    @Override
    public Connection getConnection(ConnectorSession session, JdbcOutputTableHandle handle) throws SQLException {
        return this.connectionFactory.openConnection(session);
    }

    @Override
    public PreparedStatement getPreparedStatement(Connection connection, String sql) throws SQLException {
        return connection.prepareStatement(sql);
    }

    public ResultSet getTables(Connection connection, Optional<String> remoteSchemaName, Optional<String> remoteTableName) throws SQLException {
        DatabaseMetaData metadata = connection.getMetaData();
        return metadata.getTables(connection.getCatalog(), BaseJdbcClient.escapeNamePattern(remoteSchemaName, metadata.getSearchStringEscape()).orElse(null), BaseJdbcClient.escapeNamePattern(remoteTableName, metadata.getSearchStringEscape()).orElse(null), this.getTableTypes().map(types -> (String[])types.toArray(String[]::new)).orElse(null));
    }

    protected Optional<List<String>> getTableTypes() {
        return Optional.of(ImmutableList.of((Object)"TABLE", (Object)"VIEW"));
    }

    protected String getTableSchemaName(ResultSet resultSet) throws SQLException {
        return resultSet.getString("TABLE_SCHEM");
    }

    @Override
    public TableStatistics getTableStatistics(ConnectorSession session, JdbcTableHandle handle, TupleDomain<ColumnHandle> tupleDomain) {
        return TableStatistics.empty();
    }

    @Override
    public void createSchema(ConnectorSession session, String schemaName) {
        ConnectorIdentity identity = session.getIdentity();
        try (Connection connection = this.connectionFactory.openConnection(session);){
            schemaName = this.identifierMapping.toRemoteSchemaName(identity, connection, schemaName);
            this.verifySchemaName(connection.getMetaData(), schemaName);
            this.execute(connection, this.createSchemaSql(schemaName));
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    protected String createSchemaSql(String schemaName) {
        return "CREATE SCHEMA " + this.quoted(schemaName);
    }

    @Override
    public void dropSchema(ConnectorSession session, String schemaName) {
        ConnectorIdentity identity = session.getIdentity();
        try (Connection connection = this.connectionFactory.openConnection(session);){
            schemaName = this.identifierMapping.toRemoteSchemaName(identity, connection, schemaName);
            this.execute(connection, this.dropSchemaSql(schemaName));
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    protected String dropSchemaSql(String schemaName) {
        return "DROP SCHEMA " + this.quoted(schemaName);
    }

    @Override
    public void renameSchema(ConnectorSession session, String schemaName, String newSchemaName) {
        ConnectorIdentity identity = session.getIdentity();
        try (Connection connection = this.connectionFactory.openConnection(session);){
            String remoteSchemaName = this.identifierMapping.toRemoteSchemaName(identity, connection, schemaName);
            String newRemoteSchemaName = this.identifierMapping.toRemoteSchemaName(identity, connection, newSchemaName);
            this.verifySchemaName(connection.getMetaData(), newRemoteSchemaName);
            this.execute(connection, this.renameSchemaSql(remoteSchemaName, newRemoteSchemaName));
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    protected String renameSchemaSql(String remoteSchemaName, String newRemoteSchemaName) {
        return "ALTER SCHEMA " + this.quoted(remoteSchemaName) + " RENAME TO " + this.quoted(newRemoteSchemaName);
    }

    protected void execute(ConnectorSession session, String query) {
        try (Connection connection = this.connectionFactory.openConnection(session);){
            this.execute(connection, query);
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    protected void execute(Connection connection, String query) {
        try (Statement statement = connection.createStatement();){
            log.debug("Execute: %s", new Object[]{query});
            statement.execute(query);
        }
        catch (SQLException e) {
            TrinoException exception = new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
            exception.addSuppressed((Throwable)new RuntimeException("Query: " + query));
            throw exception;
        }
    }

    protected static boolean preventTextualTypeAggregationPushdown(List<List<ColumnHandle>> groupingSets) {
        if (!groupingSets.isEmpty()) {
            for (List<ColumnHandle> groupingSet : groupingSets) {
                boolean hasCaseSensitiveGroupingSet = groupingSet.stream().map(columnHandle -> ((JdbcColumnHandle)columnHandle).getColumnType()).anyMatch(type -> type instanceof VarcharType || type instanceof CharType);
                if (!hasCaseSensitiveGroupingSet) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean supportsTopN(ConnectorSession session, JdbcTableHandle handle, List<JdbcSortItem> sortOrder) {
        if (this.topNFunction().isEmpty()) {
            return false;
        }
        throw new UnsupportedOperationException("topNFunction() implemented without implementing supportsTopN()");
    }

    protected Optional<TopNFunction> topNFunction() {
        return Optional.empty();
    }

    private Function<String, String> applyTopN(List<JdbcSortItem> sortOrder, long limit) {
        return query -> this.topNFunction().orElseThrow().apply((String)query, sortOrder, limit);
    }

    @Override
    public boolean isTopNGuaranteed(ConnectorSession session) {
        throw new UnsupportedOperationException("topNFunction() implemented without implementing isTopNLimitGuaranteed()");
    }

    @Override
    public boolean supportsLimit() {
        return this.limitFunction().isPresent();
    }

    protected Optional<BiFunction<String, Long, String>> limitFunction() {
        return Optional.empty();
    }

    private Function<String, String> applyLimit(long limit) {
        return query -> this.limitFunction().orElseThrow().apply((String)query, limit);
    }

    @Override
    public boolean isLimitGuaranteed(ConnectorSession session) {
        throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, "limitFunction() is implemented without isLimitGuaranteed()");
    }

    @Override
    public String quoted(String name) {
        name = name.replace(this.identifierQuote, this.identifierQuote + this.identifierQuote);
        return this.identifierQuote + name + this.identifierQuote;
    }

    @Override
    public String quoted(RemoteTableName remoteTableName) {
        return this.quoted(remoteTableName.getCatalogName().orElse(null), remoteTableName.getSchemaName().orElse(null), remoteTableName.getTableName());
    }

    @Override
    public Map<String, Object> getTableProperties(ConnectorSession session, JdbcTableHandle tableHandle) {
        return Collections.emptyMap();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public OptionalLong delete(ConnectorSession session, JdbcTableHandle handle) {
        Preconditions.checkArgument((boolean)handle.isNamedRelation(), (String)"Unable to delete from synthetic table: %s", (Object)handle);
        Preconditions.checkArgument((boolean)handle.getLimit().isEmpty(), (String)"Unable to delete when limit is set: %s", (Object)handle);
        Preconditions.checkArgument((boolean)handle.getSortOrder().isEmpty(), (String)"Unable to delete when sort order is set: %s", (Object)handle);
        try (Connection connection = this.connectionFactory.openConnection(session);){
            OptionalLong optionalLong;
            block14: {
                Verify.verify((boolean)connection.getAutoCommit());
                PreparedQuery preparedQuery = this.queryBuilder.prepareDeleteQuery(this, session, connection, handle.getRequiredNamedRelation(), handle.getConstraint(), BaseJdbcClient.getAdditionalPredicate(handle.getConstraintExpressions(), Optional.empty()));
                PreparedStatement preparedStatement = this.queryBuilder.prepareStatement(this, session, connection, preparedQuery);
                try {
                    optionalLong = OptionalLong.of(preparedStatement.executeUpdate());
                    if (preparedStatement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return optionalLong;
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    @Override
    public void truncateTable(ConnectorSession session, JdbcTableHandle handle) {
        String sql = "TRUNCATE TABLE " + this.quoted(handle.asPlainTable().getRemoteTableName());
        this.execute(session, sql);
    }

    protected void verifySchemaName(DatabaseMetaData databaseMetadata, String schemaName) throws SQLException {
    }

    protected void verifyTableName(DatabaseMetaData databaseMetadata, String tableName) throws SQLException {
    }

    protected void verifyColumnName(DatabaseMetaData databaseMetadata, String columnName) throws SQLException {
    }

    protected String quoted(@Nullable String catalog, @Nullable String schema, String table) {
        StringBuilder sb = new StringBuilder();
        if (!Strings.isNullOrEmpty((String)catalog)) {
            sb.append(this.quoted(catalog)).append(".");
        }
        if (!Strings.isNullOrEmpty((String)schema)) {
            sb.append(this.quoted(schema)).append(".");
        }
        sb.append(this.quoted(table));
        return sb.toString();
    }

    public static String varcharLiteral(String value) {
        Objects.requireNonNull(value, "value is null");
        return "'" + value.replace("'", "''") + "'";
    }

    protected static Optional<String> escapeNamePattern(Optional<String> name, String escape) {
        return name.map(string -> BaseJdbcClient.escapeNamePattern(string, escape));
    }

    private static String escapeNamePattern(String name, String escape) {
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(escape, "escape is null");
        Preconditions.checkArgument((!escape.isEmpty() ? 1 : 0) != 0, (Object)"Escape string must not be empty");
        Preconditions.checkArgument((!escape.equals("_") ? 1 : 0) != 0, (Object)"Escape string must not be '_'");
        Preconditions.checkArgument((!escape.equals("%") ? 1 : 0) != 0, (Object)"Escape string must not be '%'");
        name = name.replace(escape, escape + escape);
        name = name.replace("_", escape + "_");
        name = name.replace("%", escape + "%");
        return name;
    }

    private static RemoteTableName getRemoteTable(ResultSet resultSet) throws SQLException {
        return new RemoteTableName(Optional.ofNullable(resultSet.getString("TABLE_CAT")), Optional.ofNullable(resultSet.getString("TABLE_SCHEM")), resultSet.getString("TABLE_NAME"));
    }

    @FunctionalInterface
    public static interface TopNFunction {
        public String apply(String var1, List<JdbcSortItem> var2, long var3);

        public static TopNFunction sqlStandard(Function<String, String> quote) {
            return (query, sortItems, limit) -> {
                String orderBy = sortItems.stream().map(sortItem -> {
                    String ordering = sortItem.getSortOrder().isAscending() ? "ASC" : "DESC";
                    String nullsHandling = sortItem.getSortOrder().isNullsFirst() ? "NULLS FIRST" : "NULLS LAST";
                    return String.format("%s %s %s", quote.apply(sortItem.getColumn().getColumnName()), ordering, nullsHandling);
                }).collect(Collectors.joining(", "));
                return String.format("%s ORDER BY %s OFFSET 0 ROWS FETCH NEXT %s ROWS ONLY", query, orderBy, limit);
            };
        }
    }
}

