/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.base.Preconditions;
import io.trino.plugin.jdbc.ConnectionFactory;
import io.trino.plugin.jdbc.ForLazyConnectionFactory;
import io.trino.plugin.jdbc.ForwardingConnection;
import io.trino.spi.connector.ConnectorSession;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;

@ThreadSafe
public final class LazyConnectionFactory
implements ConnectionFactory {
    private final ConnectionFactory delegate;

    @Inject
    public LazyConnectionFactory(@ForLazyConnectionFactory ConnectionFactory delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
    }

    @Override
    public Connection openConnection(ConnectorSession session) throws SQLException {
        return new LazyConnection(() -> this.delegate.openConnection(session));
    }

    @Override
    public void close() throws SQLException {
        this.delegate.close();
    }

    private static final class LazyConnection
    extends ForwardingConnection {
        private final SqlSupplier<Connection> connectionSupplier;
        @Nullable
        @GuardedBy(value="this")
        private Connection connection;
        @GuardedBy(value="this")
        private boolean closed;

        public LazyConnection(SqlSupplier<Connection> connectionSupplier) {
            this.connectionSupplier = Objects.requireNonNull(connectionSupplier, "connectionSupplier is null");
        }

        @Override
        protected synchronized Connection getDelegate() throws SQLException {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Connection is already closed");
            if (this.connection == null) {
                this.connection = Objects.requireNonNull(this.connectionSupplier.get(), "connectionSupplier.get() is null");
            }
            return this.connection;
        }

        @Override
        public synchronized void close() throws SQLException {
            this.closed = true;
            if (this.connection != null) {
                this.connection.close();
            }
        }
    }

    @FunctionalInterface
    private static interface SqlSupplier<T> {
        public T get() throws SQLException;
    }
}

