/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

public class BaseJdbcConfig {
    public static final String METADATA_CACHE_TTL = "metadata.cache-ttl";
    public static final String METADATA_CACHE_MAXIMUM_SIZE = "metadata.cache-maximum-size";
    private String connectionUrl;
    private Set<String> jdbcTypesMappedToVarchar = ImmutableSet.of();
    public static final Duration CACHING_DISABLED = new Duration(0.0, TimeUnit.MILLISECONDS);
    private Duration metadataCacheTtl = CACHING_DISABLED;
    private boolean cacheMissing;
    public static final long DEFAULT_METADATA_CACHE_SIZE = 10000L;
    private long cacheMaximumSize = 10000L;

    @NotNull
    @Pattern(regexp="^jdbc:[a-z0-9]+:(?s:.*)$", flags={Pattern.Flag.CASE_INSENSITIVE})
    public @NotNull @Pattern(regexp="^jdbc:[a-z0-9]+:(?s:.*)$", flags={Pattern.Flag.CASE_INSENSITIVE}) String getConnectionUrl() {
        return this.connectionUrl;
    }

    @Config(value="connection-url")
    public BaseJdbcConfig setConnectionUrl(String connectionUrl) {
        this.connectionUrl = connectionUrl;
        return this;
    }

    public Set<String> getJdbcTypesMappedToVarchar() {
        return this.jdbcTypesMappedToVarchar;
    }

    @Config(value="jdbc-types-mapped-to-varchar")
    public BaseJdbcConfig setJdbcTypesMappedToVarchar(String jdbcTypesMappedToVarchar) {
        this.jdbcTypesMappedToVarchar = ImmutableSet.copyOf((Iterable)Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)Strings.nullToEmpty((String)jdbcTypesMappedToVarchar)));
        return this;
    }

    @NotNull
    @MinDuration(value="0ms")
    public @NotNull @MinDuration(value="0ms") Duration getMetadataCacheTtl() {
        return this.metadataCacheTtl;
    }

    @Config(value="metadata.cache-ttl")
    @ConfigDescription(value="Determines how long meta information will be cached")
    public BaseJdbcConfig setMetadataCacheTtl(Duration metadataCacheTtl) {
        this.metadataCacheTtl = metadataCacheTtl;
        return this;
    }

    public boolean isCacheMissing() {
        return this.cacheMissing;
    }

    @Config(value="metadata.cache-missing")
    @ConfigDescription(value="Determines if missing information will be cached")
    public BaseJdbcConfig setCacheMissing(boolean cacheMissing) {
        this.cacheMissing = cacheMissing;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) long getCacheMaximumSize() {
        return this.cacheMaximumSize;
    }

    @Config(value="metadata.cache-maximum-size")
    @ConfigDescription(value="Maximum number of objects stored in the metadata cache")
    public BaseJdbcConfig setCacheMaximumSize(long cacheMaximumSize) {
        this.cacheMaximumSize = cacheMaximumSize;
        return this;
    }

    @PostConstruct
    public void validate() {
        if (this.metadataCacheTtl.equals((Object)CACHING_DISABLED) && this.cacheMaximumSize != 10000L) {
            throw new IllegalArgumentException(String.format("%s must be set to a non-zero value when %s is set", METADATA_CACHE_TTL, METADATA_CACHE_MAXIMUM_SIZE));
        }
    }
}

