/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalCause;
import com.google.common.cache.RemovalNotification;
import io.trino.plugin.jdbc.ConnectionFactory;
import io.trino.plugin.jdbc.ForReusableConnectionFactory;
import io.trino.plugin.jdbc.ForwardingConnection;
import io.trino.plugin.jdbc.JdbcErrorCode;
import io.trino.plugin.jdbc.JdbcQueryEventListener;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.Duration;
import java.util.Objects;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;
import org.gaul.modernizer_maven_annotations.SuppressModernizer;

@ThreadSafe
public final class ReusableConnectionFactory
implements ConnectionFactory,
JdbcQueryEventListener {
    @GuardedBy(value="this")
    private final Cache<String, Connection> connections;
    private final ConnectionFactory delegate;

    @Inject
    public ReusableConnectionFactory(@ForReusableConnectionFactory ConnectionFactory delegate) {
        this(delegate, Duration.ofSeconds(2L), 10L);
    }

    ReusableConnectionFactory(ConnectionFactory delegate, Duration duration, long maximumSize) {
        this.connections = ReusableConnectionFactory.createConnectionsCache(duration, maximumSize);
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
    }

    @SuppressModernizer
    private static Cache<String, Connection> createConnectionsCache(Duration duration, long maximumSize) {
        Objects.requireNonNull(duration, "duration is null");
        return CacheBuilder.newBuilder().maximumSize(maximumSize).expireAfterWrite(duration).removalListener(ReusableConnectionFactory::onRemoval).build();
    }

    private static void onRemoval(RemovalNotification<String, Connection> notification) {
        if (notification.getCause() == RemovalCause.EXPLICIT) {
            return;
        }
        try {
            Objects.requireNonNull((Connection)notification.getValue(), "notification.getValue() is null");
            ((Connection)notification.getValue()).close();
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    @Override
    public Connection openConnection(ConnectorSession session) throws SQLException {
        String queryId = session.getQueryId();
        Connection connection = this.getConnection(session, queryId);
        return new CachedConnection(queryId, connection);
    }

    private Connection getConnection(ConnectorSession session, String queryId) throws SQLException {
        Connection connection = (Connection)this.connections.asMap().remove(queryId);
        if (connection != null) {
            return connection;
        }
        return this.delegate.openConnection(session);
    }

    @Override
    public void beginQuery(ConnectorSession session) {
    }

    @Override
    public void cleanupQuery(ConnectorSession session) {
        Connection connection = (Connection)this.connections.asMap().remove(session.getQueryId());
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
            }
        }
    }

    @Override
    public void close() throws SQLException {
        for (Connection connection : this.connections.asMap().values()) {
            connection.close();
        }
        this.connections.invalidateAll();
        this.delegate.close();
    }

    private final class CachedConnection
    extends ForwardingConnection {
        private final String queryId;
        private final Connection delegate;
        private volatile boolean closed;
        private volatile boolean dirty;

        private CachedConnection(String queryId, Connection delegate) {
            this.queryId = Objects.requireNonNull(queryId, "queryId is null");
            this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        }

        @Override
        protected Connection delegate() {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Connection is already closed");
            return this.delegate;
        }

        @Override
        public void setAutoCommit(boolean autoCommit) throws SQLException {
            this.dirty = true;
            super.setAutoCommit(autoCommit);
        }

        @Override
        public void setReadOnly(boolean readOnly) throws SQLException {
            this.dirty = true;
            super.setReadOnly(readOnly);
        }

        @Override
        public void close() throws SQLException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this.dirty) {
                this.delegate.close();
            } else {
                ReusableConnectionFactory.this.connections.put((Object)this.queryId, (Object)this.delegate);
            }
        }
    }
}

