/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc.expression;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.trino.plugin.base.expression.ConnectorExpressionRewriter;
import io.trino.plugin.base.expression.ConnectorExpressionRule;
import io.trino.plugin.jdbc.expression.GenericRewrite;
import io.trino.plugin.jdbc.expression.RewriteAnd;
import io.trino.plugin.jdbc.expression.RewriteExactNumericConstant;
import io.trino.plugin.jdbc.expression.RewriteOr;
import io.trino.plugin.jdbc.expression.RewriteVarcharConstant;
import io.trino.plugin.jdbc.expression.RewriteVariable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;

public class JdbcConnectorExpressionRewriterBuilder {
    private final ImmutableSet.Builder<ConnectorExpressionRule<?, String>> rules = ImmutableSet.builder();
    private final Map<String, Set<String>> typeClasses = new HashMap<String, Set<String>>();

    public static JdbcConnectorExpressionRewriterBuilder newBuilder() {
        return new JdbcConnectorExpressionRewriterBuilder();
    }

    private JdbcConnectorExpressionRewriterBuilder() {
    }

    public JdbcConnectorExpressionRewriterBuilder addStandardRules(Function<String, String> identifierQuote) {
        this.add(new RewriteVariable(identifierQuote));
        this.add(new RewriteVarcharConstant());
        this.add(new RewriteExactNumericConstant());
        this.add(new RewriteAnd());
        this.add(new RewriteOr());
        return this;
    }

    public JdbcConnectorExpressionRewriterBuilder add(ConnectorExpressionRule<?, String> rule) {
        this.rules.add(rule);
        return this;
    }

    public JdbcConnectorExpressionRewriterBuilder withTypeClass(String typeClass, Set<String> typeNames) {
        Objects.requireNonNull(typeClass, "typeClass is null");
        Preconditions.checkArgument((!typeNames.isEmpty() ? 1 : 0) != 0, (Object)"No typeNames");
        Preconditions.checkState((!this.typeClasses.containsKey(typeClass) ? 1 : 0) != 0, (Object)"typeClass already defined");
        this.typeClasses.put(typeClass, (Set<String>)ImmutableSet.copyOf(typeNames));
        return this;
    }

    public ExpressionMapping<JdbcConnectorExpressionRewriterBuilder> map(final String expressionPattern) {
        return new ExpressionMapping<JdbcConnectorExpressionRewriterBuilder>(){

            @Override
            public JdbcConnectorExpressionRewriterBuilder to(String rewritePattern) {
                JdbcConnectorExpressionRewriterBuilder.this.rules.add((Object)new GenericRewrite(JdbcConnectorExpressionRewriterBuilder.this.typeClasses, expressionPattern, rewritePattern));
                return JdbcConnectorExpressionRewriterBuilder.this;
            }
        };
    }

    public ConnectorExpressionRewriter<String> build() {
        return new ConnectorExpressionRewriter((Set)this.rules.build());
    }

    public static interface ExpressionMapping<Continuation> {
        public Continuation to(String var1);
    }
}

