/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc.expression;

import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.plugin.base.expression.ConnectorExpressionPatterns;
import io.trino.plugin.base.expression.ConnectorExpressionRule;
import io.trino.spi.expression.Constant;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.Int128;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import java.util.Optional;

public class RewriteExactNumericConstant
implements ConnectorExpressionRule<Constant, String> {
    private static final Pattern<Constant> PATTERN = ConnectorExpressionPatterns.constant().with(ConnectorExpressionPatterns.type().matching(type -> type == TinyintType.TINYINT || type == SmallintType.SMALLINT || type == IntegerType.INTEGER || type == BigintType.BIGINT || type instanceof DecimalType));

    public Pattern<Constant> getPattern() {
        return PATTERN;
    }

    public Optional<String> rewrite(Constant constant, Captures captures, ConnectorExpressionRule.RewriteContext<String> context) {
        if (constant.getValue() == null) {
            return Optional.empty();
        }
        Type type = constant.getType();
        if (constant.getValue() == null) {
            return Optional.empty();
        }
        if (type == TinyintType.TINYINT || type == SmallintType.SMALLINT || type == IntegerType.INTEGER || type == BigintType.BIGINT) {
            return Optional.of(Long.toString((Long)constant.getValue()));
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            if (decimalType.isShort()) {
                return Optional.of(Decimals.toString((long)((Long)constant.getValue()), (int)decimalType.getScale()));
            }
            return Optional.of(Decimals.toString((Int128)((Int128)constant.getValue()), (int)decimalType.getScale()));
        }
        throw new UnsupportedOperationException("Unsupported type: " + type);
    }
}

