/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc.expression;

import com.google.common.base.Joiner;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.plugin.base.expression.ConnectorExpressionPatterns;
import io.trino.plugin.base.expression.ConnectorExpressionRule;
import io.trino.plugin.jdbc.JdbcMetadataSessionProperties;
import io.trino.spi.expression.Call;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.expression.StandardFunctions;
import io.trino.spi.type.BooleanType;
import java.util.List;
import java.util.Optional;

public class RewriteIn
implements ConnectorExpressionRule<Call, String> {
    private static final Capture<ConnectorExpression> VALUE = Capture.newCapture();
    private static final Capture<List<ConnectorExpression>> EXPRESSIONS = Capture.newCapture();
    private static final Pattern<Call> PATTERN = ConnectorExpressionPatterns.call().with(ConnectorExpressionPatterns.functionName().equalTo((Object)StandardFunctions.IN_PREDICATE_FUNCTION_NAME)).with(ConnectorExpressionPatterns.type().equalTo((Object)BooleanType.BOOLEAN)).with(ConnectorExpressionPatterns.argumentCount().equalTo((Object)2)).with(ConnectorExpressionPatterns.argument((int)0).matching(ConnectorExpressionPatterns.expression().capturedAs(VALUE))).with(ConnectorExpressionPatterns.argument((int)1).matching(ConnectorExpressionPatterns.call().with(ConnectorExpressionPatterns.functionName().equalTo((Object)StandardFunctions.ARRAY_CONSTRUCTOR_FUNCTION_NAME)).with(ConnectorExpressionPatterns.arguments().capturedAs(EXPRESSIONS))));

    public Pattern<Call> getPattern() {
        return PATTERN;
    }

    public Optional<String> rewrite(Call call, Captures captures, ConnectorExpressionRule.RewriteContext<String> context) {
        Optional value = context.defaultRewrite((ConnectorExpression)captures.get(VALUE));
        if (value.isEmpty()) {
            return Optional.empty();
        }
        List expressions = (List)captures.get(EXPRESSIONS);
        if (expressions.size() > JdbcMetadataSessionProperties.getDomainCompactionThreshold(context.getSession())) {
            return Optional.empty();
        }
        ImmutableList.Builder rewrittenValues = ImmutableList.builderWithExpectedSize((int)expressions.size());
        for (ConnectorExpression expression : expressions) {
            Optional rewrittenExpression = context.defaultRewrite(expression);
            if (rewrittenExpression.isEmpty()) {
                return Optional.empty();
            }
            rewrittenValues.add((Object)((String)rewrittenExpression.get()));
        }
        ImmutableList values = rewrittenValues.build();
        Verify.verify((!values.isEmpty() ? 1 : 0) != 0, (String)"Empty values", (Object[])new Object[0]);
        return Optional.of(String.format("(%s) IN (%s)", value.get(), Joiner.on((String)", ").join((Iterable)values)));
    }
}

