/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc.mapping;

import io.trino.plugin.jdbc.JdbcErrorCode;
import io.trino.plugin.jdbc.mapping.IdentifierMapping;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.security.ConnectorIdentity;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Locale;

public class DefaultIdentifierMapping
implements IdentifierMapping {
    private Boolean storesUpperCaseIdentifiers;

    @Override
    public String fromRemoteSchemaName(String remoteSchemaName) {
        return remoteSchemaName.toLowerCase(Locale.ENGLISH);
    }

    @Override
    public String fromRemoteTableName(String remoteSchemaName, String remoteTableName) {
        return remoteTableName.toLowerCase(Locale.ENGLISH);
    }

    @Override
    public String fromRemoteColumnName(String remoteColumnName) {
        return remoteColumnName.toLowerCase(Locale.ENGLISH);
    }

    @Override
    public String toRemoteSchemaName(ConnectorIdentity identity, Connection connection, String schemaName) {
        return this.toRemoteIdentifier(connection, schemaName);
    }

    @Override
    public String toRemoteTableName(ConnectorIdentity identity, Connection connection, String remoteSchema, String tableName) {
        return this.toRemoteIdentifier(connection, tableName);
    }

    @Override
    public String toRemoteColumnName(Connection connection, String columnName) {
        return this.toRemoteIdentifier(connection, columnName);
    }

    private String toRemoteIdentifier(Connection connection, String identifier) {
        if (this.storesUpperCaseIdentifiers(connection)) {
            return identifier.toUpperCase(Locale.ENGLISH);
        }
        return identifier;
    }

    private boolean storesUpperCaseIdentifiers(Connection connection) {
        if (this.storesUpperCaseIdentifiers != null) {
            return this.storesUpperCaseIdentifiers;
        }
        try {
            DatabaseMetaData metadata = connection.getMetaData();
            this.storesUpperCaseIdentifiers = metadata.storesUpperCaseIdentifiers();
            return this.storesUpperCaseIdentifiers;
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }
}

