/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.redshift;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.trino.plugin.jdbc.ConnectionFactory;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcTableHandle;
import io.trino.plugin.jdbc.RemoteTableName;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.statistics.ColumnStatistics;
import io.trino.spi.statistics.Estimate;
import io.trino.spi.statistics.TableStatistics;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.Query;

public class RedshiftTableStatisticsReader {
    private final ConnectionFactory connectionFactory;

    public RedshiftTableStatisticsReader(ConnectionFactory connectionFactory) {
        this.connectionFactory = Objects.requireNonNull(connectionFactory, "connectionFactory is null");
    }

    public TableStatistics readTableStatistics(ConnectorSession session, JdbcTableHandle table, Supplier<List<JdbcColumnHandle>> columnSupplier) throws SQLException {
        Preconditions.checkArgument((boolean)table.isNamedRelation(), (String)"Relation is not a table: %s", (Object)table);
        try (Connection connection = this.connectionFactory.openConnection(session);){
            TableStatistics tableStatistics;
            block21: {
                TableStatistics.Builder tableStatistics2;
                long rowCount;
                RemoteTableName remoteTableName;
                StatisticsDao statisticsDao;
                Handle handle;
                block19: {
                    TableStatistics tableStatistics3;
                    block20: {
                        Optional<Long> optionalRowCount;
                        block17: {
                            TableStatistics tableStatistics4;
                            block18: {
                                handle = Jdbi.open((Connection)connection);
                                statisticsDao = new StatisticsDao(handle);
                                remoteTableName = table.getRequiredNamedRelation().getRemoteTableName();
                                optionalRowCount = RedshiftTableStatisticsReader.readRowCountTableStat(statisticsDao, table);
                                if (!optionalRowCount.isEmpty()) break block17;
                                tableStatistics4 = TableStatistics.empty();
                                if (handle == null) break block18;
                                handle.close();
                            }
                            return tableStatistics4;
                        }
                        rowCount = optionalRowCount.get();
                        tableStatistics2 = TableStatistics.builder().setRowCount(Estimate.of((double)rowCount));
                        if (rowCount != 0L) break block19;
                        tableStatistics3 = tableStatistics2.build();
                        if (handle == null) break block20;
                        handle.close();
                    }
                    return tableStatistics3;
                }
                try {
                    Map columnStatistics = (Map)statisticsDao.getColumnStatistics(remoteTableName.getSchemaName().orElse(null), remoteTableName.getTableName()).stream().collect(ImmutableMap.toImmutableMap(ColumnStatisticsResult::columnName, Function.identity()));
                    for (JdbcColumnHandle column : columnSupplier.get()) {
                        ColumnStatisticsResult result = (ColumnStatisticsResult)columnStatistics.get(column.getColumnName());
                        if (result == null) continue;
                        ColumnStatistics statistics = ColumnStatistics.builder().setNullsFraction(result.nullsFraction().map(Estimate::of).orElseGet(Estimate::unknown)).setDistinctValuesCount(result.distinctValuesIndicator().map(distinctValuesIndicator -> {
                            if ((double)distinctValuesIndicator.floatValue() < 0.0) {
                                return Float.valueOf(Math.min(-distinctValuesIndicator.floatValue() * (float)rowCount, (float)rowCount));
                            }
                            return distinctValuesIndicator;
                        }).map(Estimate::of).orElseGet(Estimate::unknown)).setDataSize(result.averageColumnLength().flatMap(averageColumnLength -> result.nullsFraction().map(nullsFraction -> 1.0 * (double)averageColumnLength.intValue() * (double)rowCount * (double)(1.0f - nullsFraction.floatValue())).map(Estimate::of)).orElseGet(Estimate::unknown)).build();
                        tableStatistics2.setColumnStatistics((ColumnHandle)column, statistics);
                    }
                    tableStatistics = tableStatistics2.build();
                    if (handle == null) break block21;
                }
                catch (Throwable throwable) {
                    if (handle != null) {
                        try {
                            handle.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                handle.close();
            }
            return tableStatistics;
        }
    }

    private static Optional<Long> readRowCountTableStat(StatisticsDao statisticsDao, JdbcTableHandle table) {
        RemoteTableName remoteTableName = table.getRequiredNamedRelation().getRemoteTableName();
        Optional<Long> rowCount = statisticsDao.getRowCountFromPgClass(remoteTableName.getSchemaName().orElse(null), remoteTableName.getTableName());
        if (rowCount.isEmpty()) {
            return Optional.empty();
        }
        if (rowCount.get() == 0L) {
            rowCount = statisticsDao.getRowCountFromPgStat(remoteTableName.getSchemaName().orElse(null), remoteTableName.getTableName());
        }
        return rowCount;
    }

    private static class StatisticsDao {
        private final Handle handle;

        public StatisticsDao(Handle handle) {
            this.handle = Objects.requireNonNull(handle, "handle is null");
        }

        Optional<Long> getRowCountFromPgClass(String schema, String tableName) {
            return ((Query)((Query)this.handle.createQuery("SELECT reltuples FROM pg_class WHERE relnamespace = (SELECT oid FROM pg_namespace WHERE nspname = :schema) AND relname = :table_name").bind("schema", schema)).bind("table_name", tableName)).mapTo(Long.class).findOne();
        }

        Optional<Long> getRowCountFromPgStat(String schema, String tableName) {
            return ((Query)((Query)this.handle.createQuery("SELECT n_tup_ins - n_tup_del FROM pg_stat_all_tables WHERE schemaname = :schema AND relname = :table_name").bind("schema", schema)).bind("table_name", tableName)).mapTo(Long.class).findOne();
        }

        List<ColumnStatisticsResult> getColumnStatistics(String schema, String tableName) {
            return ((Query)((Query)this.handle.createQuery("SELECT attname, null_frac, n_distinct, avg_width FROM pg_stats WHERE schemaname = :schema AND tablename = :table_name").bind("schema", schema)).bind("table_name", tableName)).map((rs, ctx) -> new ColumnStatisticsResult(Objects.requireNonNull(rs.getString("attname"), "attname is null"), Optional.of(Float.valueOf(rs.getFloat("null_frac"))), Optional.of(Float.valueOf(rs.getFloat("n_distinct"))), Optional.of(rs.getInt("avg_width")))).list();
        }
    }

    private record ColumnStatisticsResult(String columnName, Optional<Float> nullsFraction, Optional<Float> distinctValuesIndicator, Optional<Integer> averageColumnLength) {
    }
}

