/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector;

import com.google.common.base.MoreObjects;
import io.airlift.units.DataSize;
import io.trino.ExceededMemoryLimitException;
import io.trino.connector.ConnectorServices;
import io.trino.memory.LocalMemoryManager;
import io.trino.memory.MemoryPool;
import io.trino.metadata.Catalog;
import io.trino.spi.catalog.CatalogProperties;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.ConnectorName;
import java.util.Objects;
import java.util.Optional;

public class CatalogConnector {
    private final CatalogHandle catalogHandle;
    private final ConnectorName connectorName;
    private final ConnectorServices catalogConnector;
    private final ConnectorServices informationSchemaConnector;
    private final ConnectorServices systemConnector;
    private final Optional<CatalogProperties> catalogProperties;
    private final Catalog catalog;
    private final LocalMemoryManager localMemoryManager;
    private final long connectorMemory;

    public CatalogConnector(CatalogHandle catalogHandle, ConnectorName connectorName, ConnectorServices catalogConnector, ConnectorServices informationSchemaConnector, ConnectorServices systemConnector, LocalMemoryManager localMemoryManager, Optional<CatalogProperties> catalogProperties) {
        this.catalogHandle = Objects.requireNonNull(catalogHandle, "catalogHandle is null");
        this.connectorName = Objects.requireNonNull(connectorName, "connectorName is null");
        this.catalogConnector = Objects.requireNonNull(catalogConnector, "catalogConnector is null");
        this.informationSchemaConnector = Objects.requireNonNull(informationSchemaConnector, "informationSchemaConnector is null");
        this.systemConnector = Objects.requireNonNull(systemConnector, "systemConnector is null");
        this.localMemoryManager = Objects.requireNonNull(localMemoryManager, "localMemoryManager is null");
        this.catalogProperties = Objects.requireNonNull(catalogProperties, "catalogProperties is null");
        this.connectorMemory = catalogConnector.getConnector().getInitialMemoryRequirement();
        MemoryPool memoryPool = localMemoryManager.getMemoryPool();
        boolean success = memoryPool.tryReserveConnectorMemory(this.connectorMemory);
        if (!success) {
            String info = String.format("tried to reserve %s for connector %s", DataSize.succinctBytes((long)this.connectorMemory), connectorName);
            throw ExceededMemoryLimitException.exceededLocalUserMemoryLimit(DataSize.succinctBytes((long)memoryPool.getMaxBytes()), info);
        }
        this.catalog = new Catalog(catalogHandle.getCatalogName(), catalogHandle, connectorName, catalogConnector, informationSchemaConnector, systemConnector);
    }

    public CatalogHandle getCatalogHandle() {
        return this.catalogHandle;
    }

    public ConnectorName getConnectorName() {
        return this.connectorName;
    }

    public Optional<CatalogProperties> getCatalogProperties() {
        return this.catalogProperties;
    }

    public Catalog getCatalog() {
        return this.catalog;
    }

    public ConnectorServices getMaterializedConnector(CatalogHandle.CatalogHandleType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case CatalogHandle.CatalogHandleType.NORMAL -> this.catalogConnector;
            case CatalogHandle.CatalogHandleType.INFORMATION_SCHEMA -> this.informationSchemaConnector;
            case CatalogHandle.CatalogHandleType.SYSTEM -> this.systemConnector;
        };
    }

    public void shutdown() {
        this.localMemoryManager.getMemoryPool().freeConnectorMemory(this.connectorMemory);
        this.catalogConnector.shutdown();
        this.informationSchemaConnector.shutdown();
        this.systemConnector.shutdown();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("catalogHandle", (Object)this.catalogHandle).add("connectorName", (Object)this.connectorName).toString();
    }
}

