/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector;

import com.google.common.collect.ImmutableList;
import io.trino.connector.FileCatalogStore;
import io.trino.spi.catalog.CatalogName;
import io.trino.spi.catalog.CatalogProperties;
import io.trino.spi.catalog.CatalogStore;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.ConnectorName;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class InMemoryCatalogStore
implements CatalogStore {
    private final ConcurrentMap<CatalogName, CatalogStore.StoredCatalog> catalogs = new ConcurrentHashMap<CatalogName, CatalogStore.StoredCatalog>();

    public Collection<CatalogStore.StoredCatalog> getCatalogs() {
        return ImmutableList.copyOf(this.catalogs.values());
    }

    public CatalogProperties createCatalogProperties(CatalogName catalogName, ConnectorName connectorName, Map<String, String> properties) {
        return new CatalogProperties(CatalogHandle.createRootCatalogHandle((CatalogName)catalogName, (CatalogHandle.CatalogVersion)FileCatalogStore.computeCatalogVersion(catalogName, connectorName, properties)), connectorName, properties);
    }

    public void addOrReplaceCatalog(CatalogProperties catalogProperties) {
        CatalogName catalogName = catalogProperties.catalogHandle().getCatalogName();
        this.catalogs.put(catalogName, new InMemoryStoredCatalog(catalogName, catalogProperties));
    }

    public void removeCatalog(CatalogName catalogName) {
        this.catalogs.remove(catalogName);
    }

    private static class InMemoryStoredCatalog
    implements CatalogStore.StoredCatalog {
        private final CatalogName catalogName;
        private final CatalogProperties catalogProperties;

        public InMemoryStoredCatalog(CatalogName catalogName, CatalogProperties catalogProperties) {
            this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
            this.catalogProperties = Objects.requireNonNull(catalogProperties, "catalogProperties is null");
        }

        public CatalogName name() {
            return this.catalogName;
        }

        public CatalogProperties loadProperties() {
            return this.catalogProperties;
        }
    }
}

