/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector.informationschema;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.FullConnectorSession;
import io.trino.Session;
import io.trino.connector.informationschema.InformationSchemaColumnHandle;
import io.trino.connector.informationschema.InformationSchemaTable;
import io.trino.connector.informationschema.InformationSchemaTableHandle;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataUtil;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.QualifiedTablePrefix;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTableProperties;
import io.trino.spi.connector.ConnectorTableVersion;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.ConstraintApplicationResult;
import io.trino.spi.connector.LimitApplicationResult;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SchemaTablePrefix;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.EquatableValueSet;
import io.trino.spi.predicate.NullableValue;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.SortedRangeSet;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class InformationSchemaMetadata
implements ConnectorMetadata {
    private static final InformationSchemaColumnHandle CATALOG_COLUMN_HANDLE = new InformationSchemaColumnHandle("table_catalog");
    private static final InformationSchemaColumnHandle SCHEMA_COLUMN_HANDLE = new InformationSchemaColumnHandle("table_schema");
    private static final InformationSchemaColumnHandle TABLE_NAME_COLUMN_HANDLE = new InformationSchemaColumnHandle("table_name");
    private final String catalogName;
    private final Metadata metadata;
    private final int maxPrefetchedInformationSchemaPrefixes;

    public InformationSchemaMetadata(String catalogName, Metadata metadata, int maxPrefetchedInformationSchemaPrefixes) {
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.maxPrefetchedInformationSchemaPrefixes = maxPrefetchedInformationSchemaPrefixes;
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return ImmutableList.of((Object)"information_schema");
    }

    public ConnectorTableHandle getTableHandle(ConnectorSession connectorSession, SchemaTableName tableName, Optional<ConnectorTableVersion> startVersion, Optional<ConnectorTableVersion> endVersion) {
        if (startVersion.isPresent() || endVersion.isPresent()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support versioned tables");
        }
        return InformationSchemaTable.of(tableName).map(table -> new InformationSchemaTableHandle(this.catalogName, (InformationSchemaTable)((Object)table), InformationSchemaMetadata.defaultPrefixes(this.catalogName), OptionalLong.empty())).orElse(null);
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle tableHandle) {
        InformationSchemaTableHandle informationSchemaTableHandle = (InformationSchemaTableHandle)tableHandle;
        return informationSchemaTableHandle.table().getTableMetadata();
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaName) {
        if (schemaName.isPresent() && !schemaName.get().equals("information_schema")) {
            return ImmutableList.of();
        }
        return (List)Arrays.stream(InformationSchemaTable.values()).map(InformationSchemaTable::getSchemaTableName).collect(ImmutableList.toImmutableList());
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        String columnName;
        InformationSchemaTableHandle informationSchemaTableHandle = (InformationSchemaTableHandle)tableHandle;
        ConnectorTableMetadata tableMetadata = informationSchemaTableHandle.table().getTableMetadata();
        ColumnMetadata columnMetadata = MetadataUtil.findColumnMetadata(tableMetadata, columnName = ((InformationSchemaColumnHandle)columnHandle).columnName());
        Preconditions.checkArgument((columnMetadata != null ? 1 : 0) != 0, (String)"Column '%s' on table '%s' does not exist", (Object)columnName, (Object)tableMetadata.getTable());
        return columnMetadata;
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        InformationSchemaTableHandle informationSchemaTableHandle = (InformationSchemaTableHandle)tableHandle;
        ConnectorTableMetadata tableMetadata = informationSchemaTableHandle.table().getTableMetadata();
        return (Map)tableMetadata.getColumns().stream().map(ColumnMetadata::getName).collect(ImmutableMap.toImmutableMap(Function.identity(), InformationSchemaColumnHandle::new));
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        return (Map)Arrays.stream(InformationSchemaTable.values()).filter(table -> prefix.matches(table.getSchemaTableName())).collect(ImmutableMap.toImmutableMap(InformationSchemaTable::getSchemaTableName, table -> table.getTableMetadata().getColumns()));
    }

    public ConnectorTableProperties getTableProperties(ConnectorSession session, ConnectorTableHandle table) {
        InformationSchemaTableHandle tableHandle = (InformationSchemaTableHandle)table;
        return new ConnectorTableProperties(tableHandle.prefixes().isEmpty() ? TupleDomain.none() : TupleDomain.all(), Optional.empty(), Optional.empty(), Collections.emptyList());
    }

    public Optional<LimitApplicationResult<ConnectorTableHandle>> applyLimit(ConnectorSession session, ConnectorTableHandle handle, long limit) {
        InformationSchemaTableHandle table = (InformationSchemaTableHandle)handle;
        if (table.limit().isPresent() && table.limit().getAsLong() <= limit) {
            return Optional.empty();
        }
        return Optional.of(new LimitApplicationResult((Object)new InformationSchemaTableHandle(table.catalogName(), table.table(), table.prefixes(), OptionalLong.of(limit)), true, false));
    }

    public Optional<ConstraintApplicationResult<ConnectorTableHandle>> applyFilter(ConnectorSession session, ConnectorTableHandle handle, Constraint constraint) {
        InformationSchemaTableHandle table = (InformationSchemaTableHandle)handle;
        Set<QualifiedTablePrefix> prefixes = table.prefixes();
        if (InformationSchemaMetadata.isTablesEnumeratingTable(table.table()) && table.prefixes().equals(InformationSchemaMetadata.defaultPrefixes(this.catalogName))) {
            prefixes = this.getPrefixes(session, table, constraint);
        }
        if (prefixes.equals(table.prefixes())) {
            return Optional.empty();
        }
        table = new InformationSchemaTableHandle(table.catalogName(), table.table(), prefixes, table.limit());
        return Optional.of(new ConstraintApplicationResult((Object)table, constraint.getSummary(), constraint.getExpression(), false));
    }

    public static Set<QualifiedTablePrefix> defaultPrefixes(String catalogName) {
        return ImmutableSet.of((Object)new QualifiedTablePrefix(catalogName));
    }

    private Set<QualifiedTablePrefix> getPrefixes(ConnectorSession session, InformationSchemaTableHandle table, Constraint constraint) {
        Set<QualifiedTablePrefix> schemaPrefixes;
        if (constraint.getSummary().isNone()) {
            return ImmutableSet.of();
        }
        Optional<Set<String>> catalogs = this.filterString(constraint.getSummary(), CATALOG_COLUMN_HANDLE);
        if (catalogs.isPresent() && !catalogs.get().contains(table.catalogName())) {
            return ImmutableSet.of();
        }
        InformationSchemaTable informationSchemaTable = table.table();
        Set<QualifiedTablePrefix> tablePrefixes = this.calculatePrefixesWithTableName(informationSchemaTable, session, schemaPrefixes = this.calculatePrefixesWithSchemaName(session, (TupleDomain<ColumnHandle>)constraint.getSummary(), constraint.predicate()), (TupleDomain<ColumnHandle>)constraint.getSummary(), constraint.predicate());
        Verify.verify((tablePrefixes.size() <= this.maxPrefetchedInformationSchemaPrefixes ? 1 : 0) != 0, (String)"calculatePrefixesWithTableName returned too many prefixes: %s", (int)tablePrefixes.size());
        return tablePrefixes;
    }

    public static boolean isTablesEnumeratingTable(InformationSchemaTable table) {
        return ImmutableSet.of((Object)((Object)InformationSchemaTable.COLUMNS), (Object)((Object)InformationSchemaTable.VIEWS), (Object)((Object)InformationSchemaTable.TABLES), (Object)((Object)InformationSchemaTable.TABLE_PRIVILEGES)).contains((Object)table);
    }

    private Set<QualifiedTablePrefix> calculatePrefixesWithSchemaName(ConnectorSession connectorSession, TupleDomain<ColumnHandle> constraint, Optional<Predicate<Map<ColumnHandle, NullableValue>>> predicate) {
        Optional<Set<String>> schemas = this.filterString(constraint, SCHEMA_COLUMN_HANDLE);
        if (schemas.isPresent()) {
            Set schemasFromPredicate = (Set)schemas.get().stream().filter(this::isLowerCase).filter(schema -> predicate.isEmpty() || ((Predicate)predicate.get()).test(this.schemaAsFixedValues((String)schema))).map(schema -> new QualifiedTablePrefix(this.catalogName, (String)schema)).collect(ImmutableSet.toImmutableSet());
            if (schemasFromPredicate.size() > this.maxPrefetchedInformationSchemaPrefixes) {
                return ImmutableSet.of((Object)new QualifiedTablePrefix(this.catalogName));
            }
            return schemasFromPredicate;
        }
        if (predicate.isEmpty()) {
            return ImmutableSet.of((Object)new QualifiedTablePrefix(this.catalogName));
        }
        Session session = ((FullConnectorSession)connectorSession).getSession();
        Set schemaPrefixes = (Set)this.listSchemaNames(session).filter(prefix -> ((Predicate)predicate.get()).test(this.schemaAsFixedValues(prefix.getSchemaName().get()))).collect(ImmutableSet.toImmutableSet());
        if (schemaPrefixes.size() > this.maxPrefetchedInformationSchemaPrefixes) {
            return InformationSchemaMetadata.defaultPrefixes(this.catalogName);
        }
        return schemaPrefixes;
    }

    private Set<QualifiedTablePrefix> calculatePrefixesWithTableName(InformationSchemaTable informationSchemaTable, ConnectorSession connectorSession, Set<QualifiedTablePrefix> prefixes, TupleDomain<ColumnHandle> constraint, Optional<Predicate<Map<ColumnHandle, NullableValue>>> predicate) {
        Session session = ((FullConnectorSession)connectorSession).getSession();
        Optional<Set<String>> tables = this.filterString(constraint, TABLE_NAME_COLUMN_HANDLE);
        if (tables.isPresent()) {
            Set tablePrefixes = (Set)prefixes.stream().peek(prefix -> Verify.verify((boolean)prefix.asQualifiedObjectName().isEmpty())).flatMap(prefix -> prefix.getSchemaName().map(schemaName -> Stream.of(prefix)).orElseGet(() -> this.listSchemaNames(session))).flatMap(prefix -> ((Set)tables.get()).stream().filter(this::isLowerCase).map(table -> new QualifiedObjectName(this.catalogName, prefix.getSchemaName().get(), (String)table))).filter(objectName -> predicate.isEmpty() || ((Predicate)predicate.get()).test(this.asFixedValues((QualifiedObjectName)objectName))).map(QualifiedObjectName::asQualifiedTablePrefix).distinct().limit(this.maxPrefetchedInformationSchemaPrefixes + 1).collect(ImmutableSet.toImmutableSet());
            if (tablePrefixes.size() > this.maxPrefetchedInformationSchemaPrefixes) {
                return InformationSchemaMetadata.defaultPrefixes(this.catalogName);
            }
            return tablePrefixes;
        }
        if (predicate.isEmpty() || !this.isColumnsEnumeratingTable(informationSchemaTable)) {
            return prefixes;
        }
        Set tablePrefixes = (Set)prefixes.stream().flatMap(prefix -> this.metadata.listTables(session, (QualifiedTablePrefix)prefix).stream()).filter(objectName -> ((Predicate)predicate.get()).test(this.asFixedValues((QualifiedObjectName)objectName))).map(QualifiedObjectName::asQualifiedTablePrefix).distinct().limit(this.maxPrefetchedInformationSchemaPrefixes + 1).collect(ImmutableSet.toImmutableSet());
        if (tablePrefixes.size() > this.maxPrefetchedInformationSchemaPrefixes) {
            return InformationSchemaMetadata.defaultPrefixes(this.catalogName);
        }
        return tablePrefixes;
    }

    private boolean isColumnsEnumeratingTable(InformationSchemaTable table) {
        return InformationSchemaTable.COLUMNS == table;
    }

    private Stream<QualifiedTablePrefix> listSchemaNames(Session session) {
        return this.metadata.listSchemaNames(session, this.catalogName).stream().map(schema -> new QualifiedTablePrefix(this.catalogName, (String)schema));
    }

    private <T> Optional<Set<String>> filterString(TupleDomain<T> constraint, T column) {
        if (constraint.isNone()) {
            return Optional.of(ImmutableSet.of());
        }
        Domain domain = (Domain)((Map)constraint.getDomains().get()).get(column);
        if (domain == null) {
            return Optional.empty();
        }
        if (domain.isSingleValue()) {
            return Optional.of(ImmutableSet.of((Object)((Slice)domain.getSingleValue()).toStringUtf8()));
        }
        ValueSet valueSet = domain.getValues();
        if (valueSet instanceof EquatableValueSet) {
            EquatableValueSet set = (EquatableValueSet)valueSet;
            return Optional.of((Set)set.getValues().stream().map(Slice.class::cast).map(Slice::toStringUtf8).collect(ImmutableSet.toImmutableSet()));
        }
        if (domain.getValues() instanceof SortedRangeSet) {
            ImmutableSet.Builder result = ImmutableSet.builder();
            for (Range range : domain.getValues().getRanges().getOrderedRanges()) {
                if (!range.isSingleValue()) {
                    return Optional.empty();
                }
                result.add((Object)((Slice)range.getSingleValue()).toStringUtf8());
            }
            return Optional.of(result.build());
        }
        return Optional.empty();
    }

    private Map<ColumnHandle, NullableValue> schemaAsFixedValues(String schema) {
        return ImmutableMap.of((Object)SCHEMA_COLUMN_HANDLE, (Object)new NullableValue((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)schema)));
    }

    private Map<ColumnHandle, NullableValue> asFixedValues(QualifiedObjectName objectName) {
        return ImmutableMap.of((Object)CATALOG_COLUMN_HANDLE, (Object)new NullableValue((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)objectName.catalogName())), (Object)SCHEMA_COLUMN_HANDLE, (Object)new NullableValue((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)objectName.schemaName())), (Object)TABLE_NAME_COLUMN_HANDLE, (Object)new NullableValue((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)objectName.objectName())));
    }

    private boolean isLowerCase(String value) {
        return value.toLowerCase(Locale.ENGLISH).equals(value);
    }
}

